/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.Random;
import net.gopro.gdf.data.FileAttachmentType;
import net.gopro.gdf.exceptions.GdfServiceException;
import net.gopro.util.AttachmentStoreUtil;
import net.gopro.util.ByteUtils;
import net.gopro.util.ChunkUtil;
import net.gopro.util.ChunkingException;
import org.apache.log4j.Logger;

public class BinaryObjectCache {
    private static final Logger logger = Logger.getLogger(BinaryObjectCache.class);
    private static final int DEFAULT_CHUNK_SIZE = 524288;
    private static final String FILE_EXTENSION = ".gft";
    private String basePath;
    private static long lastCacheCleanupTicks = 0L;

    public BinaryObjectCache(String basePath) {
        if (basePath.indexOf("\\") > -1 && !basePath.endsWith("\\")) {
            basePath = basePath + "\\";
        } else if (basePath.indexOf("/") > -1 && !basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        this.basePath = basePath;
    }

    public void placeObjectInDownloadCache(FileAttachmentType attachment) throws GdfServiceException {
        InputStream inputStream;
        if (attachment != null && attachment.getStream() != null && attachment.getStream().length > 0 && (inputStream = AttachmentStoreUtil.getInputStream(attachment.getStream())) != null) {
            long id = this.storeObjectForDownload(inputStream);
            long streamSize = attachment.getFileSize();
            byte[] createReferenceId = ChunkUtil.createReferenceId(id, streamSize);
            attachment.setStream(createReferenceId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Placed file '%s' of size %d in downloads cache with id %d", attachment.getFileName(), streamSize, id));
            }
        }
    }

    public synchronized byte[] readDownloadChunk(long id, int chunkNumber, int chunkSize) throws ChunkingException {
        byte[] byArray;
        boolean lastChunk;
        File tempFile;
        block14: {
            String filePath = this.buildDownloadObjectPath(id);
            tempFile = new File(filePath);
            lastChunk = false;
            if (!tempFile.exists()) {
                return null;
            }
            RandomAccessFile file = new RandomAccessFile(tempFile, "r");
            byte[] buffer = new byte[chunkSize];
            int offset = chunkNumber * chunkSize;
            file.seek(offset);
            try {
                int totalChunks = (int)file.length() / chunkSize;
                if ((int)file.length() % chunkSize > 0) {
                    ++totalChunks;
                }
                if ((totalChunks <= 1 || chunkNumber >= totalChunks - 1) && (int)file.length() % chunkSize > 0) {
                    byte[] copy = new byte[(int)file.length() % chunkSize];
                    System.arraycopy(buffer, 0, copy, 0, Math.min(buffer.length, copy.length));
                    buffer = copy;
                }
                file.read(buffer);
                boolean bl = lastChunk = chunkNumber == totalChunks - 1;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Returning chunk %d/%d. Lastchunk=%s", chunkNumber + 1, totalChunks, lastChunk));
                }
                byArray = buffer;
                if (file == null) break block14;
            }
            catch (IOException e) {
                try {
                    try {
                        e.printStackTrace();
                        throw new ChunkingException(e);
                    }
                    catch (Throwable throwable) {
                        if (file != null) {
                            file.close();
                        }
                        if (lastChunk) {
                            boolean deleted = tempFile.delete();
                            logger.debug((Object)String.format("Deleting chunk file %s. Success=%s", tempFile.getName(), deleted));
                        }
                        throw throwable;
                    }
                }
                catch (IOException e2) {
                    return null;
                }
            }
            file.close();
        }
        if (lastChunk) {
            boolean deleted = tempFile.delete();
            logger.debug((Object)String.format("Deleting chunk file %s. Success=%s", tempFile.getName(), deleted));
        }
        return byArray;
    }

    public synchronized byte[] readUploadedObject(int crc32, int transactionID) throws ChunkingException {
        String filePath;
        boolean deleteAfterUse = true;
        String containerPath = BinaryObjectCache.combine(this.getUploadPath(), BinaryObjectCache.buildContainerName(crc32, transactionID));
        if (!new File(containerPath).exists()) {
            deleteAfterUse = false;
            containerPath = BinaryObjectCache.combine(this.getUploadPath(), BinaryObjectCache.buildContainerName(crc32));
        }
        if (!new File(containerPath).exists()) {
            throw new ChunkingException("No uploaded object with the the specified CRC-32 and TransactionID combination exists in the upload cache.");
        }
        int chunkCount = -1;
        while (new File(filePath = BinaryObjectCache.combine(containerPath, ++chunkCount + FILE_EXTENSION)).exists()) {
        }
        int objectSize = 0;
        for (int chunkIndex = 0; chunkIndex < chunkCount; ++chunkIndex) {
            filePath = BinaryObjectCache.combine(containerPath, chunkIndex + FILE_EXTENSION);
            File fileInfo = new File(filePath);
            objectSize = (int)((long)objectSize + fileInfo.length());
        }
        byte[] result = null;
        try {
            File tempFile = AttachmentStoreUtil.provideTempFile();
            FileOutputStream completeStream = new FileOutputStream(tempFile);
            for (int chunkIndex = 0; chunkIndex < chunkCount; ++chunkIndex) {
                filePath = BinaryObjectCache.combine(containerPath, chunkIndex + FILE_EXTENSION);
                FileInputStream chunkStream = new FileInputStream(new File(filePath));
                BinaryObjectCache.copyStream(chunkStream, completeStream);
                chunkStream.close();
            }
            ((OutputStream)completeStream).close();
            result = AttachmentStoreUtil.encodeDiskStoreFileName(tempFile.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            throw new ChunkingException("File not found " + filePath);
        }
        catch (IOException e) {
            throw new ChunkingException("Problem reading the " + filePath);
        }
        if (deleteAfterUse) {
            try {
                BinaryObjectCache.deleteFolder(new File(containerPath));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public synchronized int beginUploadTransaction(int crc32) {
        int transactionID = BinaryObjectCache.generateTransactionID();
        while (!this.isTransactionIdUniuqe(crc32, transactionID)) {
            transactionID = BinaryObjectCache.generateTransactionID();
        }
        this.createTransactionContainer(crc32, transactionID);
        return transactionID;
    }

    private static int generateTransactionID() {
        Random random = new Random();
        return random.nextInt(0x7FFFFFFE) + 1;
    }

    private static long generateDownloadID() {
        Random random = new Random();
        byte[] buffer = new byte[8];
        random.nextBytes(buffer);
        return ByteUtils.byteArrayToLong(buffer);
    }

    private void createTransactionContainer(int crc32, int transactionID) {
        String containerName = BinaryObjectCache.buildContainerName(crc32, transactionID);
        File file = new File(BinaryObjectCache.combine(this.getUploadPath(), containerName));
        file.mkdirs();
    }

    private boolean isTransactionIdUniuqe(int crc32, int transactionID) {
        String containerName = BinaryObjectCache.buildContainerName(crc32, transactionID);
        File file = new File(BinaryObjectCache.combine(this.getUploadPath(), containerName));
        return !file.exists();
    }

    private boolean isDownloadIdUniuqe(long id) {
        File file = new File(this.buildDownloadObjectPath(id));
        return !file.exists();
    }

    private static String buildContainerName(int crc32, int transactionID) {
        byte[] crcBytes = ByteUtils.intToByteArray(crc32);
        byte[] transactionIdBytes = ByteUtils.intToByteArray(transactionID);
        byte[] combinedBytes = new byte[crcBytes.length + transactionIdBytes.length];
        System.arraycopy(crcBytes, 0, combinedBytes, 0, crcBytes.length);
        System.arraycopy(transactionIdBytes, 0, combinedBytes, crcBytes.length, transactionIdBytes.length);
        return ByteUtils.getHexString(combinedBytes);
    }

    private String buildDownloadObjectPath(long id) {
        return BinaryObjectCache.combine(this.getDownloadPath(), BinaryObjectCache.buildContainerName(id) + FILE_EXTENSION);
    }

    private static String buildContainerName(long id) {
        byte[] idBytes = ByteUtils.longToByteArray(id);
        return ByteUtils.getHexString(idBytes);
    }

    private static String buildContainerName(int id) {
        byte[] idBytes = ByteUtils.intToByteArray(id);
        return ByteUtils.getHexString(idBytes);
    }

    public int putChunk(int id, byte[] data, int chunkNumber, int totalChunks, int transactionID) throws ChunkingException {
        if (data == null || data.length == 0) {
            throw new ChunkingException("The chunk data cannot be empty");
        }
        if (chunkNumber < 0) {
            throw new ChunkingException("The chunkNumber must be a non-negative integer");
        }
        if (totalChunks < 1) {
            throw new ChunkingException("The totalChunks parameter must be a positive integer");
        }
        if (chunkNumber > 0 && transactionID < 1) {
            throw new ChunkingException("The Transaction ID must be a positive integer for all chunks except the first one");
        }
        if (this.binaryObjectExists(id)) {
            return -1;
        }
        if (chunkNumber == 0) {
            transactionID = this.beginUploadTransaction(id);
        }
        this.storeUploadedChunk(id, data, chunkNumber, totalChunks, transactionID);
        return transactionID;
    }

    public synchronized void storeUploadedChunk(int crc32, byte[] data, int chunkNumber, int totalChunks, int transactionID) throws ChunkingException {
        String committedContainerPath;
        File committedFile;
        String containerPath = BinaryObjectCache.combine(this.getUploadPath(), BinaryObjectCache.buildContainerName(crc32, transactionID));
        String filePath = BinaryObjectCache.combine(containerPath, chunkNumber + FILE_EXTENSION);
        if (new File(filePath).exists()) {
            throw new ChunkingException("A chunk with index " + chunkNumber + " already exists in the upload cache");
        }
        File targetFile = BinaryObjectCache.createNewFile(filePath, chunkNumber);
        BinaryObjectCache.storeChunk(data, targetFile);
        if (BinaryObjectCache.allChunksPresent(containerPath, totalChunks) && !(committedFile = new File(committedContainerPath = BinaryObjectCache.combine(this.getUploadPath(), BinaryObjectCache.buildContainerName(crc32)))).exists()) {
            File container = new File(containerPath);
            container.renameTo(committedFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long storeObjectForDownload(InputStream chunkFileStream) {
        long id = -1L;
        FileOutputStream stream = null;
        try {
            id = BinaryObjectCache.generateDownloadID();
            while (!this.isDownloadIdUniuqe(id)) {
                id = BinaryObjectCache.generateDownloadID();
            }
            stream = this.createDownloadContainer(id);
            BinaryObjectCache.writeStream(chunkFileStream, stream, 8192);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    logger.error((Object)("Could not close Output Stream: " + id));
                }
            }
        }
        return id;
    }

    private FileOutputStream createDownloadContainer(long id) {
        try {
            String filePath = this.buildDownloadObjectPath(id);
            File downloadFileContainer = new File(filePath);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Chunk ID %d assigned to file -> %s", id, downloadFileContainer.getName()));
            }
            return new FileOutputStream(downloadFileContainer);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static File createNewFile(String fileName, int chunkNumber) throws ChunkingException {
        File f = new File(fileName);
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                throw new ChunkingException("Cannot create a file for chunking: " + fileName, e);
            }
        }
        if (chunkNumber < 1) {
            f.delete();
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                throw new ChunkingException("Cannot replace file: " + fileName, e);
            }
        }
        return f;
    }

    private static void storeChunk(byte[] data, File targetFile) throws ChunkingException {
        RandomAccessFile rFile = null;
        try {
            rFile = new RandomAccessFile(targetFile, "rw");
            rFile.seek(rFile.length());
            rFile.write(data);
        }
        catch (IOException e) {
            throw new ChunkingException("Cannot get a chunk from the file: " + targetFile.getAbsolutePath(), e);
        }
        finally {
            if (rFile != null) {
                try {
                    rFile.close();
                }
                catch (IOException e) {
                    throw new ChunkingException("Cannot close file: " + targetFile.getAbsolutePath(), e);
                }
            }
        }
    }

    private static boolean allChunksPresent(String containerPath, int numberOfChunks) {
        for (int index = numberOfChunks - 1; index >= 0; --index) {
            String chunkPath = BinaryObjectCache.combine(containerPath, index + FILE_EXTENSION);
            if (new File(chunkPath).exists()) continue;
            return false;
        }
        return true;
    }

    private static void copyStream(InputStream input, OutputStream output) {
        try {
            byte[] buffer = new byte[32768];
            while (true) {
                int read;
                if ((read = input.read(buffer, 0, buffer.length)) <= 0) {
                    return;
                }
                output.write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private static String combine(String path1, String path2) {
        File file1 = new File(path1);
        File file2 = new File(file1, path2);
        return file2.getPath();
    }

    private String getUploadPath() {
        File uploadFile = new File(BinaryObjectCache.combine(this.basePath, "Upload"));
        if (!uploadFile.exists()) {
            uploadFile.mkdirs();
        }
        return uploadFile.getPath();
    }

    private String getDownloadPath() {
        File uploadFile = new File(BinaryObjectCache.combine(this.basePath, "Download"));
        if (!uploadFile.exists()) {
            uploadFile.mkdirs();
        }
        return uploadFile.getPath();
    }

    public static int calculateChunkCount(int totalSize) {
        int chunkCount = totalSize / 524288;
        if (totalSize % 524288 != 0) {
            ++chunkCount;
        }
        return chunkCount;
    }

    public static long calculateChunkCount(long totalSize) {
        long chunkCount = totalSize / 524288L;
        if (totalSize % 524288L != 0L) {
            ++chunkCount;
        }
        return chunkCount;
    }

    private static boolean deleteFolder(File file) {
        if (file.isDirectory()) {
            String[] subItems = file.list();
            for (int i = 0; i < subItems.length; ++i) {
                boolean success = BinaryObjectCache.deleteFolder(new File(file, subItems[i]));
                if (success) continue;
                return false;
            }
        }
        return file.delete();
    }

    public boolean binaryObjectExists(int crc32) {
        this.cleanCache();
        String containerPath = BinaryObjectCache.combine(this.getUploadPath(), BinaryObjectCache.buildContainerName(crc32));
        return new File(containerPath).exists();
    }

    private synchronized void cleanCache() {
        long oneDayInMilliSeconds = 86400000L;
        if (new Date().getTime() - lastCacheCleanupTicks > 432000000L) {
            File uploadFolder = new File(this.getUploadPath());
            String[] uploadContainerPaths = uploadFolder.list();
            for (int i = 0; i < uploadContainerPaths.length; ++i) {
                try {
                    String folderName = uploadContainerPaths[i];
                    File file = new File(BinaryObjectCache.combine(this.getUploadPath(), folderName));
                    if (new Date().getTime() - file.lastModified() <= 432000000L) continue;
                    BinaryObjectCache.deleteFolder(file);
                    continue;
                }
                catch (Exception folderName) {
                    // empty catch block
                }
            }
            File downloadFolder = new File(this.getUploadPath());
            String[] downloadFilePath = downloadFolder.list();
            for (int i = 0; i < downloadFilePath.length; ++i) {
                try {
                    String folderName = downloadFilePath[i];
                    File file = new File(BinaryObjectCache.combine(this.getUploadPath(), folderName));
                    if (new Date().getTime() - file.lastModified() <= new Date().getTime() - 86400000L) continue;
                    BinaryObjectCache.deleteFolder(file);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            lastCacheCleanupTicks = new Date().getTime();
        }
    }

    private static final void writeStream(InputStream in, OutputStream out, int bufferSize) throws IOException {
        byte[] b = new byte[bufferSize];
        int totalReadBytes = 0;
        try {
            int count = in.read(b);
            while (count > 0) {
                totalReadBytes += count;
                out.write(b, 0, count);
                count = in.read(b);
            }
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            throw new RuntimeException("Read " + totalReadBytes + " bytes ", e);
        }
    }
}

