/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.gopro.util.AppPropertiesAdapter;
import net.gopro.util.FileRef;
import net.gopro.util.TempFile;
import net.gopro.util.TempFileInputStream;
import net.gopro.util.TempFileOutputStream;
import net.gopro.util.Utils;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;

public class AttachmentStoreUtil
implements Runnable {
    static final Logger logger = Logger.getLogger(AttachmentStoreUtil.class);
    public static final byte[] PSEUDO_ATTACHMENT_CONTENT = "[PSEUDO_ATTACHMENT_CONTENT]".getBytes();
    public static final byte[] STORED_ON_DISK_ATTACHMENT_CONTENT = "[STORED_ON_DISK__ATTACHMENT_CONTENT]".getBytes();
    public static final byte[] DELETED_ATTACHMENT = "[DELETED_ATTACHMENT]".getBytes();
    public static long FileRefEntryTimeOut = 180000L;
    public static long CleanupThreadWakeUpInterval = 60000L;
    public static int DataTransferBufferSize = 65536;
    public static final String TempFilesPrefix = "docGoProAttTmp";
    private static LinkedList<FileRef> nonReferencedFiles = new LinkedList();
    private static LinkedList<FileRef> filesToRemove = new LinkedList();
    private static Hashtable<String, FileRef> tempFilesRefRegister = new Hashtable();
    private static boolean performContentCompare = false;
    private static Thread cleanupThread;
    private static boolean initialized;
    private static File TempFilesFolder;

    public static void transferToStream(byte[] metaData, OutputStream targetStream) {
        try {
            if (metaData != null) {
                InputStream inStream = AttachmentStoreUtil.getInputStream(metaData);
                Utils.writeStream(inStream, targetStream, DataTransferBufferSize);
                inStream.close();
                targetStream.flush();
                targetStream.close();
            } else {
                System.err.println("AttachmentStoreUtil: NULL metadata is specified in AttachmentStoreUtil.transferToStream");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] setStream(byte[] metaData, InputStream sourceStream) {
        try {
            if (sourceStream.available() > 0 && sourceStream.markSupported()) {
                byte[] buffer = new byte[128];
                sourceStream.mark(128);
                int available = sourceStream.available();
                available = available > 128 ? 128 : available;
                sourceStream.read(buffer, 0, available);
                sourceStream.reset();
                String tmpFileName = AttachmentStoreUtil.decodeStorageFileName(metaData);
                if (AttachmentStoreUtil.arrayStartsWith(buffer, PSEUDO_ATTACHMENT_CONTENT)) {
                    if (tmpFileName != null) {
                        AttachmentStoreUtil.unregisterFileReference(tmpFileName);
                    }
                    sourceStream.close();
                    return PSEUDO_ATTACHMENT_CONTENT;
                }
                if (AttachmentStoreUtil.arrayStartsWith(buffer, DELETED_ATTACHMENT)) {
                    if (tmpFileName != null) {
                        AttachmentStoreUtil.unregisterFileReference(tmpFileName);
                    }
                    sourceStream.close();
                    return DELETED_ATTACHMENT;
                }
            }
            metaData = AttachmentStoreUtil.provideTempStorage(metaData);
            OutputStream outStream = AttachmentStoreUtil.getOutputStream(metaData);
            Utils.writeStream(sourceStream, outStream, DataTransferBufferSize);
            sourceStream.close();
            outStream.flush();
            outStream.close();
            return metaData;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean arrayStartsWith(byte[] data, byte[] pattern) {
        if (pattern.length > data.length) {
            return false;
        }
        for (int ac = 0; ac < pattern.length; ++ac) {
            if (data[ac] == pattern[ac]) continue;
            return false;
        }
        return true;
    }

    public static byte[] setStream(byte[] metaData, byte[] contentData) {
        try {
            if (!AttachmentStoreUtil.arrayStartsWith(DELETED_ATTACHMENT, contentData) && !AttachmentStoreUtil.arrayStartsWith(PSEUDO_ATTACHMENT_CONTENT, contentData)) {
                ByteArrayInputStream srcStream = new ByteArrayInputStream(contentData);
                metaData = AttachmentStoreUtil.provideTempStorage(metaData);
                OutputStream outStream = AttachmentStoreUtil.getOutputStream(metaData);
                Utils.writeStream(srcStream, outStream, DataTransferBufferSize);
                srcStream.close();
                outStream.close();
                return metaData;
            }
            String tmpFileName = AttachmentStoreUtil.decodeStorageFileName(metaData);
            if (tmpFileName != null && tmpFileName.length() > 0) {
                AttachmentStoreUtil.unregisterFileReference(tmpFileName);
            }
            return contentData;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream getInputStream(byte[] metaData) {
        String file;
        if (metaData.length > STORED_ON_DISK_ATTACHMENT_CONTENT.length && (file = AttachmentStoreUtil.decodeStorageFileName(metaData)) != null) {
            try {
                TempFileInputStream fileIn = new TempFileInputStream(file);
                return fileIn;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return new ByteArrayInputStream(metaData);
    }

    public static String getMD5Checksum(byte[] metaData) {
        InputStream is = AttachmentStoreUtil.getInputStream(metaData);
        if (is == null) {
            return null;
        }
        try {
            return DigestUtils.md5Hex((InputStream)is);
        }
        catch (IOException e) {
            System.err.println("Unable to calculate MD5 checksum for file stream");
            return null;
        }
    }

    private static OutputStream getOutputStream(byte[] metaData) throws IOException {
        String file = AttachmentStoreUtil.decodeStorageFileName(metaData);
        try {
            TempFileOutputStream fileOut = new TempFileOutputStream(file);
            return fileOut;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static File provideTempFile() {
        return AttachmentStoreUtil.provideTempFile(TempFilesPrefix, null);
    }

    public static File provideTempFile(String tempFilePrefix, String tempFileSuffix) {
        try {
            AttachmentStoreUtil.initialize();
            File tmpFile = File.createTempFile(TempFilesPrefix, tempFileSuffix, TempFilesFolder);
            tmpFile.setReadable(true, false);
            tmpFile.setWritable(true, false);
            String fileName = tmpFile.getAbsolutePath();
            AttachmentStoreUtil.initReferenceEntry(fileName);
            return new TempFile(fileName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] provideTempStorage(byte[] metaData) throws IOException {
        return AttachmentStoreUtil.provideTempStorage(metaData, TempFilesPrefix, null);
    }

    public static byte[] provideTempStorage(byte[] metaData, String tempFilePrefix, String tempFileSuffix) throws IOException {
        String fileName = AttachmentStoreUtil.decodeStorageFileName(metaData);
        if (fileName == null) {
            AttachmentStoreUtil.initialize();
            File tmpFile = File.createTempFile(tempFilePrefix, tempFileSuffix, TempFilesFolder);
            fileName = tmpFile.getAbsolutePath();
            AttachmentStoreUtil.initReferenceEntry(fileName);
            return AttachmentStoreUtil.encodeDiskStoreFileName(fileName);
        }
        return metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initialize() {
        if (initialized) return;
        Class<AttachmentStoreUtil> clazz = AttachmentStoreUtil.class;
        synchronized (AttachmentStoreUtil.class) {
            String javaTempDir = System.getProperty("java.io.tmpdir");
            String folderPath = AppPropertiesAdapter.getProperty("net.gopro.util.AttachmentStoreUtil.TempFilesFolder", null);
            if (folderPath == null) {
                String subFolder = AppPropertiesAdapter.getProperty("net.gopro.appIdentifier", "GoPro");
                folderPath = new File(javaTempDir, subFolder).getAbsolutePath();
            }
            if (!(TempFilesFolder = new File(folderPath)).exists()) {
                try {
                    TempFilesFolder.mkdirs();
                    TempFilesFolder.setReadable(true, false);
                    TempFilesFolder.setWritable(true, false);
                }
                catch (Exception e) {
                    System.err.println("ERROR: Failed to create temporary storage directory '" + folderPath + "' on startup due " + e.getMessage());
                    System.err.println("WARNING: Using the default java temp directory '" + javaTempDir + "' as fallback.");
                    System.err.println("WARNING: Deleting the pre-existing temporary files skipped because the temp storage folder is not GoPro-dedicated.");
                    TempFilesFolder = new File(javaTempDir);
                }
            } else {
                File[] preExistingFiles;
                System.out.println("Cleaning up the pre-existing temporary files in '" + TempFilesFolder.getAbsolutePath() + "'");
                for (File file : preExistingFiles = TempFilesFolder.listFiles()) {
                    try {
                        file.delete();
                    }
                    catch (Exception e) {
                        System.err.println("Failed to delete temp file '" + file.getAbsolutePath() + "' on startup due " + e.getMessage());
                    }
                }
            }
            initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean isBoundToTempStorageFile(byte[] metaData) {
        return AttachmentStoreUtil.decodeStorageFileName(metaData) != null;
    }

    public static File getTempStorageFile(byte[] metaData) {
        String fileName = AttachmentStoreUtil.decodeStorageFileName(metaData);
        if (fileName != null) {
            return new TempFile(fileName);
        }
        return null;
    }

    public static String decodeStorageFileName(byte[] metaData) {
        if (metaData == null || metaData.length == 0) {
            return null;
        }
        for (int ac = 0; ac < STORED_ON_DISK_ATTACHMENT_CONTENT.length; ++ac) {
            if (metaData[ac] == STORED_ON_DISK_ATTACHMENT_CONTENT[ac]) continue;
            return null;
        }
        String storeFileName = null;
        try {
            storeFileName = new String(metaData, STORED_ON_DISK_ATTACHMENT_CONTENT.length, metaData.length - STORED_ON_DISK_ATTACHMENT_CONTENT.length, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return storeFileName;
    }

    public static byte[] encodeDiskStoreFileName(String fileName) {
        try {
            byte[] encFileName = fileName.getBytes("UTF-8");
            byte[] fullEncFileName = new byte[encFileName.length + STORED_ON_DISK_ATTACHMENT_CONTENT.length];
            System.arraycopy(STORED_ON_DISK_ATTACHMENT_CONTENT, 0, fullEncFileName, 0, STORED_ON_DISK_ATTACHMENT_CONTENT.length);
            System.arraycopy(encFileName, 0, fullEncFileName, STORED_ON_DISK_ATTACHMENT_CONTENT.length, encFileName.length);
            return fullEncFileName;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isPseudoAttachmentContent(byte[] metadata) {
        if (metadata == null) {
            return false;
        }
        return AttachmentStoreUtil.arrayStartsWith(metadata, PSEUDO_ATTACHMENT_CONTENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initReferenceEntry(String fileName) {
        LinkedList<FileRef> linkedList = nonReferencedFiles;
        synchronized (linkedList) {
            FileRef fileRef = new FileRef(fileName);
            nonReferencedFiles.add(fileRef);
            tempFilesRefRegister.put(fileName, fileRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerFileReference(String fileName) {
        LinkedList<FileRef> linkedList = filesToRemove;
        synchronized (linkedList) {
            LinkedList<FileRef> linkedList2 = nonReferencedFiles;
            synchronized (linkedList2) {
                if (fileName.indexOf(TempFilesPrefix) >= 0) {
                    FileRef fileRef = tempFilesRefRegister.get(fileName);
                    if (fileRef != null) {
                        if (fileRef.refsCount == 0) {
                            nonReferencedFiles.remove(fileRef);
                        }
                        ++fileRef.refsCount;
                        fileRef.lastRefTime = System.currentTimeMillis();
                    } else {
                        throw new RuntimeException("No file ref entry found to register: " + fileName);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterFileReference(String fileName) {
        LinkedList<FileRef> linkedList = filesToRemove;
        synchronized (linkedList) {
            if (fileName != null && fileName.indexOf(TempFilesPrefix) >= 0) {
                FileRef fileRef = tempFilesRefRegister.get(fileName);
                if (fileRef != null) {
                    --fileRef.refsCount;
                    fileRef.lastRefTime = System.currentTimeMillis();
                    if (fileRef.refsCount == 0) {
                        filesToRemove.add(fileRef);
                    }
                } else {
                    logger.warn((Object)("No tempFile referency entry found to unregister file : " + fileName));
                }
            }
        }
    }

    private static void releaseFileResouces(String fileName) {
        if (fileName != null) {
            try {
                File file = new File(fileName);
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception e) {
                System.err.println("AttachmentStoreUtil: ");
                e.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            List<String> filesToDelete;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Temp files cleanup running");
            }
            if ((filesToDelete = this.releaseFileScan(filesToRemove)) != null) {
                for (String fileToDelete : filesToDelete) {
                    AttachmentStoreUtil.releaseFileResouces(fileToDelete);
                }
            }
            if ((filesToDelete = this.releaseFileScan(nonReferencedFiles)) != null) {
                for (String fileToDelete : filesToDelete) {
                    AttachmentStoreUtil.releaseFileResouces(fileToDelete);
                }
            }
            if (logger.isTraceEnabled()) {
                AttachmentStoreUtil.status();
            }
            try {
                Thread.sleep(CleanupThreadWakeUpInterval);
            }
            catch (InterruptedException ie) {
                return;
            }
            catch (Throwable t) {
                System.err.println("AttachmentStoreUtil: ");
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> releaseFileScan(LinkedList<FileRef> entryList) {
        ArrayList<String> releaseList = null;
        LinkedList<FileRef> linkedList = entryList;
        synchronized (linkedList) {
            Iterator entryIterator = entryList.iterator();
            while (entryIterator.hasNext()) {
                FileRef fileRef = (FileRef)entryIterator.next();
                if (System.currentTimeMillis() - fileRef.lastRefTime <= FileRefEntryTimeOut) continue;
                entryIterator.remove();
                tempFilesRefRegister.remove(fileRef.fileName);
                if (releaseList == null) {
                    releaseList = new ArrayList<String>();
                }
                releaseList.add(fileRef.fileName);
            }
        }
        return releaseList;
    }

    public static boolean isPerformContentCompare() {
        return performContentCompare;
    }

    public static void setPerformContentCompare(boolean performContentCompare) {
        AttachmentStoreUtil.performContentCompare = performContentCompare;
    }

    public static int status() {
        System.out.println("Refs: " + tempFilesRefRegister.size());
        System.out.println("===============");
        for (Map.Entry<String, FileRef> frEntry : tempFilesRefRegister.entrySet()) {
            System.out.println(frEntry.getValue());
        }
        System.out.println("De refs: " + nonReferencedFiles.size());
        System.out.println("===============");
        for (FileRef fref : nonReferencedFiles) {
            System.out.println(fref);
        }
        System.out.println("To delete: " + filesToRemove.size());
        System.out.println("===============");
        for (FileRef fref : filesToRemove) {
            System.out.println(fref);
        }
        return tempFilesRefRegister.size();
    }

    static {
        initialized = false;
        TempFilesFolder = null;
        cleanupThread = new Thread((Runnable)new AttachmentStoreUtil(), "GoPro Attachment store cleanup");
        cleanupThread.setDaemon(true);
        cleanupThread.start();
        try {
            Class<?> threadManagerClass = Class.forName("net.gopro.framework.ThreadManager");
            Method threadManagerGetInstance = threadManagerClass.getDeclaredMethod("getInstance", new Class[0]);
            Method threadManagerRegister = threadManagerClass.getDeclaredMethod("register", Thread.class);
            threadManagerRegister.invoke(threadManagerGetInstance.invoke(null, new Object[0]), cleanupThread);
            System.out.println("GoPro AttachmentStoreUtil: Running through thread manager");
        }
        catch (Exception e) {
            System.out.println("GoPro AttachmentStoreUtil: Cannot resolve thread manager - will run unmanaged");
        }
    }
}

