/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.services.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.gopro.gdf.data.DataSetColumnType;
import net.gopro.gdf.data.IBaseObjectType;
import net.gopro.gdf.data.ObjectBaseType;
import net.gopro.util.ArrayUtils;
import net.gopro.util.annotations.GoProAnnotationHelper;
import net.gopro.util.annotations.GoProAnnotationInfo;
import net.gopro.util.annotations.GoProReferencePersistanceAnnotation;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.xml.XMLClassDescriptor;

public class DataObjectAnalyzer {
    protected static final String[] ExpandedSubClasses = new String[]{"AddressType"};

    public static List collectComplexGetters(Class documentClass) {
        ArrayList accessorsList = new ArrayList();
        DataObjectAnalyzer.collectAccessors(documentClass, null, null, accessorsList, true, true);
        return accessorsList;
    }

    public static List collectClassProperties(Class documentClass, boolean checkAnnotations) {
        ArrayList<DataSetColumnType> list = new ArrayList<DataSetColumnType>();
        DataObjectAnalyzer.collectProperties("", "", documentClass.getName(), list, 1, 0, false, checkAnnotations);
        return list;
    }

    public static List collectClassProperties(Class typeClass) {
        ArrayList<DataSetColumnType> list = new ArrayList<DataSetColumnType>();
        DataObjectAnalyzer.collectProperties("", "", typeClass.getName(), list, 1, 0, false, false);
        return list;
    }

    public static List collectDefaultClassProperties(Class typeClass) {
        ArrayList<DataSetColumnType> list = new ArrayList<DataSetColumnType>();
        DataObjectAnalyzer.collectProperties("", "", typeClass.getName(), list, 1, 0, true, false);
        return list;
    }

    public static List collectDocumentProperties(ObjectBaseType object) {
        ArrayList<DataSetColumnType> list = new ArrayList<DataSetColumnType>();
        DataObjectAnalyzer.collectProperties("", "", object.getClass().getName(), list, 1, 0, true, false);
        return list;
    }

    public static void collectAccessors(Class documentClass, Class collectForType, Class excludeForType, List accessorsList, boolean getters, boolean collectComplexTypes) {
        String descClassName = documentClass.getName().replaceAll("\\.data", ".data.descriptors") + "Descriptor";
        try {
            XMLClassDescriptor xmlDescriptor = (XMLClassDescriptor)Class.forName(descClassName).newInstance();
            FieldDescriptor[] fieldDescriptor = xmlDescriptor.getFields();
            for (int i = 0; i < fieldDescriptor.length; ++i) {
                FieldDescriptor fieldDesc = fieldDescriptor[i];
                if (!IBaseObjectType.class.isAssignableFrom(fieldDesc.getFieldType()) || (collectForType == null || !collectForType.isAssignableFrom(fieldDesc.getFieldType())) && (!collectComplexTypes || DataObjectAnalyzer.isSimpleType(fieldDesc.getFieldType().getName())) || excludeForType != null && excludeForType.isAssignableFrom(fieldDesc.getFieldType())) continue;
                String fieldName = fieldDesc.getFieldName();
                if (fieldDesc.isMultivalued() && fieldName.endsWith("List")) {
                    fieldName = fieldName.substring(0, fieldName.length() - 4);
                }
                fieldName = fieldName.substring(1);
                String baseAccessorName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                baseAccessorName = DataObjectAnalyzer.fixMultiAccessorName(fieldDesc, baseAccessorName);
                Method method = null;
                method = getters ? documentClass.getMethod("get" + baseAccessorName, new Class[0]) : (!fieldDesc.isMultivalued() ? documentClass.getMethod("set" + baseAccessorName, fieldDesc.getFieldType()) : documentClass.getMethod("set" + baseAccessorName, fieldDesc.getFieldType()));
                accessorsList.add(method);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private static String fixMultiAccessorName(FieldDescriptor fieldDesc, String baseAccessorName) {
        if (fieldDesc.isMultivalued()) {
            baseAccessorName = baseAccessorName.endsWith("Entry") ? DataObjectAnalyzer.fixMultiName(baseAccessorName, "ies", 1) : (baseAccessorName.endsWith("s") ? DataObjectAnalyzer.fixMultiName(baseAccessorName, "es", 0) : DataObjectAnalyzer.fixMultiName(baseAccessorName, "s", 0));
        }
        return baseAccessorName;
    }

    private static String fixMultiName(String name, String suffix, int removeSuffixCharsCount) {
        name = name.substring(0, name.length() - removeSuffixCharsCount);
        name = name + suffix;
        return name;
    }

    public static String convertListAccessorTitleToPluralName(String listAccessorName) {
        String[] listAccessorParts = ArrayUtils.splitArray(listAccessorName, "_");
        String resultName = "";
        for (int ac = 0; ac < listAccessorParts.length; ++ac) {
            if (ac > 0) {
                resultName = resultName + "_";
            }
            resultName = resultName + DataObjectAnalyzer.convertListAccessorNameToPluralName(listAccessorParts[ac]);
        }
        return resultName;
    }

    public static String convertListAccessorNameToPluralName(String listAccessorName) {
        if (listAccessorName.endsWith("List")) {
            listAccessorName = listAccessorName.endsWith("EntryList") ? listAccessorName.substring(0, listAccessorName.length() - 9) + "Entries" : (listAccessorName.endsWith("sList") ? listAccessorName.substring(0, listAccessorName.length() - 4) + "es" : listAccessorName.substring(0, listAccessorName.length() - 4) + "s");
        }
        return listAccessorName;
    }

    private static void collectProperties(String propertyPathPrefix, String namePrefix, String className, List<DataSetColumnType> metaCollection, int depthLimit, int depth, boolean defaultOnly, boolean checkAnnotations) {
        String descClassName = className.replaceAll("\\.data", ".data.descriptors") + "Descriptor";
        boolean refTypeFlag = className.endsWith("RefType");
        boolean fieldInvisible = false;
        try {
            GoProAnnotationInfo classAnnotationInfo = null;
            classAnnotationInfo = GoProAnnotationHelper.getAnnotationInfo(Class.forName(className));
            XMLClassDescriptor xmlDescriptor = (XMLClassDescriptor)Class.forName(descClassName).newInstance();
            FieldDescriptor[] fieldDescriptor = xmlDescriptor.getFields();
            for (int i = 0; i < fieldDescriptor.length; ++i) {
                int depthAdvance;
                FieldDescriptor fieldDesc = fieldDescriptor[i];
                if (checkAnnotations) {
                    fieldInvisible = classAnnotationInfo.getInvisibleFieldAnnotation(fieldDesc.getFieldName());
                }
                if (fieldInvisible) continue;
                String fieldCaption = (namePrefix.equals("") ? "" : namePrefix + "_") + (refTypeFlag ? "Ref" : "") + fieldDesc.getFieldName().substring(1, 2).toUpperCase() + fieldDesc.getFieldName().substring(2);
                if (refTypeFlag && fieldDesc.getFieldName().equals("_name") || defaultOnly && depth != 0 && !fieldDesc.getFieldName().equals("_subject") && !fieldDesc.getFieldName().equals("_name")) continue;
                if (!IBaseObjectType.class.isAssignableFrom(fieldDesc.getFieldType())) {
                    DataSetColumnType dsColumn = new DataSetColumnType();
                    fieldCaption = DataObjectAnalyzer.convertListAccessorTitleToPluralName(fieldCaption);
                    dsColumn.setName(fieldCaption);
                    dsColumn.setType(fieldDesc.getFieldType().toString());
                    dsColumn.setMappedObjectName(propertyPathPrefix + DataObjectAnalyzer.convertListAccessorNameToPluralName(fieldDesc.getFieldName()));
                    metaCollection.add(dsColumn);
                    continue;
                }
                String typeName = fieldDescriptor[i].getFieldType().getName();
                boolean isRefSubstitute = DataObjectAnalyzer.isSubObjectReferenceSubstitute(classAnnotationInfo, fieldDescriptor[i].getFieldName());
                int n = depthAdvance = isRefSubstitute ? 1 : 0;
                if (depthLimit + depthAdvance <= 0) continue;
                String typeDescriptor = DataObjectAnalyzer.getClassBaseName(typeName);
                if (isRefSubstitute) {
                    typeDescriptor = typeDescriptor.replaceFirst("Type", "RefType");
                }
                String dataPath = propertyPathPrefix + DataObjectAnalyzer.convertListAccessorNameToPluralName(fieldDescriptor[i].getFieldName()) + "[" + typeDescriptor + "].";
                if (isRefSubstitute) {
                    dataPath = dataPath + "_objData[" + DataObjectAnalyzer.getClassBaseName(typeName) + "].";
                }
                DataObjectAnalyzer.collectProperties(dataPath, fieldCaption, typeName, metaCollection, depthLimit - 1 + depthAdvance, depth + 1, defaultOnly, checkAnnotations);
            }
            if (refTypeFlag) {
                String typeName = className.replaceFirst("RefType", "Type");
                String dataPath = propertyPathPrefix + "_objData[" + DataObjectAnalyzer.getClassBaseName(typeName) + "].";
                DataObjectAnalyzer.collectProperties(dataPath, namePrefix, typeName, metaCollection, depthLimit, depth, defaultOnly, checkAnnotations);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isSubObjectReferenceSubstitute(GoProAnnotationInfo classAnnotationInfo, String fieldName) {
        return classAnnotationInfo.hasFieldAnnotation(fieldName, GoProReferencePersistanceAnnotation.class);
    }

    private static boolean isSimpleType(String className) {
        String newClassName = className.replaceAll("\\.data", ".data.descriptors") + "Descriptor";
        try {
            Class.forName(newClassName).newInstance();
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    protected static String getClassBaseName(String className) {
        return className.substring(className.lastIndexOf(46) + 1);
    }
}

