/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.services;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.gopro.gdf.data.UserCredentialsType;
import net.gopro.gdf.data.UserPrincipal;
import net.gopro.gdf.services.IConfigurationService;
import net.gopro.gdf.services.ISecurityService;
import net.gopro.gdf.services.IWorkflowService;
import net.gopro.gdf.services.plain.IBaseDocumentService;
import net.gopro.gdf.services.plain.IEMailService;
import net.gopro.gdf.services.plain.ILicenceService;
import net.gopro.gdf.services.plain.ITenantService;
import net.gopro.gdf.services.plain.IUserDocumentService;
import org.apache.log4j.Logger;

public abstract class ServiceFactory {
    private static final Logger logger = Logger.getLogger(ServiceFactory.class);
    private static final String GOPRO_CONFIG_FILENAME = "gopro-config.properties";
    private static final String CONFIG_SYSTEM_PROPERTY = "net.gopro.config.dir";
    private static final String APP_IDENTIFIER_PROPERTY = "net.gopro.appIdentifier";
    private static String mainGoProConfigPath = null;
    public static String SERVICES_CONFIGURATION_FILENAME = "gdf-services.properties";
    public static String SERVICE_FACTORY_PROPERTY_NAME = "gdf.services.factory";
    private static ServiceFactory serviceFactoryInstance = null;

    public static ServiceFactory getInstance() {
        if (serviceFactoryInstance != null) {
            return serviceFactoryInstance;
        }
        File configFile = new File(ServiceFactory.getConfigPath(), SERVICES_CONFIGURATION_FILENAME);
        Properties gdfServiceConfig = new Properties();
        try (InputStream stream = null;){
            if (!configFile.exists()) {
                stream = ServiceFactory.class.getResourceAsStream("/" + SERVICES_CONFIGURATION_FILENAME);
                if (stream == null) {
                    throw new RuntimeException("The configuration file for GDF services is not located: " + configFile.getAbsolutePath());
                }
            } else {
                stream = new FileInputStream(configFile);
            }
            gdfServiceConfig.load(stream);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        String factoryClassName = gdfServiceConfig.getProperty(SERVICE_FACTORY_PROPERTY_NAME);
        if (factoryClassName == null) {
            throw new RuntimeException("GDF factory configuration property '" + SERVICE_FACTORY_PROPERTY_NAME + "' is not found in the GDF services configuration file '" + configFile.getAbsolutePath() + "'");
        }
        try {
            serviceFactoryInstance = (ServiceFactory)Class.forName(factoryClassName).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate GDF services factory '" + factoryClassName + "'", e);
        }
        return serviceFactoryInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final synchronized String getConfigPath() {
        block12: {
            if (mainGoProConfigPath == null) {
                try {
                    Properties goproConfigProperties = new Properties();
                    InputStream stream = ServiceFactory.class.getResourceAsStream("/gopro-config.properties");
                    if (stream == null) {
                        stream = ServiceFactory.class.getResourceAsStream(GOPRO_CONFIG_FILENAME);
                    }
                    if (stream != null) {
                        try {
                            goproConfigProperties.load(stream);
                            if (goproConfigProperties.containsKey(APP_IDENTIFIER_PROPERTY)) {
                                String appIdentifier = goproConfigProperties.getProperty(APP_IDENTIFIER_PROPERTY);
                                String identifiedPath = System.getProperty("net.gopro.config.dir." + appIdentifier);
                                mainGoProConfigPath = identifiedPath != null && !"".equals(identifiedPath) && new File(identifiedPath).exists() ? identifiedPath : (goproConfigProperties.containsKey(CONFIG_SYSTEM_PROPERTY) ? goproConfigProperties.getProperty(CONFIG_SYSTEM_PROPERTY) : System.getProperty(CONFIG_SYSTEM_PROPERTY));
                            } else {
                                mainGoProConfigPath = goproConfigProperties.containsKey(CONFIG_SYSTEM_PROPERTY) ? goproConfigProperties.getProperty(CONFIG_SYSTEM_PROPERTY) : System.getProperty(CONFIG_SYSTEM_PROPERTY);
                            }
                            break block12;
                        }
                        catch (Exception e) {
                            logger.fatal((Object)("Cannot determine main config path. Default path will be used: " + System.getProperty(CONFIG_SYSTEM_PROPERTY)), (Throwable)e);
                            mainGoProConfigPath = System.getProperty(CONFIG_SYSTEM_PROPERTY);
                            break block12;
                        }
                        finally {
                            stream.close();
                        }
                    }
                    mainGoProConfigPath = goproConfigProperties.containsKey(CONFIG_SYSTEM_PROPERTY) ? goproConfigProperties.getProperty(CONFIG_SYSTEM_PROPERTY) : System.getProperty(CONFIG_SYSTEM_PROPERTY);
                }
                catch (Exception e) {
                    System.err.println("Problem loading 'gopro-config.properties' for configuation.");
                    e.printStackTrace();
                }
            }
        }
        return mainGoProConfigPath;
    }

    public abstract net.gopro.gdf.services.IBaseDocumentService getBaseDocumentService(UserPrincipal var1);

    public abstract ISecurityService getSecurityService(UserPrincipal var1);

    public abstract IBaseDocumentService getPlainBaseDocumentService(UserPrincipal var1);

    public abstract net.gopro.gdf.services.plain.ISecurityService getPlainSecurityService(UserPrincipal var1);

    public abstract IConfigurationService getConfigurationService(UserPrincipal var1);

    public abstract net.gopro.gdf.services.IUserDocumentService getUserDocumentService(UserPrincipal var1);

    public abstract net.gopro.gdf.services.plain.IConfigurationService getPlainConfigurationService(UserPrincipal var1);

    public abstract IUserDocumentService getPlainUserDocumentService(UserPrincipal var1);

    public abstract net.gopro.gdf.services.ITenantService getTenantService(UserPrincipal var1);

    public abstract ITenantService getPlainTenantService(UserPrincipal var1);

    public abstract IWorkflowService getWorkflowService(UserPrincipal var1);

    public abstract net.gopro.gdf.services.plain.IWorkflowService getPlainWorkflowService(UserPrincipal var1);

    public abstract net.gopro.gdf.services.ILicenceService getLicenceService(UserPrincipal var1);

    public abstract ILicenceService getPlainLicenceService(UserPrincipal var1);

    public abstract net.gopro.gdf.services.IEMailService getEmailService(UserPrincipal var1);

    public abstract IEMailService getPlainEmailService(UserPrincipal var1);

    public static final UserPrincipal createLoginPrincipal(String userName, String password) {
        UserCredentialsType loginCredentials = new UserCredentialsType();
        loginCredentials.setUsername(userName);
        loginCredentials.setPassword(password);
        UserPrincipal loginPrincipal = new UserPrincipal();
        loginPrincipal.setCredentials(loginCredentials);
        return loginPrincipal;
    }
}

