/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data.helpers;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import net.gopro.gdf.data.helpers.IExtendedVisitor;
import net.gopro.gdf.data.helpers.IVisitor;

public class VisitorHelper {
    private static HashMap<String, Method> settersCache = new HashMap(10000);

    public static void iterateObjects(Object parentObject, boolean recursive, IVisitor visitor) {
        VisitorHelper.iterateObjects(parentObject, recursive, visitor, null);
    }

    private static void iterateObjects(Object parentObject, boolean recursive, IVisitor visitor, String parentProperty) {
        if (parentObject == null) {
            return;
        }
        for (Method method : parentObject.getClass().getMethods()) {
            if (!method.getName().startsWith("get") || method.getParameterTypes().length != 0) continue;
            try {
                boolean iteratable;
                String propertyName = method.getName().substring(3);
                Class<?> propertyValueType = method.getReturnType();
                if (!visitor.allowedToVisit(parentObject, propertyName, propertyValueType)) continue;
                Object obj = method.invoke(parentObject, new Object[0]);
                if (visitor instanceof IExtendedVisitor) {
                    if (parentProperty != null) {
                        ((IExtendedVisitor)visitor).visit(obj, parentObject, propertyName, parentProperty + "." + propertyName, propertyValueType);
                    } else {
                        ((IExtendedVisitor)visitor).visit(obj, parentObject, propertyName, propertyName, propertyValueType);
                    }
                } else {
                    visitor.visit(obj, parentObject, propertyName, propertyValueType);
                }
                if (!recursive || obj == null || !(iteratable = visitor.isIterateable(obj, parentObject, propertyName, propertyValueType))) continue;
                if (propertyValueType.getComponentType() != null) {
                    for (Object subObject : (Object[])obj) {
                        VisitorHelper.iterateObjects(subObject, recursive, visitor, propertyName);
                    }
                    continue;
                }
                if (Collection.class.isAssignableFrom(propertyValueType)) {
                    for (Object subObject : (Collection)obj) {
                        VisitorHelper.iterateObjects(subObject, recursive, visitor, propertyName);
                    }
                    continue;
                }
                VisitorHelper.iterateObjects(obj, recursive, visitor, propertyName);
            }
            catch (Exception ex) {
                System.err.println("Error on visiting " + (parentObject != null ? parentObject.getClass() : "null") + ": " + ex.getMessage());
            }
        }
    }

    public static void setPropertyValue(Object parent, String propertyName, Class<?> valueType, Object value) {
        String methodCacheKey = parent.getClass().getName() + "." + propertyName;
        Method method = settersCache.get(methodCacheKey);
        try {
            if (method == null) {
                method = parent.getClass().getMethod("set" + propertyName, valueType);
                settersCache.put(methodCacheKey, method);
            }
            method.invoke(parent, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

