/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data.helpers;

import java.util.ArrayList;
import java.util.List;
import net.gopro.gdf.data.FlexibleDataRowType;
import net.gopro.gdf.data.FlexibleDataSetMetaInfoType;
import net.gopro.gdf.data.FlexibleDataSetType;
import net.gopro.gdf.data.IReferenceableObjectType;
import net.gopro.gdf.data.helpers.DocumentTypesMap;
import net.gopro.gdf.data.helpers.PropertyHelper;

public class FlexibleDataSetHelper {
    public static List<IReferenceableObjectType> getRowsAsCollection(FlexibleDataSetType dataSet) {
        ArrayList<IReferenceableObjectType> gdfObjectList = new ArrayList<IReferenceableObjectType>();
        for (FlexibleDataRowType row : dataSet.getData().getRows()) {
            gdfObjectList.add(FlexibleDataSetHelper.dataRowToObject(row, dataSet.getMetaInfo()));
        }
        return gdfObjectList;
    }

    private static IReferenceableObjectType dataRowToObject(FlexibleDataRowType row, FlexibleDataSetMetaInfoType rowInfo) {
        IReferenceableObjectType object = null;
        try {
            Class clazz = DocumentTypesMap.getInstance().getDocumentClass(row.getDocumentType());
            object = (IReferenceableObjectType)clazz.newInstance();
            object.setID(row.getID());
            for (int i = 0; i < row.getColumnValuesCount(); ++i) {
                PropertyHelper.setDocumentPropertySafe(object, rowInfo.getColumn(i).getMappedObjectName(), row.getColumnValue(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return object;
    }
}

