/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data.helpers;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import net.gopro.gdf.constants.DataLoadingOptions;
import net.gopro.gdf.data.BinaryFilterExpressionType;
import net.gopro.gdf.data.DocumentFilterType;
import net.gopro.gdf.data.FilterExpressionType;
import net.gopro.gdf.data.FlexibleDataRowType;
import net.gopro.gdf.data.FlexibleDataSetType;
import net.gopro.gdf.data.helpers.DocumentFilterHelper;
import net.gopro.gdf.data.helpers.IDataRowHandler;
import net.gopro.gdf.data.types.DeleteStatusType;
import net.gopro.gdf.data.types.FilterOperatorType;
import net.gopro.gdf.data.types.HiddenStatusType;
import net.gopro.gdf.services.IBaseDocumentService;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class DataRowScanner {
    private static Logger logger = Logger.getLogger(DataRowScanner.class);
    public static final String FILTER_SCAN_FLAG = "FULLDATESCAN";
    private IBaseDocumentService docService;
    private DocumentFilterType filter = DocumentFilterHelper.getEmptyFilter();
    private String dateProperty = "_modifiedDate";
    private int bulkSize = 1000;
    private int documentType = 1001;
    private int[] excludedDocuments = new int[0];
    private FilterExpressionType customFilter = null;
    private Date startDate = new Date(0L);
    private boolean includeDeleted = false;
    private boolean includeHidden = false;
    private String[] loadColumns = new String[0];
    private String[] ids = null;
    private Date lastScannedDate = null;
    private AtomicBoolean stopped = new AtomicBoolean(false);
    private static String ISO_DATE = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static String ISO_DATE_WITH_TZ = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

    public DataRowScanner(IBaseDocumentService docService) {
        this.docService = docService;
        this.prepareFilter();
        this.filter.addLoadColumn(this.dateProperty);
        this.filter.setDataLoadingOptions(DataLoadingOptions.DISABLE_RESULTS_COUNTING.getValue());
    }

    public void stop() {
        this.stopped.set(true);
    }

    public void scan(IDataRowHandler rowHandler) {
        this.prepareFilter();
        Date scanFromDate = this.startDate;
        try {
            long start = System.currentTimeMillis();
            logger.debug((Object)String.format("Starting scan for type %d, using %s from start date %s", this.filter.getDocumentFormType(), this.filter.getSortColumn(), scanFromDate));
            int bulkNumber = 0;
            String lastDateFromResults = null;
            int totalCount = 0;
            boolean done = false;
            while (!done) {
                int processCount = 0;
                this.filter.setRowsCount(this.bulkSize);
                BinaryFilterExpressionType dateFilter = DocumentFilterHelper.createBinaryExpression(this.dateProperty, FilterOperatorType.GREATER, scanFromDate);
                this.filter.setCustomFilter(DocumentFilterHelper.createAndList(dateFilter, this.customFilter));
                long queryStart = System.currentTimeMillis();
                FlexibleDataSetType results = this.docService.getDocumentHeaders(this.filter);
                long queryDur = System.currentTimeMillis() - queryStart;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)String.format("Retrieved %d rows in %d ms (from row %d), Total read: %d. Scanning from: %s", results.getData().getRowsCount(), queryDur, this.filter.getStartRow(), totalCount, lastDateFromResults));
                }
                if (results.getData().getRowsCount() == 0) {
                    done = true;
                    continue;
                }
                for (FlexibleDataRowType row : results.getData().getRows()) {
                    String currentDateFromResult = row.getColumnValue(row.getColumnValuesCount() - 1);
                    if (this.filter.getStartRow() > 0 && !StringUtils.equals((String)currentDateFromResult, lastDateFromResults)) {
                        logger.debug((Object)("Break paging @ " + processCount));
                        this.filter.setStartRow(this.filter.getStartRow() - this.bulkSize + processCount);
                        break;
                    }
                    ++processCount;
                    ++totalCount;
                    lastDateFromResults = currentDateFromResult;
                    rowHandler.processRow(row);
                    this.lastScannedDate = this.parseDateString(lastDateFromResults);
                    if (this.stopped.get()) break;
                }
                rowHandler.reportBulk(++bulkNumber);
                if (this.stopped.get()) {
                    done = true;
                    continue;
                }
                this.filter.setStartRow(this.filter.getStartRow() + this.bulkSize);
                this.filter.setRowsCount(1);
                long checkQueryStart = System.currentTimeMillis();
                FlexibleDataSetType checkNextRow = this.docService.getDocumentHeaders(this.filter);
                long checkQueryDur = System.currentTimeMillis() - checkQueryStart;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)String.format("CHECK: Retrieved %d rows in %d ms", checkNextRow.getData().getRowsCount(), checkQueryDur));
                }
                if (checkNextRow.getData().getRowsCount() == 0) {
                    done = true;
                    continue;
                }
                if (checkNextRow.getData().getRowsCount() == 1) {
                    FlexibleDataRowType nextRow = checkNextRow.getData().getRow(0);
                    String nextPageDateResult = nextRow.getColumnValue(nextRow.getColumnValuesCount() - 1);
                    if (!nextPageDateResult.equals(lastDateFromResults)) {
                        this.filter.setStartRow(0);
                        scanFromDate = this.parseDateString(lastDateFromResults);
                        continue;
                    }
                    if (this.filter.getStartRow() != this.bulkSize) continue;
                    logger.debug((Object)("Switch to paging @ " + totalCount));
                    continue;
                }
                this.filter.setStartRow(0);
                scanFromDate = this.parseDateString(lastDateFromResults);
            }
            long dur = System.currentTimeMillis() - start;
            logger.debug((Object)String.format("Scanned %d rows in %d ms", totalCount, dur));
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void setLoadColumns(String ... loadColumns) {
        this.loadColumns = loadColumns;
    }

    public void setDateProperty(String dateProperty) {
        this.dateProperty = dateProperty;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public void setCustomFilter(FilterExpressionType customFilter) {
        this.customFilter = customFilter;
    }

    public void setDocumentType(int documentType) {
        this.documentType = documentType;
    }

    public void setIncludeHidden(boolean includeHidden) {
        this.includeHidden = includeHidden;
    }

    public void setIncludeDeleted(boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
    }

    public void setBulkSize(int bulkSize) {
        this.bulkSize = bulkSize;
    }

    public void setExcludedDocuments(int ... excludedDocuments) {
        this.excludedDocuments = excludedDocuments;
    }

    private void prepareFilter() {
        this.filter.setStartRow(0);
        this.filter.setAlias(FILTER_SCAN_FLAG);
        this.filter.setSortColumn(this.dateProperty);
        this.filter.setSortDescending(false);
        this.filter.setRowsCount(this.bulkSize);
        this.filter.setDocumentFormType(this.documentType);
        this.filter.setLoadColumns(this.loadColumns);
        this.filter.addLoadColumn(this.dateProperty);
        this.filter.setExcludedDocumentTypes(this.excludedDocuments == null ? new int[]{} : this.excludedDocuments);
        this.filter.setDeleteStatus(this.includeDeleted ? DeleteStatusType.ALL : DeleteStatusType.NOTDELETED);
        this.filter.setHiddenStatus(this.includeHidden ? HiddenStatusType.ALL : HiddenStatusType.NOTHIDDEN);
        if (this.getIds() != null) {
            this.filter.setFilterDocumentIDs(this.getIds());
        }
    }

    private Date parseDateString(String dateToPars) throws ParseException {
        if (dateToPars.contains("+")) {
            int tzMarker = dateToPars.indexOf("+");
            if (tzMarker == 23 && dateToPars.charAt(26) == ':') {
                dateToPars = dateToPars.substring(0, 26) + dateToPars.substring(27);
            }
            return new SimpleDateFormat(ISO_DATE_WITH_TZ).parse(dateToPars);
        }
        return new SimpleDateFormat(ISO_DATE).parse(dateToPars);
    }

    public String[] getIds() {
        return this.ids;
    }

    public void setIds(String[] ids) {
        this.ids = ids;
    }

    public Date getLastScannedDate() {
        return this.lastScannedDate;
    }
}

