/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data.helpers;

import java.io.File;
import java.io.FileInputStream;
import net.gopro.gdf.data.ExternalDocumentVersionType;
import net.gopro.gdf.data.FileAttachmentType;
import net.gopro.util.AttachmentStoreUtil;

public class AttachmentHelper {
    public static ExternalDocumentVersionType createDocumentVersionFromAttachment(File attachment) {
        return AttachmentHelper.createDocumentVersionFromGoProFileAttachment(AttachmentHelper.createFileAttachmentFromFile(attachment));
    }

    public static ExternalDocumentVersionType createDocumentVersionFromGoProFileAttachment(FileAttachmentType fat) {
        ExternalDocumentVersionType version = new ExternalDocumentVersionType();
        version.setVersionNumber(0);
        version.setAttachment(fat);
        return version;
    }

    public static FileAttachmentType createFileAttachmentFromFile(File file) {
        FileAttachmentType attachment = new FileAttachmentType();
        attachment.setFileName(file.getName());
        attachment.setFileSize(file.length());
        try {
            FileInputStream inputStream = new FileInputStream(file);
            attachment.setStream(AttachmentStoreUtil.setStream(null, inputStream));
            attachment.setChecksum(AttachmentStoreUtil.getMD5Checksum(attachment.getStream()));
            return attachment;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initiate a FileAttachment from a file");
        }
    }
}

