/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data.constants;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.gopro.gdf.exceptions.GdfServiceRuntimeException;

public class DocumentTypes {
    public static final int DOC_TYPE_BASE = 1000;
    public static final int ENTITY_TYPE_BASE = 10;
    public static final int ENTITY_TYPE_ABSTRACT_OBJECT = 1;
    public static final int DOC_TYPE_USER = 1017;
    public static final int DOC_TYPE_EXTERNAL_DOCUMENT = 1025;
    public static final int ENTITY_TYPE_LANGUAGE = 518;
    public static final int DOC_TYPE_CATEGORY = 1013;
    public static final int DOC_TYPE_DOCUMENT = 1002;
    public static final int DOC_TYPE_FILE_PLAN_CATEGORY = 1043;
    public static final int DOC_TYPE_ROUTING_TEMPLATE = 1035;
    public static final int ENTITY_TYPE_META_DATA_BASE = 11;
    public static final int DOC_TYPE_CASE = 1005;
    public static final int ENTITY_TYPE_GENERAL_STEP = 516;
    public static final int DOC_TYPE_CONTACT = 1010;
    public static final int DOC_TYPE_DOCUMENT_BASE = 1001;
    public static final int ENTITY_TYPE_TASK = 500;
    public static final int DOC_TYPE_ORGANIZATION_UNIT = 1015;
    public static final int DOC_TYPE_STANDARD_TEXT = 1042;
    public static final int DOC_TYPE_CONFIG_DOCUMENT = 1011;
    public static final int ENTITY_TYPE_TASK_TEMPLATE = 528;
    public static final int DOC_TYPE_FORMULA = 1040;
    public static final int ENTITY_TYPE_IDNAME_TUPLET = 517;
    public static final int DOC_TYPE_SEARCH = 1031;
    public static final int ENTITY_TYPE_ROUTING_STEP_TEMPLATE = 526;
    public static final int DOC_TYPE_CASE_TEMPLATE = 1033;
    public static final int ENTITY_TYPE_REFERENCEABLE_OBJECT = 524;
    public static final int DOC_TYPE_CLIENT_BASE = 1006;
    public static final int ENTITY_TYPE_PHASE_HISTORY = 522;
    public static final int DOC_TYPE_INDIVIDUAL = 1009;
    public static final int DOC_TYPE_FILEPLAN = 1014;
    public static final int DOC_TYPE_COMPANY = 1008;
    public static final int ENTITY_TYPE_COMPOUND_STEP = 515;
    public static final int DOC_TYPE_USER_ROLE = 1019;
    public static final int DOC_TYPE_EXTERNAL_DOCUMENT_TEMPLATE = 1032;
    public static final int ENTITY_TYPE_ACCOUNT_MANAGER = 511;
    public static final int DOC_TYPE_EMAIL = 1024;
    public static final int DOC_TYPE_EXTERNAL_DOCUMENT_VERSION = 1026;
    public static final int ENTITY_TYPE_LIST_VALUE = 19;
    public static final int ENTITY_TYPE_PHONE_NUMBER = 523;
    public static final int DOC_TYPE_PHASE_TEMPLATE = 1034;
    public static final int DOC_TYPE_RESPONSE_DOCUMENT = 1003;
    public static final int DOC_TYPE_FORM_DOCUMENT = 1039;
    public static final int DOC_TYPE_REFERENCE = 1004;
    public static final int ENTITY_TYPE_ROUTING_ACTION_TEMPLATE = 525;
    public static final int DOC_TYPE_FORM_DOCUMENT_TEMPLATE = 1037;
    public static final int DOC_TYPE_REMINDER_SETTING = 1038;
    public static final int DOC_TYPE_LIST = 1016;
    public static final int DOC_TYPE_PHASE = 1029;
    public static final int ENTITY_TYPE_ROUTING_ACTION = 504;
    public static final int ENTITY_TYPE_USER_TAG = 506;
    public static final int ENTITY_TYPE_READ_ONLY_DOCUMENT = 501;
    public static final int DOC_TYPE_USER_POSITION = 1036;
    public static final int DOC_TYPE_USER_GROUP = 1018;
    public static final int ENTITY_TYPE_ROUTING_PARTICIPANT = 505;
    public static final int DOC_TYPE_CONFIG_SETTING = 1012;
    public static final int DOC_TYPE_FOLDER = 1045;
    public static final int ENTITY_TYPE_META_DATA = 521;
    public static final int DOC_TYPE_DOCUMENT_FILTER = 1023;
    public static final int DOC_TYPE_MESSAGE = 1048;
    public static final int DOC_TYPE_ROUTING_SLIP = 1030;
    public static final int ENTITY_TYPE_BASE_WORKFLOW_STEP = 513;
    public static final int DOC_TYPE_MEMO = 1028;
    public static final int DOC_TYPE_GUIDANCE = 1027;
    public static final int DOC_TYPE_CLIENT_UNIT_BASE = 1007;
    public static final int ENTITY_TYPE_CLIENT_GROUP = 514;
    public static final int ENTITY_TYPE_WORKFLOW_STEP_TEMPLATE = 527;
    public static final int DOC_TYPE_EXTERNAL_USER = 1022;
    public static final int DOC_TYPE_VIEW_FILTER = 1046;
    public static final int ENTITY_TYPE_ROUTING_STEP = 502;
    public static final int DOC_TYPE_ACLDOCUMENT = 1020;
    public static final int ENTITY_TYPE_ADDRESS = 512;
    public static final int DOC_TYPE_COMMUNICATION = 1049;
    public static final int DOC_TYPE_DOCUMENT_TYPE_SETTING = 1041;
    private static Map<Object, String> docIndexToTypeName;
    private static Map<String, Object> docTypeNameToIndex;

    public static String getDocumentTypeName(int documentType) {
        String docTypeName;
        if (docTypeNameToIndex == null) {
            DocumentTypes.initDocumentTypesIndex();
        }
        if ((docTypeName = docIndexToTypeName.get(new Integer(documentType))) == null) {
            throw new GdfServiceRuntimeException("Not defined document type index \"" + documentType + "\"");
        }
        return docTypeName;
    }

    public static int getDocumentTypeIndex(String documentTypeName) {
        Integer docTypeIndex;
        if (docTypeNameToIndex == null) {
            DocumentTypes.initDocumentTypesIndex();
        }
        if ((docTypeIndex = (Integer)docTypeNameToIndex.get(documentTypeName)) == null) {
            throw new GdfServiceRuntimeException("Not defined document type index \"" + documentTypeName + "\"");
        }
        return docTypeIndex;
    }

    protected static void initDocumentTypesIndex() {
        try {
            docIndexToTypeName = new ConcurrentHashMap<Object, String>();
            docTypeNameToIndex = new ConcurrentHashMap<String, Object>();
            Field[] fields = Class.forName("net.gopro.gdf.data.constants.DocumentTypes").getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field fld = fields[i];
                Object obj = fld.get(null);
                if (!(obj instanceof Integer)) continue;
                docTypeNameToIndex.put(fld.getName(), obj);
                docIndexToTypeName.put(obj, fld.getName());
            }
        }
        catch (Exception e) {
            throw new GdfServiceRuntimeException(e);
        }
    }

    public static final boolean isAbstractType(int documentType) {
        return documentType == 1001 || documentType == 1002 || documentType == 1011 || documentType == 1003 || documentType == 1006 || documentType == 1007;
    }
}

