/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.ACLDocumentRefType;
import net.gopro.gdf.data.ACLDocumentType;
import net.gopro.gdf.data.ReferenceableObjectType;
import net.gopro.gdf.data.UserRefType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class UserGroupType
extends ACLDocumentType
implements Serializable {
    private List _userList = new ArrayList();
    private String _description;
    private long _userCount;
    private boolean _has_userCount;
    private ACLDocumentRefType _owner;
    private static final long serialVersionUID = 15000L;

    public void addUser(UserRefType vUser) throws IndexOutOfBoundsException {
        this._userList.add(vUser);
    }

    public void addUser(int index, UserRefType vUser) throws IndexOutOfBoundsException {
        this._userList.add(index, vUser);
    }

    public void deleteUserCount() {
        this._has_userCount = false;
    }

    public Enumeration enumerateUsers() {
        return Collections.enumeration(this._userList);
    }

    public String getDescription() {
        return this._description;
    }

    public ACLDocumentRefType getOwner() {
        return this._owner;
    }

    public UserRefType getUser(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._userList.size()) {
            throw new IndexOutOfBoundsException("getUser: Index value '" + index + "' not in range [0.." + (this._userList.size() - 1) + "]");
        }
        return (UserRefType)this._userList.get(index);
    }

    public long getUserCount() {
        return this._userCount;
    }

    public UserRefType[] getUsers() {
        UserRefType[] array = new UserRefType[]{};
        return this._userList.toArray(array);
    }

    public List getUsersAsReference() {
        return this._userList;
    }

    public int getUsersCount() {
        return this._userList.size();
    }

    public boolean hasUserCount() {
        return this._has_userCount;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateUsers() {
        return this._userList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAllUsers() {
        this._userList.clear();
    }

    public boolean removeUser(UserRefType vUser) {
        boolean removed = this._userList.remove(vUser);
        return removed;
    }

    public UserRefType removeUserAt(int index) {
        Object obj = this._userList.remove(index);
        return (UserRefType)obj;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setOwner(ACLDocumentRefType owner) {
        this._owner = owner;
    }

    public void setUser(int index, UserRefType vUser) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._userList.size()) {
            throw new IndexOutOfBoundsException("setUser: Index value '" + index + "' not in range [0.." + (this._userList.size() - 1) + "]");
        }
        this._userList.set(index, vUser);
    }

    public void setUserCount(long userCount) {
        this._userCount = userCount;
        this._has_userCount = true;
    }

    public void setUsers(UserRefType[] vUserArray) {
        this._userList.clear();
        for (int i = 0; i < vUserArray.length; ++i) {
            this._userList.add(vUserArray[i]);
        }
    }

    public void setUsers(List vUserList) {
        this._userList.clear();
        this._userList.addAll(vUserList);
    }

    public void setUsersAsReference(List userList) {
        this._userList = userList;
    }

    public static ReferenceableObjectType unmarshalUserGroupType(Reader reader) throws MarshalException, ValidationException {
        return (ReferenceableObjectType)Unmarshaller.unmarshal(UserGroupType.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

