/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.ObjectBaseType;
import net.gopro.gdf.data.SignerRefType;
import net.gopro.gdf.data.UserRefType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class SigningInformationType
extends ObjectBaseType
implements Serializable {
    private Date _startDate;
    private Date _deadline;
    private Date _completedDate;
    private UserRefType _requestedBy;
    private String _signingService;
    private String _signingRequestID;
    private int _mininumSigners;
    private boolean _has_mininumSigners;
    private boolean _orderedSigning;
    private boolean _has_orderedSigning;
    private List _signerList = new ArrayList();
    private static final long serialVersionUID = 15000L;

    public void addSigner(SignerRefType vSigner) throws IndexOutOfBoundsException {
        this._signerList.add(vSigner);
    }

    public void addSigner(int index, SignerRefType vSigner) throws IndexOutOfBoundsException {
        this._signerList.add(index, vSigner);
    }

    public void deleteMininumSigners() {
        this._has_mininumSigners = false;
    }

    public void deleteOrderedSigning() {
        this._has_orderedSigning = false;
    }

    public Enumeration enumerateSigners() {
        return Collections.enumeration(this._signerList);
    }

    public Date getCompletedDate() {
        return this._completedDate;
    }

    public Date getDeadline() {
        return this._deadline;
    }

    public int getMininumSigners() {
        return this._mininumSigners;
    }

    public boolean getOrderedSigning() {
        return this._orderedSigning;
    }

    public UserRefType getRequestedBy() {
        return this._requestedBy;
    }

    public SignerRefType getSigner(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._signerList.size()) {
            throw new IndexOutOfBoundsException("getSigner: Index value '" + index + "' not in range [0.." + (this._signerList.size() - 1) + "]");
        }
        return (SignerRefType)this._signerList.get(index);
    }

    public SignerRefType[] getSigners() {
        SignerRefType[] array = new SignerRefType[]{};
        return this._signerList.toArray(array);
    }

    public List getSignersAsReference() {
        return this._signerList;
    }

    public int getSignersCount() {
        return this._signerList.size();
    }

    public String getSigningRequestID() {
        return this._signingRequestID;
    }

    public String getSigningService() {
        return this._signingService;
    }

    public Date getStartDate() {
        return this._startDate;
    }

    public boolean hasMininumSigners() {
        return this._has_mininumSigners;
    }

    public boolean hasOrderedSigning() {
        return this._has_orderedSigning;
    }

    public boolean isOrderedSigning() {
        return this._orderedSigning;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateSigners() {
        return this._signerList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAllSigners() {
        this._signerList.clear();
    }

    public boolean removeSigner(SignerRefType vSigner) {
        boolean removed = this._signerList.remove(vSigner);
        return removed;
    }

    public SignerRefType removeSignerAt(int index) {
        Object obj = this._signerList.remove(index);
        return (SignerRefType)obj;
    }

    public void setCompletedDate(Date completedDate) {
        this._completedDate = completedDate;
    }

    public void setDeadline(Date deadline) {
        this._deadline = deadline;
    }

    public void setMininumSigners(int mininumSigners) {
        this._mininumSigners = mininumSigners;
        this._has_mininumSigners = true;
    }

    public void setOrderedSigning(boolean orderedSigning) {
        this._orderedSigning = orderedSigning;
        this._has_orderedSigning = true;
    }

    public void setRequestedBy(UserRefType requestedBy) {
        this._requestedBy = requestedBy;
    }

    public void setSigner(int index, SignerRefType vSigner) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._signerList.size()) {
            throw new IndexOutOfBoundsException("setSigner: Index value '" + index + "' not in range [0.." + (this._signerList.size() - 1) + "]");
        }
        this._signerList.set(index, vSigner);
    }

    public void setSigners(SignerRefType[] vSignerArray) {
        this._signerList.clear();
        for (int i = 0; i < vSignerArray.length; ++i) {
            this._signerList.add(vSignerArray[i]);
        }
    }

    public void setSigners(List vSignerList) {
        this._signerList.clear();
        this._signerList.addAll(vSignerList);
    }

    public void setSignersAsReference(List signerList) {
        this._signerList = signerList;
    }

    public void setSigningRequestID(String signingRequestID) {
        this._signingRequestID = signingRequestID;
    }

    public void setSigningService(String signingService) {
        this._signingService = signingService;
    }

    public void setStartDate(Date startDate) {
        this._startDate = startDate;
    }

    public static SigningInformationType unmarshalSigningInformationType(Reader reader) throws MarshalException, ValidationException {
        return (SigningInformationType)Unmarshaller.unmarshal(SigningInformationType.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

