/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.ReferenceableObjectType;
import net.gopro.gdf.data.RoutingActionType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class RoutingStepType
extends ReferenceableObjectType
implements Serializable {
    private String _description;
    private List _routingActionList = new ArrayList();
    private Date _deadline;
    private boolean _completed;
    private boolean _has_completed;
    private boolean _canBeIgnored;
    private boolean _has_canBeIgnored;
    private int _stepNumber;
    private boolean _has_stepNumber;
    private boolean _anyApprove;
    private boolean _has_anyApprove;
    private static final long serialVersionUID = 15000L;

    public void addRoutingAction(RoutingActionType vRoutingAction) throws IndexOutOfBoundsException {
        this._routingActionList.add(vRoutingAction);
    }

    public void addRoutingAction(int index, RoutingActionType vRoutingAction) throws IndexOutOfBoundsException {
        this._routingActionList.add(index, vRoutingAction);
    }

    public void deleteAnyApprove() {
        this._has_anyApprove = false;
    }

    public void deleteCanBeIgnored() {
        this._has_canBeIgnored = false;
    }

    public void deleteCompleted() {
        this._has_completed = false;
    }

    public void deleteStepNumber() {
        this._has_stepNumber = false;
    }

    public Enumeration enumerateRoutingActions() {
        return Collections.enumeration(this._routingActionList);
    }

    public boolean getAnyApprove() {
        return this._anyApprove;
    }

    public boolean getCanBeIgnored() {
        return this._canBeIgnored;
    }

    public boolean getCompleted() {
        return this._completed;
    }

    public Date getDeadline() {
        return this._deadline;
    }

    public String getDescription() {
        return this._description;
    }

    public RoutingActionType getRoutingAction(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._routingActionList.size()) {
            throw new IndexOutOfBoundsException("getRoutingAction: Index value '" + index + "' not in range [0.." + (this._routingActionList.size() - 1) + "]");
        }
        return (RoutingActionType)this._routingActionList.get(index);
    }

    public RoutingActionType[] getRoutingActions() {
        RoutingActionType[] array = new RoutingActionType[]{};
        return this._routingActionList.toArray(array);
    }

    public List getRoutingActionsAsReference() {
        return this._routingActionList;
    }

    public int getRoutingActionsCount() {
        return this._routingActionList.size();
    }

    public int getStepNumber() {
        return this._stepNumber;
    }

    public boolean hasAnyApprove() {
        return this._has_anyApprove;
    }

    public boolean hasCanBeIgnored() {
        return this._has_canBeIgnored;
    }

    public boolean hasCompleted() {
        return this._has_completed;
    }

    public boolean hasStepNumber() {
        return this._has_stepNumber;
    }

    public boolean isAnyApprove() {
        return this._anyApprove;
    }

    public boolean isCanBeIgnored() {
        return this._canBeIgnored;
    }

    public boolean isCompleted() {
        return this._completed;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateRoutingActions() {
        return this._routingActionList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAllRoutingActions() {
        this._routingActionList.clear();
    }

    public boolean removeRoutingAction(RoutingActionType vRoutingAction) {
        boolean removed = this._routingActionList.remove(vRoutingAction);
        return removed;
    }

    public RoutingActionType removeRoutingActionAt(int index) {
        Object obj = this._routingActionList.remove(index);
        return (RoutingActionType)obj;
    }

    public void setAnyApprove(boolean anyApprove) {
        this._anyApprove = anyApprove;
        this._has_anyApprove = true;
    }

    public void setCanBeIgnored(boolean canBeIgnored) {
        this._canBeIgnored = canBeIgnored;
        this._has_canBeIgnored = true;
    }

    public void setCompleted(boolean completed) {
        this._completed = completed;
        this._has_completed = true;
    }

    public void setDeadline(Date deadline) {
        this._deadline = deadline;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setRoutingAction(int index, RoutingActionType vRoutingAction) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._routingActionList.size()) {
            throw new IndexOutOfBoundsException("setRoutingAction: Index value '" + index + "' not in range [0.." + (this._routingActionList.size() - 1) + "]");
        }
        this._routingActionList.set(index, vRoutingAction);
    }

    public void setRoutingActions(RoutingActionType[] vRoutingActionArray) {
        this._routingActionList.clear();
        for (int i = 0; i < vRoutingActionArray.length; ++i) {
            this._routingActionList.add(vRoutingActionArray[i]);
        }
    }

    public void setRoutingActions(List vRoutingActionList) {
        this._routingActionList.clear();
        this._routingActionList.addAll(vRoutingActionList);
    }

    public void setRoutingActionsAsReference(List routingActionList) {
        this._routingActionList = routingActionList;
    }

    public void setStepNumber(int stepNumber) {
        this._stepNumber = stepNumber;
        this._has_stepNumber = true;
    }

    public static ReferenceableObjectType unmarshalRoutingStepType(Reader reader) throws MarshalException, ValidationException {
        return (ReferenceableObjectType)Unmarshaller.unmarshal(RoutingStepType.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

