/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.ReferenceableObjectType;
import net.gopro.gdf.data.RoutingActionTemplateType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class RoutingStepTemplateType
extends ReferenceableObjectType
implements Serializable {
    private String _description;
    private int _stepNumber;
    private boolean _has_stepNumber;
    private List _routingActionList = new ArrayList();
    private int _deadlinePeriod;
    private boolean _has_deadlinePeriod;
    private int _deadlinePeriodHours;
    private boolean _has_deadlinePeriodHours;
    private boolean _anyApprove;
    private boolean _has_anyApprove;
    private boolean _canBeIgnored;
    private boolean _has_canBeIgnored;
    private static final long serialVersionUID = 15000L;

    public void addRoutingAction(RoutingActionTemplateType vRoutingAction) throws IndexOutOfBoundsException {
        this._routingActionList.add(vRoutingAction);
    }

    public void addRoutingAction(int index, RoutingActionTemplateType vRoutingAction) throws IndexOutOfBoundsException {
        this._routingActionList.add(index, vRoutingAction);
    }

    public void deleteAnyApprove() {
        this._has_anyApprove = false;
    }

    public void deleteCanBeIgnored() {
        this._has_canBeIgnored = false;
    }

    public void deleteDeadlinePeriod() {
        this._has_deadlinePeriod = false;
    }

    public void deleteDeadlinePeriodHours() {
        this._has_deadlinePeriodHours = false;
    }

    public void deleteStepNumber() {
        this._has_stepNumber = false;
    }

    public Enumeration enumerateRoutingActions() {
        return Collections.enumeration(this._routingActionList);
    }

    public boolean getAnyApprove() {
        return this._anyApprove;
    }

    public boolean getCanBeIgnored() {
        return this._canBeIgnored;
    }

    public int getDeadlinePeriod() {
        return this._deadlinePeriod;
    }

    public int getDeadlinePeriodHours() {
        return this._deadlinePeriodHours;
    }

    public String getDescription() {
        return this._description;
    }

    public RoutingActionTemplateType getRoutingAction(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._routingActionList.size()) {
            throw new IndexOutOfBoundsException("getRoutingAction: Index value '" + index + "' not in range [0.." + (this._routingActionList.size() - 1) + "]");
        }
        return (RoutingActionTemplateType)this._routingActionList.get(index);
    }

    public RoutingActionTemplateType[] getRoutingActions() {
        RoutingActionTemplateType[] array = new RoutingActionTemplateType[]{};
        return this._routingActionList.toArray(array);
    }

    public List getRoutingActionsAsReference() {
        return this._routingActionList;
    }

    public int getRoutingActionsCount() {
        return this._routingActionList.size();
    }

    public int getStepNumber() {
        return this._stepNumber;
    }

    public boolean hasAnyApprove() {
        return this._has_anyApprove;
    }

    public boolean hasCanBeIgnored() {
        return this._has_canBeIgnored;
    }

    public boolean hasDeadlinePeriod() {
        return this._has_deadlinePeriod;
    }

    public boolean hasDeadlinePeriodHours() {
        return this._has_deadlinePeriodHours;
    }

    public boolean hasStepNumber() {
        return this._has_stepNumber;
    }

    public boolean isAnyApprove() {
        return this._anyApprove;
    }

    public boolean isCanBeIgnored() {
        return this._canBeIgnored;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateRoutingActions() {
        return this._routingActionList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAllRoutingActions() {
        this._routingActionList.clear();
    }

    public boolean removeRoutingAction(RoutingActionTemplateType vRoutingAction) {
        boolean removed = this._routingActionList.remove(vRoutingAction);
        return removed;
    }

    public RoutingActionTemplateType removeRoutingActionAt(int index) {
        Object obj = this._routingActionList.remove(index);
        return (RoutingActionTemplateType)obj;
    }

    public void setAnyApprove(boolean anyApprove) {
        this._anyApprove = anyApprove;
        this._has_anyApprove = true;
    }

    public void setCanBeIgnored(boolean canBeIgnored) {
        this._canBeIgnored = canBeIgnored;
        this._has_canBeIgnored = true;
    }

    public void setDeadlinePeriod(int deadlinePeriod) {
        this._deadlinePeriod = deadlinePeriod;
        this._has_deadlinePeriod = true;
    }

    public void setDeadlinePeriodHours(int deadlinePeriodHours) {
        this._deadlinePeriodHours = deadlinePeriodHours;
        this._has_deadlinePeriodHours = true;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setRoutingAction(int index, RoutingActionTemplateType vRoutingAction) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._routingActionList.size()) {
            throw new IndexOutOfBoundsException("setRoutingAction: Index value '" + index + "' not in range [0.." + (this._routingActionList.size() - 1) + "]");
        }
        this._routingActionList.set(index, vRoutingAction);
    }

    public void setRoutingActions(RoutingActionTemplateType[] vRoutingActionArray) {
        this._routingActionList.clear();
        for (int i = 0; i < vRoutingActionArray.length; ++i) {
            this._routingActionList.add(vRoutingActionArray[i]);
        }
    }

    public void setRoutingActions(List vRoutingActionList) {
        this._routingActionList.clear();
        this._routingActionList.addAll(vRoutingActionList);
    }

    public void setRoutingActionsAsReference(List routingActionList) {
        this._routingActionList = routingActionList;
    }

    public void setStepNumber(int stepNumber) {
        this._stepNumber = stepNumber;
        this._has_stepNumber = true;
    }

    public static ReferenceableObjectType unmarshalRoutingStepTemplateType(Reader reader) throws MarshalException, ValidationException {
        return (ReferenceableObjectType)Unmarshaller.unmarshal(RoutingStepTemplateType.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

