/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.HistoryType;
import net.gopro.gdf.data.ObjectBaseType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class HistoryCollectionType
extends ObjectBaseType
implements Serializable {
    private List _historyEntryList = new ArrayList();
    private static final long serialVersionUID = 15000L;

    public void addHistoryEntry(HistoryType vHistoryEntry) throws IndexOutOfBoundsException {
        this._historyEntryList.add(vHistoryEntry);
    }

    public void addHistoryEntry(int index, HistoryType vHistoryEntry) throws IndexOutOfBoundsException {
        this._historyEntryList.add(index, vHistoryEntry);
    }

    public Enumeration enumerateHistoryEntries() {
        return Collections.enumeration(this._historyEntryList);
    }

    public HistoryType[] getHistoryEntries() {
        HistoryType[] array = new HistoryType[]{};
        return this._historyEntryList.toArray(array);
    }

    public List getHistoryEntriesAsReference() {
        return this._historyEntryList;
    }

    public int getHistoryEntriesCount() {
        return this._historyEntryList.size();
    }

    public HistoryType getHistoryEntry(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._historyEntryList.size()) {
            throw new IndexOutOfBoundsException("getHistoryEntry: Index value '" + index + "' not in range [0.." + (this._historyEntryList.size() - 1) + "]");
        }
        return (HistoryType)this._historyEntryList.get(index);
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateHistoryEntries() {
        return this._historyEntryList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAllHistoryEntries() {
        this._historyEntryList.clear();
    }

    public boolean removeHistoryEntry(HistoryType vHistoryEntry) {
        boolean removed = this._historyEntryList.remove(vHistoryEntry);
        return removed;
    }

    public HistoryType removeHistoryEntryAt(int index) {
        Object obj = this._historyEntryList.remove(index);
        return (HistoryType)obj;
    }

    public void setHistoryEntries(HistoryType[] vHistoryEntryArray) {
        this._historyEntryList.clear();
        for (int i = 0; i < vHistoryEntryArray.length; ++i) {
            this._historyEntryList.add(vHistoryEntryArray[i]);
        }
    }

    public void setHistoryEntries(List vHistoryEntryList) {
        this._historyEntryList.clear();
        this._historyEntryList.addAll(vHistoryEntryList);
    }

    public void setHistoryEntriesAsReference(List historyEntryList) {
        this._historyEntryList = historyEntryList;
    }

    public void setHistoryEntry(int index, HistoryType vHistoryEntry) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._historyEntryList.size()) {
            throw new IndexOutOfBoundsException("setHistoryEntry: Index value '" + index + "' not in range [0.." + (this._historyEntryList.size() - 1) + "]");
        }
        this._historyEntryList.set(index, vHistoryEntry);
    }

    public static HistoryCollectionType unmarshalHistoryCollectionType(Reader reader) throws MarshalException, ValidationException {
        return (HistoryCollectionType)Unmarshaller.unmarshal(HistoryCollectionType.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

