/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.DataSetColumnType;
import net.gopro.gdf.data.ObjectBaseType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class FlexibleDataSetMetaInfoType
extends ObjectBaseType
implements Serializable {
    private int _mappedDocumentType;
    private boolean _has_mappedDocumentType;
    private List _columnList = new ArrayList();
    private static final long serialVersionUID = 15000L;

    public void addColumn(DataSetColumnType vColumn) throws IndexOutOfBoundsException {
        this._columnList.add(vColumn);
    }

    public void addColumn(int index, DataSetColumnType vColumn) throws IndexOutOfBoundsException {
        this._columnList.add(index, vColumn);
    }

    public void deleteMappedDocumentType() {
        this._has_mappedDocumentType = false;
    }

    public Enumeration enumerateColumns() {
        return Collections.enumeration(this._columnList);
    }

    public DataSetColumnType getColumn(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._columnList.size()) {
            throw new IndexOutOfBoundsException("getColumn: Index value '" + index + "' not in range [0.." + (this._columnList.size() - 1) + "]");
        }
        return (DataSetColumnType)this._columnList.get(index);
    }

    public DataSetColumnType[] getColumns() {
        DataSetColumnType[] array = new DataSetColumnType[]{};
        return this._columnList.toArray(array);
    }

    public List getColumnsAsReference() {
        return this._columnList;
    }

    public int getColumnsCount() {
        return this._columnList.size();
    }

    public int getMappedDocumentType() {
        return this._mappedDocumentType;
    }

    public boolean hasMappedDocumentType() {
        return this._has_mappedDocumentType;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateColumns() {
        return this._columnList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAllColumns() {
        this._columnList.clear();
    }

    public boolean removeColumn(DataSetColumnType vColumn) {
        boolean removed = this._columnList.remove(vColumn);
        return removed;
    }

    public DataSetColumnType removeColumnAt(int index) {
        Object obj = this._columnList.remove(index);
        return (DataSetColumnType)obj;
    }

    public void setColumn(int index, DataSetColumnType vColumn) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._columnList.size()) {
            throw new IndexOutOfBoundsException("setColumn: Index value '" + index + "' not in range [0.." + (this._columnList.size() - 1) + "]");
        }
        this._columnList.set(index, vColumn);
    }

    public void setColumns(DataSetColumnType[] vColumnArray) {
        this._columnList.clear();
        for (int i = 0; i < vColumnArray.length; ++i) {
            this._columnList.add(vColumnArray[i]);
        }
    }

    public void setColumns(List vColumnList) {
        this._columnList.clear();
        this._columnList.addAll(vColumnList);
    }

    public void setColumnsAsReference(List columnList) {
        this._columnList = columnList;
    }

    public void setMappedDocumentType(int mappedDocumentType) {
        this._mappedDocumentType = mappedDocumentType;
        this._has_mappedDocumentType = true;
    }

    public static FlexibleDataSetMetaInfoType unmarshalFlexibleDataSetMetaInfoType(Reader reader) throws MarshalException, ValidationException {
        return (FlexibleDataSetMetaInfoType)Unmarshaller.unmarshal(FlexibleDataSetMetaInfoType.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

