/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.DocumentBaseType;
import net.gopro.gdf.data.FileAttachmentType;
import net.gopro.gdf.data.ListValueRefType;
import net.gopro.gdf.data.MetaDataType;
import net.gopro.gdf.data.ReferenceableObjectType;
import net.gopro.gdf.data.SigningInformationType;
import net.gopro.gdf.data.UserRefType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class ExternalDocumentVersionType
extends DocumentBaseType
implements Serializable {
    private SigningInformationType _signingInfo;
    private int _versionNumber;
    private boolean _has_versionNumber;
    private int _minorVersionNumber;
    private boolean _has_minorVersionNumber;
    private String _versionName;
    private UserRefType _checkedInBy;
    private Date _checkedInTime;
    private String _comments;
    private FileAttachmentType _attachment;
    private List _metaDataList = new ArrayList();
    private ListValueRefType _format;
    private List _additionalAttachmentList = new ArrayList();
    private static final long serialVersionUID = 15000L;

    public void addAdditionalAttachment(FileAttachmentType vAdditionalAttachment) throws IndexOutOfBoundsException {
        this._additionalAttachmentList.add(vAdditionalAttachment);
    }

    public void addAdditionalAttachment(int index, FileAttachmentType vAdditionalAttachment) throws IndexOutOfBoundsException {
        this._additionalAttachmentList.add(index, vAdditionalAttachment);
    }

    public void addMetaData(MetaDataType vMetaData) throws IndexOutOfBoundsException {
        this._metaDataList.add(vMetaData);
    }

    public void addMetaData(int index, MetaDataType vMetaData) throws IndexOutOfBoundsException {
        this._metaDataList.add(index, vMetaData);
    }

    public void deleteMinorVersionNumber() {
        this._has_minorVersionNumber = false;
    }

    public void deleteVersionNumber() {
        this._has_versionNumber = false;
    }

    public Enumeration enumerateAdditionalAttachments() {
        return Collections.enumeration(this._additionalAttachmentList);
    }

    public Enumeration enumerateMetaDatas() {
        return Collections.enumeration(this._metaDataList);
    }

    public FileAttachmentType getAdditionalAttachment(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._additionalAttachmentList.size()) {
            throw new IndexOutOfBoundsException("getAdditionalAttachment: Index value '" + index + "' not in range [0.." + (this._additionalAttachmentList.size() - 1) + "]");
        }
        return (FileAttachmentType)this._additionalAttachmentList.get(index);
    }

    public FileAttachmentType[] getAdditionalAttachments() {
        FileAttachmentType[] array = new FileAttachmentType[]{};
        return this._additionalAttachmentList.toArray(array);
    }

    public List getAdditionalAttachmentsAsReference() {
        return this._additionalAttachmentList;
    }

    public int getAdditionalAttachmentsCount() {
        return this._additionalAttachmentList.size();
    }

    public FileAttachmentType getAttachment() {
        return this._attachment;
    }

    public UserRefType getCheckedInBy() {
        return this._checkedInBy;
    }

    public Date getCheckedInTime() {
        return this._checkedInTime;
    }

    public String getComments() {
        return this._comments;
    }

    public ListValueRefType getFormat() {
        return this._format;
    }

    public MetaDataType getMetaData(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._metaDataList.size()) {
            throw new IndexOutOfBoundsException("getMetaData: Index value '" + index + "' not in range [0.." + (this._metaDataList.size() - 1) + "]");
        }
        return (MetaDataType)this._metaDataList.get(index);
    }

    public MetaDataType[] getMetaDatas() {
        MetaDataType[] array = new MetaDataType[]{};
        return this._metaDataList.toArray(array);
    }

    public List getMetaDatasAsReference() {
        return this._metaDataList;
    }

    public int getMetaDatasCount() {
        return this._metaDataList.size();
    }

    public int getMinorVersionNumber() {
        return this._minorVersionNumber;
    }

    public SigningInformationType getSigningInfo() {
        return this._signingInfo;
    }

    public String getVersionName() {
        return this._versionName;
    }

    public int getVersionNumber() {
        return this._versionNumber;
    }

    public boolean hasMinorVersionNumber() {
        return this._has_minorVersionNumber;
    }

    public boolean hasVersionNumber() {
        return this._has_versionNumber;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateAdditionalAttachments() {
        return this._additionalAttachmentList.iterator();
    }

    public Iterator iterateMetaDatas() {
        return this._metaDataList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean removeAdditionalAttachment(FileAttachmentType vAdditionalAttachment) {
        boolean removed = this._additionalAttachmentList.remove(vAdditionalAttachment);
        return removed;
    }

    public FileAttachmentType removeAdditionalAttachmentAt(int index) {
        Object obj = this._additionalAttachmentList.remove(index);
        return (FileAttachmentType)obj;
    }

    public void removeAllAdditionalAttachments() {
        this._additionalAttachmentList.clear();
    }

    public void removeAllMetaDatas() {
        this._metaDataList.clear();
    }

    public boolean removeMetaData(MetaDataType vMetaData) {
        boolean removed = this._metaDataList.remove(vMetaData);
        return removed;
    }

    public MetaDataType removeMetaDataAt(int index) {
        Object obj = this._metaDataList.remove(index);
        return (MetaDataType)obj;
    }

    public void setAdditionalAttachment(int index, FileAttachmentType vAdditionalAttachment) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._additionalAttachmentList.size()) {
            throw new IndexOutOfBoundsException("setAdditionalAttachment: Index value '" + index + "' not in range [0.." + (this._additionalAttachmentList.size() - 1) + "]");
        }
        this._additionalAttachmentList.set(index, vAdditionalAttachment);
    }

    public void setAdditionalAttachments(FileAttachmentType[] vAdditionalAttachmentArray) {
        this._additionalAttachmentList.clear();
        for (int i = 0; i < vAdditionalAttachmentArray.length; ++i) {
            this._additionalAttachmentList.add(vAdditionalAttachmentArray[i]);
        }
    }

    public void setAdditionalAttachments(List vAdditionalAttachmentList) {
        this._additionalAttachmentList.clear();
        this._additionalAttachmentList.addAll(vAdditionalAttachmentList);
    }

    public void setAdditionalAttachmentsAsReference(List additionalAttachmentList) {
        this._additionalAttachmentList = additionalAttachmentList;
    }

    public void setAttachment(FileAttachmentType attachment) {
        this._attachment = attachment;
    }

    public void setCheckedInBy(UserRefType checkedInBy) {
        this._checkedInBy = checkedInBy;
    }

    public void setCheckedInTime(Date checkedInTime) {
        this._checkedInTime = checkedInTime;
    }

    public void setComments(String comments) {
        this._comments = comments;
    }

    public void setFormat(ListValueRefType format) {
        this._format = format;
    }

    public void setMetaData(int index, MetaDataType vMetaData) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._metaDataList.size()) {
            throw new IndexOutOfBoundsException("setMetaData: Index value '" + index + "' not in range [0.." + (this._metaDataList.size() - 1) + "]");
        }
        this._metaDataList.set(index, vMetaData);
    }

    public void setMetaDatas(MetaDataType[] vMetaDataArray) {
        this._metaDataList.clear();
        for (int i = 0; i < vMetaDataArray.length; ++i) {
            this._metaDataList.add(vMetaDataArray[i]);
        }
    }

    public void setMetaDatas(List vMetaDataList) {
        this._metaDataList.clear();
        this._metaDataList.addAll(vMetaDataList);
    }

    public void setMetaDatasAsReference(List metaDataList) {
        this._metaDataList = metaDataList;
    }

    public void setMinorVersionNumber(int minorVersionNumber) {
        this._minorVersionNumber = minorVersionNumber;
        this._has_minorVersionNumber = true;
    }

    public void setSigningInfo(SigningInformationType signingInfo) {
        this._signingInfo = signingInfo;
    }

    public void setVersionName(String versionName) {
        this._versionName = versionName;
    }

    public void setVersionNumber(int versionNumber) {
        this._versionNumber = versionNumber;
        this._has_versionNumber = true;
    }

    public static ReferenceableObjectType unmarshalExternalDocumentVersionType(Reader reader) throws MarshalException, ValidationException {
        return (ReferenceableObjectType)Unmarshaller.unmarshal(ExternalDocumentVersionType.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

