/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.ObjectBaseType;
import net.gopro.gdf.data.ReferenceableObjectType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class EntityCollectionType
extends ObjectBaseType
implements Serializable {
    private List _entitieList = new ArrayList();
    private static final long serialVersionUID = 15000L;

    public void addEntity(ReferenceableObjectType vEntitie) throws IndexOutOfBoundsException {
        this._entitieList.add(vEntitie);
    }

    public void addEntity(int index, ReferenceableObjectType vEntitie) throws IndexOutOfBoundsException {
        this._entitieList.add(index, vEntitie);
    }

    public Enumeration enumerateEntities() {
        return Collections.enumeration(this._entitieList);
    }

    public ReferenceableObjectType getEntity(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._entitieList.size()) {
            throw new IndexOutOfBoundsException("getEntitie: Index value '" + index + "' not in range [0.." + (this._entitieList.size() - 1) + "]");
        }
        return (ReferenceableObjectType)this._entitieList.get(index);
    }

    public ReferenceableObjectType[] getEntities() {
        ReferenceableObjectType[] array = new ReferenceableObjectType[]{};
        return this._entitieList.toArray(array);
    }

    public List getEntitiesAsReference() {
        return this._entitieList;
    }

    public int getEntitiesCount() {
        return this._entitieList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateEntities() {
        return this._entitieList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAllEntities() {
        this._entitieList.clear();
    }

    public boolean removeEntity(ReferenceableObjectType vEntitie) {
        boolean removed = this._entitieList.remove(vEntitie);
        return removed;
    }

    public ReferenceableObjectType removeEntityAt(int index) {
        Object obj = this._entitieList.remove(index);
        return (ReferenceableObjectType)obj;
    }

    public void setEntitie(int index, ReferenceableObjectType vEntitie) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._entitieList.size()) {
            throw new IndexOutOfBoundsException("setEntitie: Index value '" + index + "' not in range [0.." + (this._entitieList.size() - 1) + "]");
        }
        this._entitieList.set(index, vEntitie);
    }

    public void setEntities(ReferenceableObjectType[] vEntitieArray) {
        this._entitieList.clear();
        for (int i = 0; i < vEntitieArray.length; ++i) {
            this._entitieList.add(vEntitieArray[i]);
        }
    }

    public void setEntities(List vEntitieList) {
        this._entitieList.clear();
        this._entitieList.addAll(vEntitieList);
    }

    public void setEntitiesAsReference(List entitieList) {
        this._entitieList = entitieList;
    }

    public static EntityCollectionType unmarshalEntityCollectionType(Reader reader) throws MarshalException, ValidationException {
        return (EntityCollectionType)Unmarshaller.unmarshal(EntityCollectionType.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

