/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.ACLDocumentRefType;
import net.gopro.gdf.data.DocumentBaseType;
import net.gopro.gdf.data.ListValueRefType;
import net.gopro.gdf.data.ReferenceableObjectType;
import net.gopro.gdf.data.TaskType;
import net.gopro.gdf.data.UserRefType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class DocumentType
extends DocumentBaseType
implements Serializable {
    private String _body;
    private ListValueRefType _status;
    private Date _statusModifiedDate;
    private Date _statusDeadlineDate;
    private List _subscriberList = new ArrayList();
    private ACLDocumentRefType _organizationUnit;
    private String _physicalLocation;
    private List _keywordList = new ArrayList();
    private Date _deadline;
    private Date _startDate;
    private Date _completedDate;
    private ACLDocumentRefType _responsibleEmployee;
    private List _publishToList = new ArrayList();
    private boolean _deliverToArchives;
    private boolean _has_deliverToArchives;
    private boolean _inheritAccess;
    private boolean _has_inheritAccess;
    private String _documentNumber;
    private Date _archivedDate;
    private Date _cassationDate;
    private ListValueRefType _cassationCode;
    private List _taskList = new ArrayList();
    private static final long serialVersionUID = 15000L;

    public void addKeyword(String vKeyword) throws IndexOutOfBoundsException {
        this._keywordList.add(vKeyword);
    }

    public void addKeyword(int index, String vKeyword) throws IndexOutOfBoundsException {
        this._keywordList.add(index, vKeyword);
    }

    public void addPublishTo(String vPublishTo) throws IndexOutOfBoundsException {
        this._publishToList.add(vPublishTo);
    }

    public void addPublishTo(int index, String vPublishTo) throws IndexOutOfBoundsException {
        this._publishToList.add(index, vPublishTo);
    }

    public void addSubscriber(UserRefType vSubscriber) throws IndexOutOfBoundsException {
        this._subscriberList.add(vSubscriber);
    }

    public void addSubscriber(int index, UserRefType vSubscriber) throws IndexOutOfBoundsException {
        this._subscriberList.add(index, vSubscriber);
    }

    public void addTask(TaskType vTask) throws IndexOutOfBoundsException {
        this._taskList.add(vTask);
    }

    public void addTask(int index, TaskType vTask) throws IndexOutOfBoundsException {
        this._taskList.add(index, vTask);
    }

    public void deleteDeliverToArchives() {
        this._has_deliverToArchives = false;
    }

    public void deleteInheritAccess() {
        this._has_inheritAccess = false;
    }

    public Enumeration enumerateKeywords() {
        return Collections.enumeration(this._keywordList);
    }

    public Enumeration enumeratePublishTos() {
        return Collections.enumeration(this._publishToList);
    }

    public Enumeration enumerateSubscribers() {
        return Collections.enumeration(this._subscriberList);
    }

    public Enumeration enumerateTasks() {
        return Collections.enumeration(this._taskList);
    }

    public Date getArchivedDate() {
        return this._archivedDate;
    }

    public String getBody() {
        return this._body;
    }

    public ListValueRefType getCassationCode() {
        return this._cassationCode;
    }

    public Date getCassationDate() {
        return this._cassationDate;
    }

    public Date getCompletedDate() {
        return this._completedDate;
    }

    public Date getDeadline() {
        return this._deadline;
    }

    public boolean getDeliverToArchives() {
        return this._deliverToArchives;
    }

    public String getDocumentNumber() {
        return this._documentNumber;
    }

    public boolean getInheritAccess() {
        return this._inheritAccess;
    }

    public String getKeyword(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._keywordList.size()) {
            throw new IndexOutOfBoundsException("getKeyword: Index value '" + index + "' not in range [0.." + (this._keywordList.size() - 1) + "]");
        }
        return (String)this._keywordList.get(index);
    }

    public String[] getKeywords() {
        String[] array = new String[]{};
        return this._keywordList.toArray(array);
    }

    public List getKeywordsAsReference() {
        return this._keywordList;
    }

    public int getKeywordsCount() {
        return this._keywordList.size();
    }

    public ACLDocumentRefType getOrganizationUnit() {
        return this._organizationUnit;
    }

    public String getPhysicalLocation() {
        return this._physicalLocation;
    }

    public String getPublishTo(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._publishToList.size()) {
            throw new IndexOutOfBoundsException("getPublishTo: Index value '" + index + "' not in range [0.." + (this._publishToList.size() - 1) + "]");
        }
        return (String)this._publishToList.get(index);
    }

    public String[] getPublishTos() {
        String[] array = new String[]{};
        return this._publishToList.toArray(array);
    }

    public List getPublishTosAsReference() {
        return this._publishToList;
    }

    public int getPublishTosCount() {
        return this._publishToList.size();
    }

    public ACLDocumentRefType getResponsibleEmployee() {
        return this._responsibleEmployee;
    }

    public Date getStartDate() {
        return this._startDate;
    }

    public ListValueRefType getStatus() {
        return this._status;
    }

    public Date getStatusDeadlineDate() {
        return this._statusDeadlineDate;
    }

    public Date getStatusModifiedDate() {
        return this._statusModifiedDate;
    }

    public UserRefType getSubscriber(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._subscriberList.size()) {
            throw new IndexOutOfBoundsException("getSubscriber: Index value '" + index + "' not in range [0.." + (this._subscriberList.size() - 1) + "]");
        }
        return (UserRefType)this._subscriberList.get(index);
    }

    public UserRefType[] getSubscribers() {
        UserRefType[] array = new UserRefType[]{};
        return this._subscriberList.toArray(array);
    }

    public List getSubscribersAsReference() {
        return this._subscriberList;
    }

    public int getSubscribersCount() {
        return this._subscriberList.size();
    }

    public TaskType getTask(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._taskList.size()) {
            throw new IndexOutOfBoundsException("getTask: Index value '" + index + "' not in range [0.." + (this._taskList.size() - 1) + "]");
        }
        return (TaskType)this._taskList.get(index);
    }

    public TaskType[] getTasks() {
        TaskType[] array = new TaskType[]{};
        return this._taskList.toArray(array);
    }

    public List getTasksAsReference() {
        return this._taskList;
    }

    public int getTasksCount() {
        return this._taskList.size();
    }

    public boolean hasDeliverToArchives() {
        return this._has_deliverToArchives;
    }

    public boolean hasInheritAccess() {
        return this._has_inheritAccess;
    }

    public boolean isDeliverToArchives() {
        return this._deliverToArchives;
    }

    public boolean isInheritAccess() {
        return this._inheritAccess;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateKeywords() {
        return this._keywordList.iterator();
    }

    public Iterator iteratePublishTos() {
        return this._publishToList.iterator();
    }

    public Iterator iterateSubscribers() {
        return this._subscriberList.iterator();
    }

    public Iterator iterateTasks() {
        return this._taskList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAllKeywords() {
        this._keywordList.clear();
    }

    public void removeAllPublishTos() {
        this._publishToList.clear();
    }

    public void removeAllSubscribers() {
        this._subscriberList.clear();
    }

    public void removeAllTasks() {
        this._taskList.clear();
    }

    public boolean removeKeyword(String vKeyword) {
        boolean removed = this._keywordList.remove(vKeyword);
        return removed;
    }

    public String removeKeywordAt(int index) {
        Object obj = this._keywordList.remove(index);
        return (String)obj;
    }

    public boolean removePublishTo(String vPublishTo) {
        boolean removed = this._publishToList.remove(vPublishTo);
        return removed;
    }

    public String removePublishToAt(int index) {
        Object obj = this._publishToList.remove(index);
        return (String)obj;
    }

    public boolean removeSubscriber(UserRefType vSubscriber) {
        boolean removed = this._subscriberList.remove(vSubscriber);
        return removed;
    }

    public UserRefType removeSubscriberAt(int index) {
        Object obj = this._subscriberList.remove(index);
        return (UserRefType)obj;
    }

    public boolean removeTask(TaskType vTask) {
        boolean removed = this._taskList.remove(vTask);
        return removed;
    }

    public TaskType removeTaskAt(int index) {
        Object obj = this._taskList.remove(index);
        return (TaskType)obj;
    }

    public void setArchivedDate(Date archivedDate) {
        this._archivedDate = archivedDate;
    }

    public void setBody(String body) {
        this._body = body;
    }

    public void setCassationCode(ListValueRefType cassationCode) {
        this._cassationCode = cassationCode;
    }

    public void setCassationDate(Date cassationDate) {
        this._cassationDate = cassationDate;
    }

    public void setCompletedDate(Date completedDate) {
        this._completedDate = completedDate;
    }

    public void setDeadline(Date deadline) {
        this._deadline = deadline;
    }

    public void setDeliverToArchives(boolean deliverToArchives) {
        this._deliverToArchives = deliverToArchives;
        this._has_deliverToArchives = true;
    }

    public void setDocumentNumber(String documentNumber) {
        this._documentNumber = documentNumber;
    }

    public void setInheritAccess(boolean inheritAccess) {
        this._inheritAccess = inheritAccess;
        this._has_inheritAccess = true;
    }

    public void setKeyword(int index, String vKeyword) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._keywordList.size()) {
            throw new IndexOutOfBoundsException("setKeyword: Index value '" + index + "' not in range [0.." + (this._keywordList.size() - 1) + "]");
        }
        this._keywordList.set(index, vKeyword);
    }

    public void setKeywords(String[] vKeywordArray) {
        this._keywordList.clear();
        for (int i = 0; i < vKeywordArray.length; ++i) {
            this._keywordList.add(vKeywordArray[i]);
        }
    }

    public void setKeywords(List vKeywordList) {
        this._keywordList.clear();
        this._keywordList.addAll(vKeywordList);
    }

    public void setKeywordsAsReference(List keywordList) {
        this._keywordList = keywordList;
    }

    public void setOrganizationUnit(ACLDocumentRefType organizationUnit) {
        this._organizationUnit = organizationUnit;
    }

    public void setPhysicalLocation(String physicalLocation) {
        this._physicalLocation = physicalLocation;
    }

    public void setPublishTo(int index, String vPublishTo) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._publishToList.size()) {
            throw new IndexOutOfBoundsException("setPublishTo: Index value '" + index + "' not in range [0.." + (this._publishToList.size() - 1) + "]");
        }
        this._publishToList.set(index, vPublishTo);
    }

    public void setPublishTos(String[] vPublishToArray) {
        this._publishToList.clear();
        for (int i = 0; i < vPublishToArray.length; ++i) {
            this._publishToList.add(vPublishToArray[i]);
        }
    }

    public void setPublishTos(List vPublishToList) {
        this._publishToList.clear();
        this._publishToList.addAll(vPublishToList);
    }

    public void setPublishTosAsReference(List publishToList) {
        this._publishToList = publishToList;
    }

    public void setResponsibleEmployee(ACLDocumentRefType responsibleEmployee) {
        this._responsibleEmployee = responsibleEmployee;
    }

    public void setStartDate(Date startDate) {
        this._startDate = startDate;
    }

    public void setStatus(ListValueRefType status) {
        this._status = status;
    }

    public void setStatusDeadlineDate(Date statusDeadlineDate) {
        this._statusDeadlineDate = statusDeadlineDate;
    }

    public void setStatusModifiedDate(Date statusModifiedDate) {
        this._statusModifiedDate = statusModifiedDate;
    }

    public void setSubscriber(int index, UserRefType vSubscriber) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._subscriberList.size()) {
            throw new IndexOutOfBoundsException("setSubscriber: Index value '" + index + "' not in range [0.." + (this._subscriberList.size() - 1) + "]");
        }
        this._subscriberList.set(index, vSubscriber);
    }

    public void setSubscribers(UserRefType[] vSubscriberArray) {
        this._subscriberList.clear();
        for (int i = 0; i < vSubscriberArray.length; ++i) {
            this._subscriberList.add(vSubscriberArray[i]);
        }
    }

    public void setSubscribers(List vSubscriberList) {
        this._subscriberList.clear();
        this._subscriberList.addAll(vSubscriberList);
    }

    public void setSubscribersAsReference(List subscriberList) {
        this._subscriberList = subscriberList;
    }

    public void setTask(int index, TaskType vTask) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._taskList.size()) {
            throw new IndexOutOfBoundsException("setTask: Index value '" + index + "' not in range [0.." + (this._taskList.size() - 1) + "]");
        }
        this._taskList.set(index, vTask);
    }

    public void setTasks(TaskType[] vTaskArray) {
        this._taskList.clear();
        for (int i = 0; i < vTaskArray.length; ++i) {
            this._taskList.add(vTaskArray[i]);
        }
    }

    public void setTasks(List vTaskList) {
        this._taskList.clear();
        this._taskList.addAll(vTaskList);
    }

    public void setTasksAsReference(List taskList) {
        this._taskList = taskList;
    }

    public static ReferenceableObjectType unmarshalDocumentType(Reader reader) throws MarshalException, ValidationException {
        return (ReferenceableObjectType)Unmarshaller.unmarshal(DocumentType.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

