/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.DocumentBaseType;
import net.gopro.gdf.data.ObjectBaseType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class DocumentCollectionType
extends ObjectBaseType
implements Serializable {
    private List _documentList = new ArrayList();
    private static final long serialVersionUID = 15000L;

    public void addDocument(DocumentBaseType vDocument) throws IndexOutOfBoundsException {
        this._documentList.add(vDocument);
    }

    public void addDocument(int index, DocumentBaseType vDocument) throws IndexOutOfBoundsException {
        this._documentList.add(index, vDocument);
    }

    public Enumeration enumerateDocuments() {
        return Collections.enumeration(this._documentList);
    }

    public DocumentBaseType getDocument(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._documentList.size()) {
            throw new IndexOutOfBoundsException("getDocument: Index value '" + index + "' not in range [0.." + (this._documentList.size() - 1) + "]");
        }
        return (DocumentBaseType)this._documentList.get(index);
    }

    public DocumentBaseType[] getDocuments() {
        DocumentBaseType[] array = new DocumentBaseType[]{};
        return this._documentList.toArray(array);
    }

    public List getDocumentsAsReference() {
        return this._documentList;
    }

    public int getDocumentsCount() {
        return this._documentList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateDocuments() {
        return this._documentList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAllDocuments() {
        this._documentList.clear();
    }

    public boolean removeDocument(DocumentBaseType vDocument) {
        boolean removed = this._documentList.remove(vDocument);
        return removed;
    }

    public DocumentBaseType removeDocumentAt(int index) {
        Object obj = this._documentList.remove(index);
        return (DocumentBaseType)obj;
    }

    public void setDocument(int index, DocumentBaseType vDocument) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._documentList.size()) {
            throw new IndexOutOfBoundsException("setDocument: Index value '" + index + "' not in range [0.." + (this._documentList.size() - 1) + "]");
        }
        this._documentList.set(index, vDocument);
    }

    public void setDocuments(DocumentBaseType[] vDocumentArray) {
        this._documentList.clear();
        for (int i = 0; i < vDocumentArray.length; ++i) {
            this._documentList.add(vDocumentArray[i]);
        }
    }

    public void setDocuments(List vDocumentList) {
        this._documentList.clear();
        this._documentList.addAll(vDocumentList);
    }

    public void setDocumentsAsReference(List documentList) {
        this._documentList = documentList;
    }

    public static DocumentCollectionType unmarshalDocumentCollectionType(Reader reader) throws MarshalException, ValidationException {
        return (DocumentCollectionType)Unmarshaller.unmarshal(DocumentCollectionType.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

