/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.ClientUnitBaseType;
import net.gopro.gdf.data.ListValueRefType;
import net.gopro.gdf.data.ReferenceableObjectType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class CompanyType
extends ClientUnitBaseType
implements Serializable {
    private String _clientNumber;
    private List _departmentList = new ArrayList();
    private ListValueRefType _companyType;
    private static final long serialVersionUID = 15000L;

    public void addDepartment(String vDepartment) throws IndexOutOfBoundsException {
        this._departmentList.add(vDepartment);
    }

    public void addDepartment(int index, String vDepartment) throws IndexOutOfBoundsException {
        this._departmentList.add(index, vDepartment);
    }

    public Enumeration enumerateDepartments() {
        return Collections.enumeration(this._departmentList);
    }

    public String getClientNumber() {
        return this._clientNumber;
    }

    public ListValueRefType getCompanyType() {
        return this._companyType;
    }

    public String getDepartment(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._departmentList.size()) {
            throw new IndexOutOfBoundsException("getDepartment: Index value '" + index + "' not in range [0.." + (this._departmentList.size() - 1) + "]");
        }
        return (String)this._departmentList.get(index);
    }

    public String[] getDepartments() {
        String[] array = new String[]{};
        return this._departmentList.toArray(array);
    }

    public List getDepartmentsAsReference() {
        return this._departmentList;
    }

    public int getDepartmentsCount() {
        return this._departmentList.size();
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateDepartments() {
        return this._departmentList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAllDepartments() {
        this._departmentList.clear();
    }

    public boolean removeDepartment(String vDepartment) {
        boolean removed = this._departmentList.remove(vDepartment);
        return removed;
    }

    public String removeDepartmentAt(int index) {
        Object obj = this._departmentList.remove(index);
        return (String)obj;
    }

    public void setClientNumber(String clientNumber) {
        this._clientNumber = clientNumber;
    }

    public void setCompanyType(ListValueRefType companyType) {
        this._companyType = companyType;
    }

    public void setDepartment(int index, String vDepartment) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._departmentList.size()) {
            throw new IndexOutOfBoundsException("setDepartment: Index value '" + index + "' not in range [0.." + (this._departmentList.size() - 1) + "]");
        }
        this._departmentList.set(index, vDepartment);
    }

    public void setDepartments(String[] vDepartmentArray) {
        this._departmentList.clear();
        for (int i = 0; i < vDepartmentArray.length; ++i) {
            this._departmentList.add(vDepartmentArray[i]);
        }
    }

    public void setDepartments(List vDepartmentList) {
        this._departmentList.clear();
        this._departmentList.addAll(vDepartmentList);
    }

    public void setDepartmentsAsReference(List departmentList) {
        this._departmentList = departmentList;
    }

    public static ReferenceableObjectType unmarshalCompanyType(Reader reader) throws MarshalException, ValidationException {
        return (ReferenceableObjectType)Unmarshaller.unmarshal(CompanyType.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

