/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.AddressType;
import net.gopro.gdf.data.CaseTemplateRefType;
import net.gopro.gdf.data.CategoryRefType;
import net.gopro.gdf.data.ClientBaseRefType;
import net.gopro.gdf.data.DocumentType;
import net.gopro.gdf.data.FileplanRefType;
import net.gopro.gdf.data.FormDocumentTemplateRefType;
import net.gopro.gdf.data.ListValueRefType;
import net.gopro.gdf.data.ReferenceableObjectType;
import net.gopro.gdf.data.UserRefType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class CaseType
extends DocumentType
implements Serializable {
    private String _caseNumber;
    private String _archiveNumber;
    private CaseTemplateRefType _caseTemplate;
    private FormDocumentTemplateRefType _formTemplate;
    private CategoryRefType _category;
    private ClientBaseRefType _involvedParty;
    private List _coResponsibleEmployeeList = new ArrayList();
    private List _instructionList = new ArrayList();
    private ListValueRefType _priority;
    private FileplanRefType _filePlanLocation;
    private String _clientType;
    private String _contactName;
    private List _addressList = new ArrayList();
    private boolean _personalSensitive;
    private boolean _has_personalSensitive;
    private static final long serialVersionUID = 15000L;

    public void addAddress(AddressType vAddress) throws IndexOutOfBoundsException {
        this._addressList.add(vAddress);
    }

    public void addAddress(int index, AddressType vAddress) throws IndexOutOfBoundsException {
        this._addressList.add(index, vAddress);
    }

    public void addCoResponsibleEmployee(UserRefType vCoResponsibleEmployee) throws IndexOutOfBoundsException {
        this._coResponsibleEmployeeList.add(vCoResponsibleEmployee);
    }

    public void addCoResponsibleEmployee(int index, UserRefType vCoResponsibleEmployee) throws IndexOutOfBoundsException {
        this._coResponsibleEmployeeList.add(index, vCoResponsibleEmployee);
    }

    public void addInstruction(String vInstruction) throws IndexOutOfBoundsException {
        this._instructionList.add(vInstruction);
    }

    public void addInstruction(int index, String vInstruction) throws IndexOutOfBoundsException {
        this._instructionList.add(index, vInstruction);
    }

    public void deletePersonalSensitive() {
        this._has_personalSensitive = false;
    }

    public Enumeration enumerateAddresses() {
        return Collections.enumeration(this._addressList);
    }

    public Enumeration enumerateCoResponsibleEmployees() {
        return Collections.enumeration(this._coResponsibleEmployeeList);
    }

    public Enumeration enumerateInstructions() {
        return Collections.enumeration(this._instructionList);
    }

    public AddressType getAddress(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._addressList.size()) {
            throw new IndexOutOfBoundsException("getAddress: Index value '" + index + "' not in range [0.." + (this._addressList.size() - 1) + "]");
        }
        return (AddressType)this._addressList.get(index);
    }

    public AddressType[] getAddresses() {
        AddressType[] array = new AddressType[]{};
        return this._addressList.toArray(array);
    }

    public List getAddressesAsReference() {
        return this._addressList;
    }

    public int getAddressesCount() {
        return this._addressList.size();
    }

    public String getArchiveNumber() {
        return this._archiveNumber;
    }

    public String getCaseNumber() {
        return this._caseNumber;
    }

    public CaseTemplateRefType getCaseTemplate() {
        return this._caseTemplate;
    }

    public CategoryRefType getCategory() {
        return this._category;
    }

    public String getClientType() {
        return this._clientType;
    }

    public UserRefType getCoResponsibleEmployee(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._coResponsibleEmployeeList.size()) {
            throw new IndexOutOfBoundsException("getCoResponsibleEmployee: Index value '" + index + "' not in range [0.." + (this._coResponsibleEmployeeList.size() - 1) + "]");
        }
        return (UserRefType)this._coResponsibleEmployeeList.get(index);
    }

    public UserRefType[] getCoResponsibleEmployees() {
        UserRefType[] array = new UserRefType[]{};
        return this._coResponsibleEmployeeList.toArray(array);
    }

    public List getCoResponsibleEmployeesAsReference() {
        return this._coResponsibleEmployeeList;
    }

    public int getCoResponsibleEmployeesCount() {
        return this._coResponsibleEmployeeList.size();
    }

    public String getContactName() {
        return this._contactName;
    }

    public FileplanRefType getFilePlanLocation() {
        return this._filePlanLocation;
    }

    public FormDocumentTemplateRefType getFormTemplate() {
        return this._formTemplate;
    }

    public String getInstruction(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._instructionList.size()) {
            throw new IndexOutOfBoundsException("getInstruction: Index value '" + index + "' not in range [0.." + (this._instructionList.size() - 1) + "]");
        }
        return (String)this._instructionList.get(index);
    }

    public String[] getInstructions() {
        String[] array = new String[]{};
        return this._instructionList.toArray(array);
    }

    public List getInstructionsAsReference() {
        return this._instructionList;
    }

    public int getInstructionsCount() {
        return this._instructionList.size();
    }

    public ClientBaseRefType getInvolvedParty() {
        return this._involvedParty;
    }

    public boolean getPersonalSensitive() {
        return this._personalSensitive;
    }

    public ListValueRefType getPriority() {
        return this._priority;
    }

    public boolean hasPersonalSensitive() {
        return this._has_personalSensitive;
    }

    public boolean isPersonalSensitive() {
        return this._personalSensitive;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateAddresses() {
        return this._addressList.iterator();
    }

    public Iterator iterateCoResponsibleEmployees() {
        return this._coResponsibleEmployeeList.iterator();
    }

    public Iterator iterateInstructions() {
        return this._instructionList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean removeAddress(AddressType vAddress) {
        boolean removed = this._addressList.remove(vAddress);
        return removed;
    }

    public AddressType removeAddressAt(int index) {
        Object obj = this._addressList.remove(index);
        return (AddressType)obj;
    }

    public void removeAllAddresses() {
        this._addressList.clear();
    }

    public void removeAllCoResponsibleEmployees() {
        this._coResponsibleEmployeeList.clear();
    }

    public void removeAllInstructions() {
        this._instructionList.clear();
    }

    public boolean removeCoResponsibleEmployee(UserRefType vCoResponsibleEmployee) {
        boolean removed = this._coResponsibleEmployeeList.remove(vCoResponsibleEmployee);
        return removed;
    }

    public UserRefType removeCoResponsibleEmployeeAt(int index) {
        Object obj = this._coResponsibleEmployeeList.remove(index);
        return (UserRefType)obj;
    }

    public boolean removeInstruction(String vInstruction) {
        boolean removed = this._instructionList.remove(vInstruction);
        return removed;
    }

    public String removeInstructionAt(int index) {
        Object obj = this._instructionList.remove(index);
        return (String)obj;
    }

    public void setAddress(int index, AddressType vAddress) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._addressList.size()) {
            throw new IndexOutOfBoundsException("setAddress: Index value '" + index + "' not in range [0.." + (this._addressList.size() - 1) + "]");
        }
        this._addressList.set(index, vAddress);
    }

    public void setAddresses(AddressType[] vAddressArray) {
        this._addressList.clear();
        for (int i = 0; i < vAddressArray.length; ++i) {
            this._addressList.add(vAddressArray[i]);
        }
    }

    public void setAddresses(List vAddressList) {
        this._addressList.clear();
        this._addressList.addAll(vAddressList);
    }

    public void setAddressesAsReference(List addressList) {
        this._addressList = addressList;
    }

    public void setArchiveNumber(String archiveNumber) {
        this._archiveNumber = archiveNumber;
    }

    public void setCaseNumber(String caseNumber) {
        this._caseNumber = caseNumber;
    }

    public void setCaseTemplate(CaseTemplateRefType caseTemplate) {
        this._caseTemplate = caseTemplate;
    }

    public void setCategory(CategoryRefType category) {
        this._category = category;
    }

    public void setClientType(String clientType) {
        this._clientType = clientType;
    }

    public void setCoResponsibleEmployee(int index, UserRefType vCoResponsibleEmployee) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._coResponsibleEmployeeList.size()) {
            throw new IndexOutOfBoundsException("setCoResponsibleEmployee: Index value '" + index + "' not in range [0.." + (this._coResponsibleEmployeeList.size() - 1) + "]");
        }
        this._coResponsibleEmployeeList.set(index, vCoResponsibleEmployee);
    }

    public void setCoResponsibleEmployees(UserRefType[] vCoResponsibleEmployeeArray) {
        this._coResponsibleEmployeeList.clear();
        for (int i = 0; i < vCoResponsibleEmployeeArray.length; ++i) {
            this._coResponsibleEmployeeList.add(vCoResponsibleEmployeeArray[i]);
        }
    }

    public void setCoResponsibleEmployees(List vCoResponsibleEmployeeList) {
        this._coResponsibleEmployeeList.clear();
        this._coResponsibleEmployeeList.addAll(vCoResponsibleEmployeeList);
    }

    public void setCoResponsibleEmployeesAsReference(List coResponsibleEmployeeList) {
        this._coResponsibleEmployeeList = coResponsibleEmployeeList;
    }

    public void setContactName(String contactName) {
        this._contactName = contactName;
    }

    public void setFilePlanLocation(FileplanRefType filePlanLocation) {
        this._filePlanLocation = filePlanLocation;
    }

    public void setFormTemplate(FormDocumentTemplateRefType formTemplate) {
        this._formTemplate = formTemplate;
    }

    public void setInstruction(int index, String vInstruction) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._instructionList.size()) {
            throw new IndexOutOfBoundsException("setInstruction: Index value '" + index + "' not in range [0.." + (this._instructionList.size() - 1) + "]");
        }
        this._instructionList.set(index, vInstruction);
    }

    public void setInstructions(String[] vInstructionArray) {
        this._instructionList.clear();
        for (int i = 0; i < vInstructionArray.length; ++i) {
            this._instructionList.add(vInstructionArray[i]);
        }
    }

    public void setInstructions(List vInstructionList) {
        this._instructionList.clear();
        this._instructionList.addAll(vInstructionList);
    }

    public void setInstructionsAsReference(List instructionList) {
        this._instructionList = instructionList;
    }

    public void setInvolvedParty(ClientBaseRefType involvedParty) {
        this._involvedParty = involvedParty;
    }

    public void setPersonalSensitive(boolean personalSensitive) {
        this._personalSensitive = personalSensitive;
        this._has_personalSensitive = true;
    }

    public void setPriority(ListValueRefType priority) {
        this._priority = priority;
    }

    public static ReferenceableObjectType unmarshalCaseType(Reader reader) throws MarshalException, ValidationException {
        return (ReferenceableObjectType)Unmarshaller.unmarshal(CaseType.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

