/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.codegenerators;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import net.gopro.codegenerators.BaseGenerator;
import net.gopro.gdf.data.DataSetColumnType;
import net.gopro.services.util.DataObjectAnalyzer;

public class FilterPropertiesGenerator
extends BaseGenerator {
    private static String baseDir = "C:/Projects/Workspace/TenzingV2Services";
    private String dataObjectsPack = "net.gopro.gdf.data";
    private String baseDocClass = "net.gopro.gdf.data.ReferenceableObjectType";
    private String outputDir = baseDir + "/gen-src";
    private String classTemplate = baseDir + "/src/net/gopro/codegenerators/templates/FilterProperties.txt";
    private String outputClass = "net.gopro.gdf.data.constants.FilterProperties";
    private String unzippedGDFProject;
    private StringBuffer generatedCode = new StringBuffer();
    private Hashtable propertyPathMap;

    public static void main(String[] args) {
        try {
            FilterPropertiesGenerator generator = new FilterPropertiesGenerator(args);
            generator.generate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private FilterPropertiesGenerator(String[] args) throws Exception {
        super(args);
    }

    public void generate() throws Exception {
        this.dataObjectsPack = this.getParameter("dataObjectsPack", this.dataObjectsPack);
        this.baseDocClass = this.getParameter("baseDocClass", this.baseDocClass);
        this.outputDir = this.getParameter("outputDir", this.outputDir);
        this.classTemplate = this.getParameter("classTemplate", this.classTemplate);
        this.outputClass = this.getParameter("outputClass", this.outputClass);
        this.unzippedGDFProject = this.getParameter("unzippedGDFProject", null);
        this.propertyPathMap = new Hashtable();
        this.generateCode();
        this.generateFile();
    }

    private void generateFile() throws Exception {
        HashMap<String, String> subParams = new HashMap<String, String>();
        String outputFilePath = this.outputDir + "/" + this.convertClassNameToPath(this.outputClass) + ".java";
        String packageName = this.getPackageByClassName(this.outputClass);
        String classBaseName = this.getClassBaseName(this.outputClass);
        this.ensureDirCreated(outputFilePath);
        StringBuffer outputBuffer = this.readFile(new File(this.classTemplate));
        subParams.putAll(this.generatorParams);
        subParams.put("package", packageName);
        subParams.put("classBaseName", classBaseName);
        this.substituteContentParams(outputBuffer, subParams);
        this.replaceInContent(outputBuffer, this.generatedCode, "/*--BEGIN:GOPRO_GENERATED--*/", "/*--END:GOPRO_GENERATED--*/");
        this.writeCode(new File(outputFilePath), outputBuffer);
    }

    private void generateCode() throws Exception {
        Class<?> baseDocumentClass = Class.forName(this.baseDocClass);
        File classesDir = new File(this.unzippedGDFProject);
        boolean located = false;
        if (classesDir.exists()) {
            located = true;
            ArrayList<File> resultFiles = new ArrayList<File>();
            String fullPath = this.dataObjectsPack.replace(".", "/");
            this.getFiles(resultFiles, classesDir.listFiles(), fullPath);
            if (resultFiles.size() > 0) {
                File[] files = ((File)resultFiles.get(0)).listFiles();
                for (int ac = 0; ac < files.length; ++ac) {
                    String fileName = files[ac].getName();
                    if (!fileName.endsWith("Type.class")) continue;
                    try {
                        Class<?> dataClass = Class.forName(this.dataObjectsPack + '.' + fileName.substring(0, fileName.length() - 6));
                        if (!baseDocumentClass.isAssignableFrom(dataClass)) continue;
                        this.generatePropsEntry(dataClass);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        System.err.println(this.getClass().getSimpleName() + ": Class not found exception: " + this.dataObjectsPack + '.' + fileName.substring(0, fileName.length() - 6));
                    }
                }
            }
        }
        if (!located) {
            throw new ClassNotFoundException(this.dataObjectsPack + " (" + classesDir.getPath() + ") is not a valid package");
        }
    }

    private void generatePropsEntry(Class docClass) {
        String strippedName = docClass.getName();
        strippedName = strippedName.substring(strippedName.lastIndexOf(46) + 1);
        strippedName = strippedName.substring(0, strippedName.length() - 4);
        List props = DataObjectAnalyzer.collectClassProperties(docClass);
        this.generatedCode.append("\tpublic static final class " + strippedName + "\n");
        this.generatedCode.append("\t{\n");
        for (int ac = 0; ac < props.size(); ++ac) {
            DataSetColumnType dsColumn = (DataSetColumnType)props.get(ac);
            this.generatedCode.append("\t\tpublic static final String ");
            this.generatedCode.append(dsColumn.getName() + " = \"");
            this.generatedCode.append(dsColumn.getMappedObjectName() + "\";\n");
        }
        this.generatedCode.append("\t}\n\n");
    }

    private String getNormalizedPropertyPath(String propPath) {
        propPath = propPath.replaceAll("_", "").toLowerCase();
        propPath = propPath.replaceAll("\\[[_a-z]*\\]", "");
        return propPath;
    }
}

