/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.codegenerators;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.gopro.codegenerators.BaseGenerator;
import net.gopro.codegenerators.MethodMetaData;
import net.gopro.codegenerators.ProxyGenerateContext;
import net.gopro.util.annotations.GoProAnnotationHelper;
import net.gopro.util.annotations.GoProAnnotationInfo;
import net.gopro.util.annotations.GoProCommentAnnotation;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class BaseProxyGenerator
extends BaseGenerator {
    protected String proxyHelperClass;
    protected String srcDir;
    protected String outputDir;
    protected String classTemplate;
    protected String outputPack;
    protected boolean useAnnotations = false;
    protected boolean usedAnnotations = false;
    protected Vector services = new Vector();
    private Project project;
    private StringBuffer generatedCode;

    public void setProject(Project proj) {
        this.project = proj;
    }

    public void execute() {
        try {
            this.generate();
            if (!this.usedAnnotations) {
                System.out.println("!!!\n!!! Annotations were not used at all! \n");
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected void generate() throws Exception {
        throw new RuntimeException("The method generate should be implemented.The implementors should create a set of genContext and iterate on generateProxy");
    }

    protected void generateProxy(ProxyGenerateContext genContext) throws Exception {
        this.generateProxyCode(genContext);
        this.writeProxyCode(genContext);
    }

    protected void writeProxyCode(ProxyGenerateContext genContext) throws Exception {
        String className = this.getClassBaseName(genContext.protoClassName);
        Class<?> protoClass = Class.forName(genContext.protoClassName);
        if (protoClass.isInterface() && className.startsWith("I")) {
            className = className.substring(1);
        }
        className = className + "Proxy";
        this.writeProxyFile(className, this.classTemplate, genContext);
    }

    protected void writeProxyFile(String className, String classTemplate, ProxyGenerateContext genContext) throws Exception {
        HashMap<String, String> subParams = new HashMap<String, String>();
        System.out.println("Generate proxy service " + className);
        String outputFilePath = genContext.outputDir + "/" + this.convertClassNameToPath(genContext.outputPack) + "/" + className + ".java";
        this.ensureDirCreated(outputFilePath);
        File outputFile = new File(outputFilePath);
        if (outputFile.exists() && !genContext.overrideExisting) {
            System.out.println("Already existing file. Override passed: " + outputFilePath + " ");
            return;
        }
        StringBuffer outputBuffer = this.readFile(new File(classTemplate));
        subParams.putAll(this.generatorParams);
        subParams.putAll(genContext.substitueParams);
        subParams.put("extendsClause", "");
        subParams.put("implementsClause", "");
        subParams.put("package", genContext.outputPack);
        subParams.put("className", className);
        this.addClassComments(genContext, subParams);
        if (genContext.baseClass != null) {
            subParams.put("extendsClause", "extends " + genContext.baseClass);
        }
        subParams.put("imports", genContext.importsOutputBuffer.toString());
        if (genContext.interfaces != null) {
            subParams.put("implementsClause", "implements " + genContext.interfaces);
            subParams.put("interfaces", genContext.interfaces);
        }
        this.substituteContentParams(outputBuffer, subParams);
        this.replaceInContent(outputBuffer, genContext.outputBuffer, "/*--BEGIN:GOPRO_GENERATED--*/", "/*--END:GOPRO_GENERATED--*/");
        this.writeCode(outputFile, outputBuffer);
    }

    private void addClassComments(ProxyGenerateContext genContext, HashMap subParams) {
        subParams.put("classcomment", "");
        if (!this.useAnnotations) {
            return;
        }
        GoProAnnotationInfo classAnnotationInfo = null;
        try {
            Class<?> c = Class.forName(genContext.protoClassName);
            if (c != null) {
                classAnnotationInfo = GoProAnnotationHelper.getAnnotationInfo(c, true);
            }
        }
        catch (Throwable c) {
            // empty catch block
        }
        if (classAnnotationInfo != null) {
            this.usedAnnotations = true;
            List classOnlyAnnotations = classAnnotationInfo.getClassOnlyAnnotations();
            for (int i = 0; i < classOnlyAnnotations.size(); ++i) {
                GoProCommentAnnotation annotation = null;
                if (classOnlyAnnotations.get(i) instanceof GoProCommentAnnotation) {
                    annotation = (GoProCommentAnnotation)classOnlyAnnotations.get(i);
                }
                if (annotation != null) {
                    subParams.put("classcomment", "/**\n * " + annotation.getComment() + "\n */");
                    continue;
                }
                if (subParams.containsKey("classcomment")) continue;
                subParams.put("classcomment", "");
            }
        } else {
            subParams.put("classcomment", "");
        }
    }

    protected void generateProxyCode(ProxyGenerateContext genContext) throws Exception {
        StringBuffer outputBuffer = new StringBuffer();
        String[] srcDirList = this.srcDir.split(";");
        String extension = ".class";
        for (int ac = 0; ac < srcDirList.length; ++ac) {
            File srcFile = new File(srcDirList[ac] + "/" + this.convertClassNameToPath(genContext.protoClassName) + extension);
            if (!srcFile.exists()) {
                if (ac != srcDirList.length - 1) continue;
                throw new FileNotFoundException("Source file '" + srcFile + "' not found");
            }
            genContext.inputSrcCode = this.readFile(srcFile);
            break;
        }
        this.generateCommonCode(genContext);
        List methods = this.resolveProxyMethods(genContext);
        for (int ac = 0; ac < methods.size(); ++ac) {
            Method method = (Method)methods.get(ac);
            this.generateProxyMethod(method, genContext);
        }
        Enumeration importKeys = genContext.imports.keys();
        while (importKeys.hasMoreElements()) {
            String importClass = (String)importKeys.nextElement();
            genContext.importsOutputBuffer.append("import ");
            genContext.importsOutputBuffer.append(importClass);
            genContext.importsOutputBuffer.append(";\n");
        }
    }

    protected List resolveProxyMethods(ProxyGenerateContext genContext) throws Exception {
        ArrayList<Method> methodsList = new ArrayList<Method>();
        Class<?> serviceClass = Class.forName(genContext.protoClassName);
        Method[] methods = serviceClass.getDeclaredMethods();
        for (int ac = 0; ac < methods.length; ++ac) {
            methodsList.add(methods[ac]);
        }
        return methodsList;
    }

    protected void generateCommonCode(ProxyGenerateContext genContext) throws Exception {
        String serviceImplClass = this.extractClassType(Class.forName(genContext.protoClassName), genContext);
    }

    protected void generateProxyMethod(Method method, ProxyGenerateContext genContext) throws Exception {
        this.generateProxyMethodHeader(method, genContext);
        this.generateProxyMethodBody(method, genContext);
        genContext.outputBuffer.append("\n");
    }

    protected void generateProxyMethodHeader(Method method, ProxyGenerateContext genContext) throws Exception {
        this.buildMehodHeaderCode(method.getName(), "public", method.getReturnType(), method.getParameterTypes(), method.getExceptionTypes(), null, genContext);
    }

    protected void generateProxyMethodBody(Method method, ProxyGenerateContext genContext) throws Exception {
        genContext.outputBuffer.append("\n\t{\n");
        if (!method.getReturnType().equals(Void.TYPE)) {
            String retValue = "null";
            Class<?> returnType = method.getReturnType();
            if (returnType.isPrimitive()) {
                if (returnType.equals(Boolean.TYPE)) {
                    retValue = "false";
                }
                if (returnType.equals(Integer.TYPE)) {
                    retValue = "0";
                }
                if (returnType.equals(Long.TYPE)) {
                    retValue = "0";
                }
                if (returnType.equals(Float.TYPE)) {
                    retValue = "0";
                }
                if (returnType.equals(Double.TYPE)) {
                    retValue = "0";
                }
                if (returnType.equals(Byte.TYPE)) {
                    retValue = "0";
                }
                if (returnType.equals(Character.TYPE)) {
                    retValue = "'0'";
                }
            }
            genContext.outputBuffer.append("\t\treturn " + retValue + ";\n");
        }
        genContext.outputBuffer.append("\t}\n");
    }

    protected void buildMehodHeaderCode(String methodName, String accessModifier, Class returnType, Class[] parameters, Class[] exceptions, MethodMetaData methodMeta, ProxyGenerateContext genContext) {
        Class parameter;
        int ac;
        genContext.outputBuffer.append("\tpublic");
        if (returnType != null) {
            genContext.outputBuffer.append(" " + this.extractClassType(returnType, genContext));
        } else {
            genContext.outputBuffer.append(" void");
        }
        genContext.outputBuffer.append(" " + methodName);
        genContext.outputBuffer.append("(");
        for (ac = 0; ac < parameters.length; ++ac) {
            parameter = parameters[ac];
            String paramType = this.extractClassType(parameter, genContext);
            genContext.outputBuffer.append(paramType + " arg" + ac);
            if (ac >= parameters.length - 1) continue;
            genContext.outputBuffer.append(", ");
        }
        genContext.outputBuffer.append(")");
        if (exceptions.length > 0) {
            genContext.outputBuffer.append(" throws ");
        }
        for (ac = 0; ac < exceptions.length; ++ac) {
            parameter = exceptions[ac];
            genContext.outputBuffer.append(this.extractClassType(parameter, genContext));
            if (ac >= exceptions.length - 1) continue;
            genContext.outputBuffer.append(", ");
        }
    }

    protected Class getBaseElementClass(Class classObj) {
        if (classObj.getComponentType() != null) {
            return classObj.getComponentType();
        }
        return classObj;
    }

    protected String extractClassType(Class classObj, ProxyGenerateContext genContext) {
        if (classObj.getComponentType() != null) {
            String className = classObj.getComponentType().getName();
            if (!classObj.getComponentType().isPrimitive() && !this.getPackageByClassName(className).equals("java.lang")) {
                genContext.imports.put(className, Boolean.TRUE);
            }
            return this.getClassBaseName(className) + "[]";
        }
        String className = classObj.getName();
        if (classObj.isPrimitive()) {
            return className;
        }
        if (!this.getPackageByClassName(className).equals("java.lang")) {
            genContext.imports.put(className, Boolean.TRUE);
        }
        return this.getClassBaseName(className);
    }

    protected String extractClassType(Class classObj) {
        if (classObj.getComponentType() != null) {
            String className = classObj.getComponentType().getName();
            return this.getClassBaseName(className) + "[]";
        }
        String className = classObj.getName();
        if (classObj.isPrimitive()) {
            return className;
        }
        return this.getClassBaseName(className);
    }

    protected MethodMetaData parseMethodCode(Method method, ProxyGenerateContext genContext) throws Exception {
        MethodMetaData code = new MethodMetaData();
        Class<?>[] parameters = method.getParameterTypes();
        String[] headerTypes = new String[parameters.length];
        for (int ac = 0; ac < parameters.length; ++ac) {
            Class<?> parameter = parameters[ac];
            headerTypes[ac] = this.extractClassType(parameter, genContext);
        }
        String pattern = method.getName() + "\\s*\\(([^;\\{]*)\\)";
        Pattern p = Pattern.compile(pattern, 40);
        Matcher m = p.matcher(genContext.inputSrcCode);
        code.params = "";
        if (m.find()) {
            code.params = m.group(1);
        }
        if (m.find()) {
            code.params = "";
            for (int ac = 0; ac < headerTypes.length; ++ac) {
                code.params = code.params + headerTypes[ac] + " arg" + ac;
                if (ac >= headerTypes.length - 1) continue;
                code.params = code.params + ", ";
            }
        } else {
            pattern = "(/\\*\\*.*?\\*/){1}+[\\w\\s\\[\\]]*" + method.getName() + "\\s*\\(";
            p = Pattern.compile(pattern, 40);
            m = p.matcher(genContext.inputSrcCode);
            if (m.find()) {
                code.comments = m.group(1);
            }
        }
        return code;
    }

    public void setProxyHelperClass(String baseProxyClass) {
        this.proxyHelperClass = baseProxyClass;
    }

    public void setSrcDir(String srcDir) {
        this.srcDir = srcDir;
    }
}

