/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.util.json;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.lang.SystemUtils;

class PackageHelper {
    PackageHelper() {
    }

    public static Class[] getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<String> locations = new ArrayList<String>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            locations.add(resource.getFile());
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        for (String location : locations) {
            PackageHelper.findClasses(location, packageName, path, classes);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    public static Class[] getSiblingClasses(Class protoClass) throws ClassNotFoundException, IOException {
        ArrayList<Class> classes = new ArrayList<Class>();
        String packageName = protoClass.getPackage().getName();
        String location = null;
        try {
            location = protoClass.getProtectionDomain().getCodeSource().getLocation().getPath();
            location = URLDecoder.decode(location, "UTF-8");
            if (location.indexOf(".class") >= 0) {
                location = new File(location).getParent();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String packagePath = packageName.replace('.', '/');
        PackageHelper.findClasses(location, packageName, packagePath, classes);
        return classes.toArray(new Class[classes.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findClasses(String location, String packageName, String packagePath, List<Class> classesStore) throws ClassNotFoundException, IOException {
        File jarLocationFolder = new File(location);
        File fileLocationFolder = new File(location + packagePath);
        if (!jarLocationFolder.exists() || !jarLocationFolder.isDirectory()) {
            int jarExtIndex = location.indexOf(".jar");
            if (jarExtIndex >= 0) {
                String jarLocation = location.substring(0, jarExtIndex + 4);
                if (location.startsWith("file:/") || location.startsWith("file:\\")) {
                    jarLocation = jarLocation.substring(6);
                }
                if (!SystemUtils.IS_OS_WINDOWS && !location.startsWith("/")) {
                    jarLocation = "/" + jarLocation;
                }
                File jarFile = new File(jarLocation);
                JarInputStream jarInputStream = new JarInputStream(new FileInputStream(jarFile));
                try {
                    JarEntry entry;
                    while ((entry = jarInputStream.getNextJarEntry()) != null) {
                        String entryName = entry.getName();
                        if (!entryName.startsWith(packagePath) || !entryName.endsWith(".class")) continue;
                        String className = entryName.replace('/', '.').substring(0, entryName.length() - 6);
                        classesStore.add(Class.forName(className));
                    }
                }
                finally {
                    try {
                        jarInputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return;
        }
        PackageHelper.findClassesInFolder(fileLocationFolder, packageName, classesStore);
    }

    private static void findClassesInFolder(File locationFolder, String packageName, List<Class> classesStore) throws ClassNotFoundException {
        File[] files;
        for (File file : files = locationFolder.listFiles()) {
            if (file.isDirectory() && file.getName().indexOf(46) < 0) {
                PackageHelper.findClassesInFolder(file, packageName + "." + file.getName(), classesStore);
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String className = packageName + '.' + file.getName().substring(0, file.getName().length() - 6);
            classesStore.add(Class.forName(className));
        }
    }
}

