/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.util.json;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import net.gopro.gdf.data.CaseType;
import net.gopro.gdf.data.DocumentBaseType;
import net.gopro.gdf.data.DocumentCollectionType;
import net.gopro.gdf.data.ExternalDocumentTemplateRefType;
import net.gopro.gdf.data.ExternalDocumentTemplateType;
import net.gopro.gdf.data.ExternalDocumentVersionRefType;
import net.gopro.gdf.data.ObjectBaseType;
import net.gopro.gdf.data.types.ACLUserType;
import net.gopro.util.json.CustomEnumDeSerializer;
import net.gopro.util.json.CustomEnumSerializer;
import net.gopro.util.json.JacksonTyping;
import net.gopro.util.json.PackageHelper;
import net.gopro.util.json.VisibilityController;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.introspect.VisibilityChecker;
import org.codehaus.jackson.map.module.SimpleModule;

public class JsonSerializer {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JsonSerializer() {
        this.constructObjectMapper();
    }

    public String serialize(Object object) {
        StringWriter currentStateData = new StringWriter();
        this.patchSerializedObject(object);
        try {
            this.objectMapper.writeValue((Writer)currentStateData, object);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return currentStateData.toString();
    }

    protected void patchSerializedObject(Object object) {
        block3: {
            block2: {
                if (!(object instanceof DocumentCollectionType)) break block2;
                for (DocumentBaseType doc : ((DocumentCollectionType)object).getDocuments()) {
                    this.patchSerializedObject(doc);
                }
                break block3;
            }
            if (!(object instanceof ExternalDocumentTemplateType)) break block3;
            ExternalDocumentTemplateType template = (ExternalDocumentTemplateType)object;
            List l = template.getVersionsAsReference();
            for (int i = 0; i < l.size(); ++i) {
                Object versionObject = l.get(i);
                if (!(versionObject instanceof ExternalDocumentVersionRefType)) continue;
                ExternalDocumentVersionRefType versionRef = (ExternalDocumentVersionRefType)versionObject;
                ExternalDocumentTemplateRefType templateRef = new ExternalDocumentTemplateRefType();
                templateRef.setID(versionRef.getID());
                templateRef.setName(versionRef.getName());
                l.set(i, templateRef);
            }
        }
    }

    protected Object patchDeserializedObject(Object object) {
        if (object instanceof DocumentCollectionType) {
            for (DocumentBaseType doc : ((DocumentCollectionType)object).getDocuments()) {
                this.patchDeserializedObject(doc);
            }
        }
        return object;
    }

    public <T> T deserialize(String jsonString, Class<T> objectClass) {
        try {
            return (T)this.patchDeserializedObject(this.objectMapper.readValue((Reader)new StringReader(jsonString), objectClass));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void constructObjectMapper() {
        this.objectMapper.setVisibilityChecker((VisibilityChecker)new VisibilityController(JsonAutoDetect.Visibility.ANY, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.ANY, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE));
        this.objectMapper.configure(SerializationConfig.Feature.AUTO_DETECT_IS_GETTERS, true);
        this.objectMapper.configure(SerializationConfig.Feature.AUTO_DETECT_GETTERS, true);
        this.objectMapper.configure(SerializationConfig.Feature.AUTO_DETECT_FIELDS, false);
        this.objectMapper.configure(SerializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS, true);
        this.objectMapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, false);
        this.objectMapper.configure(SerializationConfig.Feature.USE_ANNOTATIONS, true);
        this.objectMapper.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, false);
        try {
            this.objectMapper.registerSubtypes(PackageHelper.getSiblingClasses(CaseType.class));
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not register sub types classes!", ex);
        }
        this.objectMapper.enableDefaultTyping();
        this.objectMapper.enableDefaultTyping(ObjectMapper.DefaultTyping.OBJECT_AND_NON_CONCRETE, JsonTypeInfo.As.PROPERTY);
        this.objectMapper.getSerializationConfig().addMixInAnnotations(ObjectBaseType.class, JacksonTyping.class);
        this.objectMapper.getDeserializationConfig().addMixInAnnotations(ObjectBaseType.class, JacksonTyping.class);
        this.objectMapper.configure(DeserializationConfig.Feature.AUTO_DETECT_SETTERS, true);
        this.objectMapper.configure(DeserializationConfig.Feature.AUTO_DETECT_FIELDS, false);
        this.objectMapper.configure(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS, true);
        this.objectMapper.configure(DeserializationConfig.Feature.AUTO_DETECT_CREATORS, true);
        this.objectMapper.configure(DeserializationConfig.Feature.USE_ANNOTATIONS, true);
        this.objectMapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            Class[] classes = PackageHelper.getSiblingClasses(ACLUserType.class);
            SimpleModule deserializationModule = new SimpleModule(CustomEnumDeSerializer.class.getSimpleName(), new Version(1, 0, 0, null));
            SimpleModule serializationModule = new SimpleModule(CustomEnumSerializer.class.getSimpleName(), new Version(1, 0, 0, null));
            try {
                for (Class clazz : classes) {
                    deserializationModule.addDeserializer(clazz, new CustomEnumDeSerializer(clazz));
                    serializationModule.addSerializer(clazz, new CustomEnumSerializer());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.objectMapper.registerModule((Module)deserializationModule);
            this.objectMapper.registerModule((Module)serializationModule);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error registering custom Enum deserializers");
        }
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

