/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.util.annotations;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import net.gopro.util.annotations.GoProAnnotation;
import net.gopro.util.annotations.GoProInternalAnnotation;
import net.gopro.util.annotations.GoProInvisibleAnnotation;

public class GoProAnnotationInfo {
    protected ArrayList classOnlyAnnotations;
    protected Hashtable fieldAnnotations = new Hashtable();
    protected Hashtable methodAnnotations = new Hashtable();
    protected Class annotatedClass;

    public GoProAnnotationInfo() {
        this.classOnlyAnnotations = new ArrayList();
    }

    public Class getAnnotatedClass() {
        return this.annotatedClass;
    }

    protected void setAnnotatedClass(Class annotatedClass) {
        this.annotatedClass = annotatedClass;
    }

    protected void addFieldAnnotation(String name, GoProAnnotation annotation) {
        if (this.fieldAnnotations.containsKey(name)) {
            List memberList = (List)this.fieldAnnotations.get(name);
            memberList.add(annotation);
        } else {
            ArrayList<GoProAnnotation> memberList = new ArrayList<GoProAnnotation>();
            memberList.add(annotation);
            this.fieldAnnotations.put(name, memberList);
        }
    }

    public List getFieldAnnotations(String name) {
        if (this.fieldAnnotations.containsKey(name)) {
            List fieldAnnotationsList = (List)this.fieldAnnotations.get(name);
            return fieldAnnotationsList;
        }
        return null;
    }

    protected void addMethodAnnotation(String name, GoProAnnotation annotation) {
        if (this.methodAnnotations.containsKey(name)) {
            List memberList = (List)this.methodAnnotations.get(name);
            memberList.add(annotation);
        } else {
            ArrayList<GoProAnnotation> memberList = new ArrayList<GoProAnnotation>();
            memberList.add(annotation);
            this.methodAnnotations.put(name, memberList);
        }
    }

    public List getMethodAnnotations(String name) {
        if (this.methodAnnotations.containsKey(name)) {
            List methodAnnotationsList = (List)this.methodAnnotations.get(name);
            return methodAnnotationsList;
        }
        return null;
    }

    public boolean hasFieldAnnotation(String fieldName, Class annotationClass) {
        List fieldAnnotationsList = (List)this.fieldAnnotations.get(fieldName);
        if (fieldAnnotationsList != null) {
            for (int count = 0; count < fieldAnnotationsList.size(); ++count) {
                if (!annotationClass.isInstance(fieldAnnotationsList.get(count))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean getInvisibleFieldAnnotation(String name) {
        if (this.fieldAnnotations.containsKey(name)) {
            List fieldAnnotationsList = (List)this.fieldAnnotations.get(name);
            for (int count = 0; count < fieldAnnotationsList.size(); ++count) {
                if (!GoProInvisibleAnnotation.class.isInstance(fieldAnnotationsList.get(count))) continue;
                GoProInvisibleAnnotation invisibleAnnotation = (GoProInvisibleAnnotation)fieldAnnotationsList.get(count);
                return invisibleAnnotation.getInvisible();
            }
        }
        return false;
    }

    public boolean getInternalFieldAnnotation(String name) {
        if (this.fieldAnnotations.containsKey(name)) {
            List fieldAnnotationsList = (List)this.fieldAnnotations.get(name);
            for (int count = 0; count < fieldAnnotationsList.size(); ++count) {
                if (!GoProInternalAnnotation.class.isInstance(fieldAnnotationsList.get(count))) continue;
                GoProInternalAnnotation internalAnnotation = (GoProInternalAnnotation)fieldAnnotationsList.get(count);
                return internalAnnotation.getInternal();
            }
        }
        return false;
    }

    protected List getAnnotations(Member member) {
        String memberName = member.getName();
        if (member instanceof Field) {
            if (this.fieldAnnotations.containsKey(memberName)) {
                return (List)this.fieldAnnotations.get(memberName);
            }
        } else if (member instanceof Method && this.methodAnnotations.containsKey(memberName)) {
            return (List)this.methodAnnotations.get(memberName);
        }
        return null;
    }

    protected GoProAnnotation getAnnotations(Member member, Class annotationType) {
        block4: {
            String memberName;
            block3: {
                memberName = member.getName();
                if (!(member instanceof Field)) break block3;
                if (!this.fieldAnnotations.containsKey(memberName)) break block4;
                List annotations = (List)this.fieldAnnotations.get(memberName);
                for (int count = 0; count < annotations.size(); ++count) {
                    if (!annotationType.equals(annotations.get(count).getClass())) continue;
                    return (GoProAnnotation)annotations.get(count);
                }
                break block4;
            }
            if (member instanceof Method && this.methodAnnotations.containsKey(memberName)) {
                List annotations = (List)this.methodAnnotations.get(memberName);
                for (int count = 0; count < annotations.size(); ++count) {
                    if (!annotationType.equals(annotations.get(count).getClass())) continue;
                    return (GoProAnnotation)annotations.get(count);
                }
            }
        }
        return null;
    }

    protected void addClassOnlyAnnotation(GoProAnnotation annotation) {
        if (!this.classOnlyAnnotations.contains(annotation) && annotation != null) {
            this.classOnlyAnnotations.add(annotation);
        }
    }

    public List getClassOnlyAnnotations() {
        return this.classOnlyAnnotations;
    }

    public GoProAnnotation getClassAnnotations(Class annotationType) {
        for (int count = 0; count < this.classOnlyAnnotations.size(); ++count) {
            if (!annotationType.equals(this.classOnlyAnnotations.get(count).getClass())) continue;
            return (GoProAnnotation)this.classOnlyAnnotations.get(count);
        }
        return null;
    }
}

