/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.util.annotations;

import java.util.HashMap;
import net.gopro.util.annotations.GoProAnnotationInfo;

public class GoProAnnotationHelper {
    private static HashMap annotationsCache = new HashMap();

    public static GoProAnnotationInfo getAnnotationInfo(Class gdfDataClass) {
        return GoProAnnotationHelper.getAnnotationInfo(gdfDataClass, false);
    }

    public static GoProAnnotationInfo getAnnotationInfo(Class gdfDataClass, boolean supressExceptions) {
        String className = gdfDataClass.getName();
        String name = className.substring(className.lastIndexOf("."));
        if (annotationsCache.containsKey(name)) {
            return (GoProAnnotationInfo)annotationsCache.get(name);
        }
        String corrClassName = "net.gopro.gdf.data.annotations".concat(name);
        try {
            Class<?> annotClass = Class.forName(corrClassName);
            GoProAnnotationInfo annotInfo = (GoProAnnotationInfo)annotClass.newInstance();
            annotInfo.setAnnotatedClass(gdfDataClass);
            annotationsCache.put(name, annotInfo);
            return annotInfo;
        }
        catch (Exception e) {
            if (!supressExceptions) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

