/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;

public final class Utils {
    private Utils() {
    }

    public static final String getClassBaseName(Class<?> classs) {
        String className = classs.getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        return className;
    }

    public static final void writeToFile(String filename, String data) throws IOException {
        Utils.writeToFile(new File(filename), data, null);
    }

    public static final void writeToFile(String filename, String data, String encoding) throws IOException {
        Utils.writeToFile(new File(filename), data, encoding);
    }

    public static final void writeToFile(File file, String data, String encoding) throws IOException {
        StringReader in = new StringReader(data);
        OutputStreamWriter out = encoding != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding) : new OutputStreamWriter(new FileOutputStream(file));
        Utils.writeStream(in, out);
        ((Writer)out).close();
    }

    public static final void writeStream(InputStream in, OutputStream out) throws IOException {
        Utils.writeStream(in, out, 8192);
    }

    public static final void writeStream(InputStream in, OutputStream out, int bufferSize) throws IOException {
        byte[] b = new byte[bufferSize];
        int totalReadBytes = 0;
        try {
            int count = in.read(b);
            while (count > 0) {
                totalReadBytes += count;
                out.write(b, 0, count);
                count = in.read(b);
            }
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Read " + totalReadBytes + " bytes ", e);
        }
    }

    public static final void writeStream(Reader in, Writer out) throws IOException {
        char[] c = new char[8192];
        int count = in.read(c);
        while (count > 0) {
            out.write(c, 0, count);
            count = in.read(c);
        }
    }

    public static final void writeString(String data, Writer out) throws IOException {
        StringReader in = new StringReader(data);
        char[] c = new char[8192];
        int count = in.read(c);
        while (count > 0) {
            out.write(c, 0, count);
            count = in.read(c);
        }
    }

    public static final void writeFile(File file, OutputStream out) throws IOException {
        FileInputStream in = new FileInputStream(file);
        Utils.writeStream(in, out);
        ((InputStream)in).close();
    }

    public static final File getTempDirectory() {
        File tmp = new File(System.getProperty("java.io.tmpdir"));
        if (!(tmp.exists() || (tmp = new File(File.separatorChar + "temp")).exists() || (tmp = new File(File.separatorChar + "tmp")).exists())) {
            tmp.mkdirs();
        }
        return tmp;
    }

    public static final File getMyTempDirectory(String myFolder) {
        File tmp = Utils.getTempDirectory();
        if (myFolder != null && !"".equals(myFolder) && !(tmp = new File(tmp, myFolder)).exists()) {
            tmp.mkdirs();
        }
        return tmp;
    }

    public static final String join(String[] strings, String t) {
        if (strings != null) {
            StringBuffer result = new StringBuffer();
            for (int ac = 0; ac < strings.length; ++ac) {
                if (result.length() > 0) {
                    result.append(t);
                }
                result.append(strings[ac]);
            }
            return result.toString();
        }
        return null;
    }
}

