/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import net.gopro.gdf.data.Chunk;
import net.gopro.gdf.data.DocumentBaseType;
import net.gopro.gdf.data.DocumentCollectionType;
import net.gopro.gdf.data.EMailType;
import net.gopro.gdf.data.ExternalDocumentVersionType;
import net.gopro.gdf.data.FileAttachmentType;
import net.gopro.gdf.data.IVersionable;
import net.gopro.gdf.data.UserType;
import net.gopro.gdf.exceptions.GdfServiceException;
import net.gopro.util.AttachmentStoreUtil;
import net.gopro.util.CRCUtils;
import net.gopro.util.ChunkSettings;
import net.gopro.util.ChunkingException;
import net.gopro.util.Utils;
import org.apache.commons.lang.math.NumberUtils;

public class ChunkUtil {
    public static final byte[] CHUNKED_ATTACHMENT = "[CHUNKED_ATTACHMENT]".getBytes();
    private String basePath;
    private boolean testingCRC;

    public ChunkUtil(String basePath) {
        if (basePath.indexOf("\\") > -1 && !basePath.endsWith("\\")) {
            basePath = basePath + "\\";
        } else if (basePath.indexOf("/") > -1 && !basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        this.basePath = basePath;
    }

    public ChunkUtil(String basePath, boolean testingCRC) {
        this(basePath);
        this.testingCRC = testingCRC;
    }

    public void deleteTempFile(long tempId) {
        File tmpFile = new File(this.basePath, String.valueOf(tempId));
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
    }

    public long chunkFile(File file, long predefinedTempId) {
        try {
            long checkSum = CRCUtils.createChecksum(file);
            FileInputStream fileIn = new FileInputStream(file);
            if (!this.testingCRC && predefinedTempId != -1L) {
                checkSum = predefinedTempId;
            }
            File tmpFile = new File(this.basePath, String.valueOf(checkSum));
            FileOutputStream fileOut = new FileOutputStream(tmpFile);
            Utils.writeStream(fileIn, fileOut, 16384);
            ((OutputStream)fileOut).close();
            ((InputStream)fileIn).close();
            return checkSum;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long chunkStream(InputStream stream, long predefinedTempId) throws IOException {
        try {
            long checkSum = -1L;
            File tmpFile = File.createTempFile("gopro_", ".tmp");
            try (FileOutputStream fileOut = new FileOutputStream(tmpFile);){
                Utils.writeStream(stream, fileOut, 16384);
            }
            checkSum = predefinedTempId != -1L ? predefinedTempId : CRCUtils.createChecksum(tmpFile);
            File originalFile = new File(this.basePath, String.valueOf(checkSum));
            tmpFile.renameTo(originalFile);
            long l = checkSum;
            return l;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long chunkStream(byte[] bytes) throws IOException {
        long crc = CRCUtils.createChecksum(bytes);
        String tmpFileName = this.basePath + crc;
        File tmpFile = new File(tmpFileName);
        if (!tmpFile.exists()) {
            try (FileOutputStream out = new FileOutputStream(tmpFile);){
                out.write(bytes);
            }
        }
        return crc;
    }

    public Chunk getChunk(long id, int chunkNumber, int chunkSize) throws ChunkingException {
        Chunk chunk;
        boolean lastChunk;
        File tempFile;
        block13: {
            tempFile = new File(this.basePath, String.valueOf(id));
            byte[] buffer = new byte[chunkSize];
            int offset = chunkNumber * chunkSize;
            lastChunk = false;
            if (this.testingCRC && CRCUtils.createChecksum(tempFile) != id) {
                throw new ChunkingException("File integrity error: CRC error");
            }
            RandomAccessFile file = new RandomAccessFile(tempFile, "r");
            file.seek(offset);
            try {
                int totalChunks = (int)file.length() / chunkSize;
                if ((int)file.length() % chunkSize > 0) {
                    ++totalChunks;
                }
                if ((totalChunks <= 1 || chunkNumber >= totalChunks - 1) && (int)file.length() % chunkSize > 0) {
                    byte[] copy = new byte[(int)file.length() % chunkSize];
                    System.arraycopy(buffer, 0, copy, 0, Math.min(buffer.length, copy.length));
                    buffer = copy;
                }
                file.read(buffer);
                Chunk chunk2 = new Chunk();
                chunk2.setChunkNumber(chunkNumber);
                chunk2.setChunksCount(totalChunks);
                chunk2.setData(buffer);
                chunk2.setChunkSize(buffer.length);
                chunk2.setCRC(id);
                lastChunk = chunkNumber == totalChunks - 1;
                chunk = chunk2;
                if (file == null) break block13;
            }
            catch (IOException e) {
                try {
                    try {
                        e.printStackTrace();
                        throw new ChunkingException(e);
                    }
                    catch (Throwable throwable) {
                        if (file != null) {
                            file.close();
                        }
                        if (lastChunk && tempFile.exists()) {
                            tempFile.delete();
                        }
                        throw throwable;
                    }
                }
                catch (IOException e2) {
                    return null;
                }
            }
            file.close();
        }
        if (lastChunk && tempFile.exists()) {
            tempFile.delete();
        }
        return chunk;
    }

    public void putChunk(Chunk chunk) throws ChunkingException {
        this.validateChunk(chunk);
        String fileName = this.basePath + chunk.getCRC();
        File f = new File(fileName);
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                throw new ChunkingException("Cannot create a file for chunking: " + fileName, e);
            }
        }
        if (chunk.getChunkNumber() < 1) {
            f.delete();
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                throw new ChunkingException("Cannot replace file: " + fileName, e);
            }
        }
        this.putChunk(chunk, f);
    }

    public void putChunk(Chunk chunk, File targetFile) throws ChunkingException {
        this.validateChunk(chunk);
        RandomAccessFile rFile = null;
        try {
            rFile = new RandomAccessFile(targetFile, "rw");
            rFile.seek(rFile.length());
            rFile.write(chunk.getData());
        }
        catch (IOException e) {
            throw new ChunkingException("Cannot get a chunk from the file: " + targetFile.getAbsolutePath(), e);
        }
        finally {
            if (rFile != null) {
                try {
                    rFile.close();
                }
                catch (IOException e) {
                    throw new ChunkingException("Cannot close file: " + targetFile.getAbsolutePath(), e);
                }
            }
        }
    }

    private void validateChunk(Chunk chunk) throws ChunkingException {
        if (chunk == null) {
            throw new ChunkingException("The chunk parameter must not be null");
        }
        if (chunk.getData() == null || chunk.getData().length == 0) {
            throw new ChunkingException("The chunk is empty");
        }
        if (chunk.getData().length != chunk.getChunkSize()) {
            throw new ChunkingException("The ChunkSize parameter must be equal to the real size of the data");
        }
    }

    private String decodeStorageFileName(byte[] metadata) throws ChunkingException {
        if (AttachmentStoreUtil.arrayStartsWith(metadata, CHUNKED_ATTACHMENT)) {
            if (CHUNKED_ATTACHMENT.length >= metadata.length) {
                throw new ChunkingException("Source file was not found");
            }
            try {
                String storedCRC = new String(metadata, CHUNKED_ATTACHMENT.length, metadata.length - CHUNKED_ATTACHMENT.length, "UTF-8");
                return this.basePath + storedCRC;
            }
            catch (Exception e) {
                throw new ChunkingException(e.getMessage(), e);
            }
        }
        throw new ChunkingException("Cannot decode the metadata");
    }

    public void validateChunkedFile(long crc) throws ChunkingException {
        String fileName = this.basePath + crc;
        File file = new File(fileName);
        if (!file.exists()) {
            throw new ChunkingException("The chunked file doesn't exists");
        }
        try {
            long realCrc = CRCUtils.createChecksum(file);
            if (realCrc != crc) {
                throw new ChunkingException("Incorrect CRC checksum. The chunked file is damaged");
            }
        }
        catch (IOException e) {
            throw new ChunkingException(e.getMessage(), e);
        }
    }

    public InputStream getInputStream(byte[] metadata) throws ChunkingException {
        String fileName = this.decodeStorageFileName(metadata);
        File file = new File(fileName);
        if (file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new ChunkingException(e.getMessage(), e);
            }
        }
        throw new ChunkingException("Incorrect metadata");
    }

    public InputStream getInputStream(File file) throws ChunkingException {
        if (file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new ChunkingException(e.getMessage(), e);
            }
        }
        throw new ChunkingException("Incorrect metadata");
    }

    public void chunkFileAttachment(FileAttachmentType attachment, long predefinedId) throws ChunkingException {
        try {
            long crc = this.chunkStream(AttachmentStoreUtil.getInputStream(attachment.getStream()), predefinedId);
            String chunkStream = new String(CHUNKED_ATTACHMENT).concat(String.valueOf(crc));
            attachment.setStream(chunkStream.getBytes());
        }
        catch (IOException e) {
            throw new ChunkingException(e.getMessage(), e);
        }
    }

    public static final boolean needsChunking(DocumentCollectionType documentCollection) throws GdfServiceException {
        long fileSize = 0L;
        if (documentCollection != null && documentCollection.getDocumentsCount() > 0) {
            for (DocumentBaseType document : documentCollection.getDocuments()) {
                UserType user;
                if (document instanceof IVersionable) {
                    IVersionable versionable = (IVersionable)((Object)document);
                    if (versionable.getCurrentVersion() == null || versionable.getCurrentVersion().getAttachment() == null) continue;
                    fileSize = versionable.getCurrentVersion().getAttachment().getFileSize();
                    continue;
                }
                if (document instanceof ExternalDocumentVersionType) {
                    ExternalDocumentVersionType version = (ExternalDocumentVersionType)document;
                    if (version.getAttachment() == null) continue;
                    fileSize = version.getAttachment().getFileSize();
                    continue;
                }
                if (document instanceof EMailType) {
                    EMailType emailDoc = (EMailType)document;
                    if (emailDoc.getAttachments() == null) continue;
                    for (FileAttachmentType fileattachment : emailDoc.getAttachments()) {
                        fileSize = NumberUtils.max((long[])new long[]{fileSize, fileattachment.getFileSize()});
                    }
                    continue;
                }
                if (!(document instanceof UserType) || (user = (UserType)document).getPhoto() == null) continue;
                fileSize = user.getPhoto().getFileSize();
            }
        }
        return fileSize != 0L && fileSize > (long)(1024 * ChunkSettings.getSendLimitSize());
    }

    public static final long getIdFromReference(byte[] referenceId) {
        if (referenceId == null) {
            throw new IllegalArgumentException("Reference Id is null");
        }
        if (referenceId.length != ChunkSettings.getChunkReferenceSize()) {
            throw new IllegalArgumentException("Invalid reference size. Size is: " + referenceId.length);
        }
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.put(referenceId, 5, 8);
        buf.rewind();
        long documentId = buf.getLong();
        return documentId;
    }

    public static final long getSizeFromReference(byte[] referenceId) {
        if (referenceId == null) {
            throw new IllegalArgumentException("Reference Id is null");
        }
        if (referenceId.length != ChunkSettings.getChunkReferenceSize()) {
            throw new IllegalArgumentException("Invalid reference size. Size is: " + referenceId.length);
        }
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.put(referenceId, 13, 8);
        buf.rewind();
        long size = buf.getLong();
        return size;
    }

    public static final byte[] createReferenceId(long crc, int transactionId, long size) {
        ByteBuffer buffer = ByteBuffer.allocate(ChunkSettings.getChunkReferenceSize());
        buffer.put(ChunkSettings.GDFPreample);
        buffer.putInt((int)crc);
        buffer.putInt(transactionId);
        buffer.putLong(size);
        return buffer.array();
    }

    public static final byte[] createReferenceId(long crc, long size) {
        ByteBuffer buffer = ByteBuffer.allocate(ChunkSettings.getChunkReferenceSize());
        buffer.put(ChunkSettings.GDFPreample);
        buffer.putLong(crc);
        buffer.putLong(size);
        return buffer.array();
    }

    public static String getHexString(byte[] b) {
        String result = "";
        if (b != null) {
            for (int i = 0; i < b.length; ++i) {
                result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
            }
        }
        return result;
    }

    public static int getCRC(byte[] referenceID) {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.put(referenceID, 5, 4);
        buf.rewind();
        return buf.getInt();
    }

    public static int getTransactionID(byte[] referenceID) {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.put(referenceID, 9, 4);
        buf.rewind();
        return buf.getInt();
    }
}

