/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ChunkSettings {
    private static final Logger logger = Logger.getLogger(ChunkSettings.class);
    private static final String GOPRO_CONFIG_FILE_PATH = "gopro-config.ws.file.path";
    private static final String GOPRO_CONFIG_FILENAME = "gopro-config.properties";
    private static Properties configProperties;
    private static final int CHUNK_REFERENCE_SIZE = 21;
    private static final String OPTS_CHUNK_REFERENCE_SIZE = "CHUNK_REFERENCE_SIZE";
    public static final byte[] GDFPreample;
    private static final int DEFAULT_CHUNK_SEND_SIZE_LIMIT = 128;
    private static final String OPTS_CHUNK_SEND_SIZE_LIMIT = "CHUNK_SEND_SIZE_LIMIT";
    private static final int DEFAULT_CHUNK_SEND_SIZE = 128;
    private static final String OPTS_CHUNK_SEND_SIZE = "CHUNK_SEND_SIZE";
    private static final int DEFAULT_CHUNK_GET_SIZE = 256;
    private static final String OPTS_CHUNK_GET_SIZE = "CHUNK_GET_SIZE";

    public static int getChunkReferenceSize() {
        String downloadChunkSize = ChunkSettings.getProperty(OPTS_CHUNK_REFERENCE_SIZE);
        if (downloadChunkSize != null) {
            return Integer.valueOf(downloadChunkSize);
        }
        logger.debug((Object)"CHUNK CONFIGURATION READ DEFAULT: CHUNK_REFERENCE_SIZE: 21");
        return 21;
    }

    public static int getSendLimitSize() {
        String downloadChunkSize = ChunkSettings.getProperty(OPTS_CHUNK_SEND_SIZE_LIMIT);
        if (downloadChunkSize != null) {
            return Integer.valueOf(downloadChunkSize);
        }
        logger.debug((Object)"CHUNK CONFIGURATION READ DEFAULT: CHUNK_SEND_SIZE_LIMIT: 128");
        return 128;
    }

    public static int getUploadChunkSize() {
        String downloadChunkSize = ChunkSettings.getProperty(OPTS_CHUNK_SEND_SIZE);
        if (downloadChunkSize != null) {
            return Integer.valueOf(downloadChunkSize);
        }
        logger.debug((Object)"CHUNK CONFIGURATION READ DEFAULT: CHUNK_SEND_SIZE: 128");
        return 128;
    }

    public static int getDownloadChunkSize() {
        String downloadChunkSize = ChunkSettings.getProperty(OPTS_CHUNK_GET_SIZE);
        if (downloadChunkSize != null) {
            return Integer.valueOf(downloadChunkSize);
        }
        logger.debug((Object)"CHUNK CONFIGURATION READ DEFAULT: CHUNK_GET_SIZE: 256");
        return 256;
    }

    public static String getTempDirectory() {
        String tempdir = System.getProperty("java.io.tmpdir");
        if (!tempdir.endsWith("/") && !tempdir.endsWith("\\")) {
            tempdir = tempdir + System.getProperty("file.separator");
        }
        return tempdir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static String getProperty(String suffix) {
        String systemProperty = System.getProperty(suffix);
        if (systemProperty != null) {
            logger.debug((Object)("CHUNK CONFIGURATION READ: -D" + suffix + "=" + systemProperty));
            return systemProperty;
        }
        if (configProperties == null) {
            Class<ChunkSettings> clazz = ChunkSettings.class;
            // MONITORENTER : net.gopro.util.ChunkSettings.class
            if (configProperties == null) {
                configProperties = new Properties();
                String goproConfigPath = System.getProperty(GOPRO_CONFIG_FILE_PATH);
                if (goproConfigPath != null) {
                    try {
                        FileInputStream configPropsStream = new FileInputStream(new File(goproConfigPath));
                        configProperties.load(configPropsStream);
                    }
                    catch (IOException e) {
                        logger.error((Object)"Problem while loading gopro-config.properties file", (Throwable)e);
                        // MONITOREXIT : clazz
                        return null;
                    }
                }
                try {
                    InputStream stream = ChunkSettings.class.getResourceAsStream("/gopro-config.properties");
                    if (stream == null) {
                        stream = ChunkSettings.class.getResourceAsStream(GOPRO_CONFIG_FILENAME);
                    }
                    if (stream != null) {
                        configProperties.load(stream);
                        stream.close();
                        logger.info((Object)"*******************************************************");
                        logger.info((Object)"* Loading gopro configuration settings from gopro-config.properties");
                        logger.info((Object)"********************************************************");
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"The system cannot find gopro-config.ws.file.path amongst JVM arguments.\nIt should point properties-based configuration file where CHUNK_DIRECTORY and CHUNKING_ENABLED are specified.\n", (Throwable)e);
                }
            }
            // MONITOREXIT : clazz
        }
        logger.debug((Object)("CHUNK CONFIGURATION READ: " + suffix + ": " + configProperties.getProperty(suffix)));
        return configProperties.getProperty(suffix);
    }

    private static String getProperty(String suffix, String defaultValue) {
        String value = ChunkSettings.getProperty(suffix);
        value = value != null && !"".equals(value) ? value : defaultValue;
        return value;
    }

    public static String getChunkDirectory() {
        String fallBackPath = ChunkSettings.getTempDirectory();
        return ChunkSettings.getProperty("CHUNK_DIRECTORY", fallBackPath);
    }

    public static boolean isChunkingEnabled() {
        return "true".equalsIgnoreCase(ChunkSettings.getProperty("CHUNKING_ENABLED", "true"));
    }

    public static boolean isChunkedData(byte[] data) {
        if (data != null && data.length > GDFPreample.length) {
            byte[] sizedData = Arrays.copyOf(data, GDFPreample.length);
            return Arrays.equals(GDFPreample, sizedData);
        }
        return false;
    }

    static {
        GDFPreample = new byte[]{58, 103, 102, 116, 124};
    }
}

