/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

public class CRCUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long createChecksum(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            long l = CRCUtils.createChecksum(in);
            return l;
        }
    }

    public static long createChecksum(InputStream in) throws IOException {
        int bytesRead;
        CRC32 checksum = new CRC32();
        checksum.reset();
        int bufferSize = 5120;
        byte[] buffer = new byte[bufferSize];
        while ((bytesRead = in.read(buffer)) >= 0) {
            checksum.update(buffer, 0, bytesRead);
        }
        return checksum.getValue();
    }

    public static long createChecksum(byte[] bytes) throws IOException {
        CRC32 checksum = new CRC32();
        checksum.reset();
        checksum.update(bytes);
        return checksum.getValue();
    }
}

