/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.util;

import java.util.StringTokenizer;

public class ArrayUtils {
    private static final String delimiter = "|";
    private static final String encodedDelimiter = "&vp;";

    public static String serialize(String[] array) {
        String commonString = null;
        if (array != null) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < array.length; ++i) {
                String value = array[i];
                if (value == null) {
                    value = "";
                }
                buffer.append(delimiter + value.replace(delimiter, encodedDelimiter));
            }
            commonString = buffer.toString();
            if (array.length > 0 && commonString != null && !"".equals(commonString)) {
                commonString = commonString.substring(1);
            }
        }
        return commonString;
    }

    public static String[] deserializeStringArray(String serializedArray) {
        if (serializedArray == null) {
            return null;
        }
        if (!serializedArray.contains(delimiter)) {
            if ("".equals(serializedArray)) {
                return new String[0];
            }
            return new String[]{serializedArray};
        }
        StringTokenizer tok = new StringTokenizer(serializedArray, delimiter);
        String[] array = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            array[i++] = tok.nextToken().replace(encodedDelimiter, delimiter);
        }
        return array;
    }

    public static final String[] splitArray(String s, String t) {
        String[] v = null;
        if (s != null) {
            StringTokenizer st = new StringTokenizer(s, t);
            v = new String[st.countTokens()];
            for (int i = 0; i < v.length; ++i) {
                v[i] = st.nextToken();
            }
        }
        return v;
    }
}

