/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data.types;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class ACLAccessType
implements Serializable {
    public static final int NONE_TYPE = 0;
    public static final ACLAccessType NONE = new ACLAccessType(0, "None");
    public static final int READ_TYPE = 1;
    public static final ACLAccessType READ = new ACLAccessType(1, "Read");
    public static final int WRITE_TYPE = 2;
    public static final ACLAccessType WRITE = new ACLAccessType(2, "Write");
    private static Hashtable _memberTable = ACLAccessType.init();
    private final int type;
    private String stringValue = null;
    private static final long serialVersionUID = 15000L;

    private ACLAccessType(int type, String value) {
        this.type = type;
        this.stringValue = value;
    }

    public static Enumeration enumerate() {
        return _memberTable.elements();
    }

    public int getType() {
        return this.type;
    }

    private static Hashtable init() {
        Hashtable<String, ACLAccessType> members = new Hashtable<String, ACLAccessType>();
        members.put("None", NONE);
        members.put("Read", READ);
        members.put("Write", WRITE);
        return members;
    }

    private Object readResolve() {
        return ACLAccessType.valueOf(this.stringValue);
    }

    public String toString() {
        return this.stringValue;
    }

    public static ACLAccessType valueOf(String string) {
        Object obj = null;
        if (string != null) {
            obj = _memberTable.get(string);
        }
        if (obj == null) {
            String err = "" + string + " is not a valid ACLAccessType";
            throw new IllegalArgumentException(err);
        }
        return obj;
    }
}

