/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data.helpers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.gopro.gdf.data.BinaryFilterExpressionType;
import net.gopro.gdf.data.DocumentCollectionType;
import net.gopro.gdf.data.DocumentFilterType;
import net.gopro.gdf.data.FlexibleDataSetType;
import net.gopro.gdf.data.HistoryCollectionType;
import net.gopro.gdf.data.IBaseObjectType;
import net.gopro.gdf.data.ReferenceableObjectType;
import net.gopro.gdf.data.helpers.GDFTransformHelper;
import net.gopro.gdf.exceptions.GdfServiceRuntimeException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.types.AnyNode;
import org.exolab.castor.types.Date;
import org.exolab.castor.types.DateTime;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XMLTransformHelper {
    public static DocumentCollectionType toDocumentCollection(String xmlString) {
        return (DocumentCollectionType)XMLTransformHelper.toObject(DocumentCollectionType.class, xmlString);
    }

    public static HistoryCollectionType toHistoryCollection(String xmlString) {
        return (HistoryCollectionType)XMLTransformHelper.toObject(HistoryCollectionType.class, xmlString);
    }

    public static FlexibleDataSetType toFlexibleDataSet(String xmlString) {
        return (FlexibleDataSetType)XMLTransformHelper.toObject(FlexibleDataSetType.class, xmlString);
    }

    public static DocumentFilterType toDocumentFilter(String xmlString) {
        return (DocumentFilterType)XMLTransformHelper.toObject(DocumentFilterType.class, xmlString);
    }

    public static String toXMLString(IBaseObjectType object) {
        StringWriter writer = new StringWriter();
        XMLTransformHelper.writeObjectToXML(object, writer);
        if (object instanceof DocumentFilterType || object instanceof BinaryFilterExpressionType) {
            return XMLTransformHelper.postProcessFilterXml(writer.toString());
        }
        return writer.toString();
    }

    public static InputStream toXMLStream(IBaseObjectType object) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);
        XMLTransformHelper.writeObjectToXML(object, writer);
        if (object instanceof DocumentFilterType || object instanceof BinaryFilterExpressionType) {
            return IOUtils.toInputStream((String)XMLTransformHelper.postProcessFilterXml(writer.toString()), (Charset)StandardCharsets.UTF_8);
        }
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    private static void writeObjectToXML(IBaseObjectType object, Writer writer) {
        GDFTransformHelper.patchSerializedObject(object);
        try {
            Marshaller marshaller = new Marshaller(writer);
            marshaller.setNamespaceMapping("xs", "http://www.w3.org/2001/XMLSchema");
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)object);
        }
        catch (IOException | MarshalException | ValidationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object toObject(Class<?> objClass, String xmlString) {
        try {
            return Unmarshaller.unmarshal(objClass, (Reader)new StringReader(xmlString));
        }
        catch (MarshalException e) {
            throw new GdfServiceRuntimeException(e);
        }
        catch (ValidationException e) {
            throw new GdfServiceRuntimeException(e);
        }
    }

    public static ReferenceableObjectType toReferencableObject(String xmlString) {
        try {
            Document xmlDoc = XMLTransformHelper.loadXMLFromString(xmlString);
            Class<?> objectClass = Class.forName("net.gopro.gdf.data." + xmlDoc.getDocumentElement().getNodeName());
            return (ReferenceableObjectType)XMLTransformHelper.toObject(objectClass, xmlString);
        }
        catch (GdfServiceRuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new GdfServiceRuntimeException("Could not unmarshall object string: " + xmlString, ex);
        }
    }

    private static Document loadXMLFromString(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(xml));
        return builder.parse(is);
    }

    private static String postProcessFilterXml(String xml) {
        xml = XMLTransformHelper.replace(xml, "java:java.lang.String", "xs:string");
        xml = XMLTransformHelper.replace(xml, "java:java.lang.Integer", "xs:int");
        xml = XMLTransformHelper.replace(xml, "java:java.lang.Long", "xs:long");
        xml = XMLTransformHelper.replace(xml, "java:java.lang.Float", "xs:float");
        xml = XMLTransformHelper.replace(xml, "java:java.lang.Double", "xs:double");
        xml = XMLTransformHelper.replace(xml, "java:java.lang.Boolean", "xs:boolean");
        xml = XMLTransformHelper.replace(xml, "type=\"date\"", "type=\"xs:dateTime\"");
        return xml;
    }

    public static Object convertAnyNodeValue(AnyNode anyNode) {
        int typeEndIndex;
        Object value = anyNode.getStringValue();
        String xml = anyNode.toString();
        int typeIndex = xml.indexOf("type=\"");
        String type = null;
        if (typeIndex > 0 && (typeEndIndex = xml.indexOf("\"", typeIndex += 6)) >= 0) {
            type = xml.substring(typeIndex, typeEndIndex).toLowerCase();
        }
        if (type.contains(":")) {
            type = XMLTransformHelper.removeNameSpace(type);
        }
        if ("int".equals(type)) {
            value = new Integer((String)value);
        } else if ("long".equals(type)) {
            value = new Long((String)value);
        } else if ("float".equals(type)) {
            value = new Float((String)value);
        } else if ("double".equals(type)) {
            value = new Double((String)value);
        } else if ("boolean".equals(type)) {
            value = new Boolean("true".equals(((String)value).toLowerCase()));
        } else {
            if ("date".equals(type)) {
                try {
                    value = ((Date)Date.parse((String)((String)value))).toDate();
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
            if ("datetime".equals(type)) {
                try {
                    value = DateTime.parse((String)((String)value)).toDate();
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
            if ("base64binary".equalsIgnoreCase(type)) {
                try {
                    value = Base64.decodeBase64((byte[])((String)value).getBytes());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return value;
    }

    private static final String replace(String src, String a, String b) {
        int j = src.indexOf(a);
        if (j == -1) {
            return src;
        }
        StringBuffer s = new StringBuffer(src.length());
        int i = 0;
        while (j > -1) {
            s.append(src.substring(i, j));
            s.append(b);
            i = j + a.length();
            j = src.indexOf(a, i);
        }
        if (i < src.length()) {
            s.append(src.substring(i));
        }
        return s.toString();
    }

    private static final String removeNameSpace(String type) {
        if (type.contains(":")) {
            type = type.substring(type.indexOf(":") + 1);
            type = XMLTransformHelper.removeNameSpace(type);
        }
        return type;
    }

    public static String extractData(String xmlText, String ... excludeNodes) {
        String pWhiteSpaces = "(\\s)";
        String pHeading = "(<\\?)(.+?)(\\?>)";
        String pID = "<(?i)ID>[^<]+?</(?i)ID>";
        String pData = "<[^<]+?>";
        xmlText = xmlText.replaceAll(pWhiteSpaces, " ");
        xmlText = xmlText.replaceAll(pHeading, " ");
        xmlText = xmlText.replaceAll(pID, " ");
        for (String excludeNode : excludeNodes) {
            String nodePattern = "<(?i)" + excludeNode + ">(.*?)</(?i)" + excludeNode + ">";
            xmlText = xmlText.replaceAll(nodePattern, " ");
        }
        String attValues = XMLTransformHelper.getAttValues(xmlText);
        xmlText = xmlText.replaceAll(pData, " ");
        return attValues + xmlText.trim();
    }

    public static String getAttValues(String inputString) {
        String pStr = "\\w*[^(xmlns)|^(ID)|^(xsi)]=\\s*(\"[^\"]*\"|'[^']*')";
        Pattern p = Pattern.compile(pStr);
        Matcher m = p.matcher(inputString);
        StringBuilder result = new StringBuilder();
        while (m.find()) {
            String attValue = m.group();
            int index = attValue.indexOf("=");
            if (index <= -1 || attValue.length() <= index + 2) continue;
            attValue = attValue.substring(index + 2, attValue.length() - 1);
            result.append(attValue).append(" ");
        }
        return result.toString();
    }

    public static String stripNonValidXMLCharacters(String in) {
        if (in == null || "".equals(in)) {
            return in;
        }
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < in.length(); ++i) {
            char current = in.charAt(i);
            if (!(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd') && (current < '\u10000' || current > '\u10ffff')) continue;
            out.append(current);
        }
        return out.toString();
    }
}

