/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data.helpers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.gopro.gdf.data.BaseRefType;
import net.gopro.gdf.data.IBaseObjectType;
import net.gopro.gdf.data.helpers.CastorEnumsHelper;
import net.gopro.gdf.data.types.ACLUserType;
import net.gopro.gdf.exceptions.GdfServiceRuntimeException;
import org.apache.commons.lang.math.NumberUtils;

public class PropertyHelper {
    private static Map<String, String> propertyMaps = new HashMap<String, String>();
    private static Map<String, Method> methodCache = new HashMap<String, Method>();
    private static Pattern pattern = Pattern.compile("^[_]*([a-zA-Z]+).*");

    public static boolean setDocumentPropertySafe(IBaseObjectType doc, String propertyName, Object propertyValue) {
        try {
            return PropertyHelper.setDocumentProperty(doc, propertyName, propertyValue);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean setDocumentProperty(IBaseObjectType doc, String propertyName, Object propertyValue) {
        String className = doc == null ? "(NULL)" : doc.getClass().getName();
        String peeeledPropertyName = PropertyHelper.peelProperty(propertyName, className);
        Method setter = PropertyHelper.getSetter(doc, peeeledPropertyName, propertyValue);
        Method getter = PropertyHelper.getGetter(doc, peeeledPropertyName);
        if (setter != null && getter != null) {
            try {
                Object value = getter.invoke((Object)doc, new Object[0]);
                if (value == null || !value.equals(propertyValue)) {
                    Object setValue = propertyValue;
                    Class<?> paramClass = setter.getParameterTypes()[0];
                    if (PropertyHelper.isGoProEnumType(paramClass)) {
                        setValue = PropertyHelper.evaluateGoProEnumType(setter.getParameterTypes()[0], setValue);
                    } else if (PropertyHelper.isGoProRefType(paramClass)) {
                        setValue = PropertyHelper.evaluateGoProRefType((BaseRefType)getter.invoke((Object)doc, new Object[0]), paramClass, propertyName, setValue);
                    }
                    setter.invoke((Object)doc, setValue);
                    return true;
                }
                return false;
            }
            catch (IllegalArgumentException e) {
                throw new GdfServiceRuntimeException("Illegal argument for getter/setter for property '" + peeeledPropertyName + " (" + propertyName + ")' on class '" + className + "'");
            }
            catch (IllegalAccessException e) {
                throw new GdfServiceRuntimeException("Could not access getter/setter for property '" + peeeledPropertyName + " (" + propertyName + ")' on class '" + className + "'");
            }
            catch (InvocationTargetException e) {
                throw new GdfServiceRuntimeException("Could not invoke getter/setter for property '" + peeeledPropertyName + " (" + propertyName + ")' on class '" + className + "'");
            }
            catch (SecurityException e) {
                throw new GdfServiceRuntimeException("Could not access getter/setter for property '" + peeeledPropertyName + " (" + propertyName + ")' on class '" + className + "'");
            }
            catch (NoSuchMethodException e) {
                throw new GdfServiceRuntimeException("Could not find getter/setter for property '" + peeeledPropertyName + " (" + propertyName + ")' on class '" + className + "'");
            }
            catch (InstantiationException e) {
                throw new GdfServiceRuntimeException("Could instantiate getter/setter for property '" + peeeledPropertyName + " (" + propertyName + ")' on class '" + className + "'");
            }
        }
        throw new GdfServiceRuntimeException("Could not find getter/setter for property '" + peeeledPropertyName + " (" + propertyName + ")' on class '" + className + "'");
    }

    public static Object getDocumentPropertySafe(IBaseObjectType doc, String propertyName) {
        try {
            return PropertyHelper.getDocumentProperty(doc, propertyName);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Object getDocumentProperty(IBaseObjectType doc, String propertyName) {
        String className = doc == null ? "(NULL)" : doc.getClass().getName();
        String peeledPropertyName = PropertyHelper.peelProperty(propertyName, className);
        Method getter = PropertyHelper.getGetter(doc, peeledPropertyName);
        if (getter != null) {
            try {
                if (!propertyName.endsWith(peeledPropertyName) && PropertyHelper.isGoProRefType(getter.getReturnType())) {
                    String subPropertyName = propertyName.substring(propertyName.lastIndexOf(".") + 1);
                    return PropertyHelper.getDocumentProperty((IBaseObjectType)getter.invoke((Object)doc, new Object[0]), subPropertyName);
                }
                return getter.invoke((Object)doc, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new GdfServiceRuntimeException("Illegal argument for getter for property '" + peeledPropertyName + " (" + propertyName + ")' on class '" + className + "'");
            }
            catch (IllegalAccessException e) {
                throw new GdfServiceRuntimeException("Could not access getter for property '" + peeledPropertyName + " (" + propertyName + ")' on class '" + className + "'");
            }
            catch (InvocationTargetException e) {
                throw new GdfServiceRuntimeException("Could not invoke getter for property '" + peeledPropertyName + " (" + propertyName + ")' on class '" + className + "'");
            }
        }
        throw new GdfServiceRuntimeException("Could not find getter for property '" + peeledPropertyName + " (" + propertyName + ")' on class '" + className + "'");
    }

    public static Class<?> getDocumentPropertyType(IBaseObjectType doc, String propertyName) {
        String className = doc == null ? "(NULL)" : doc.getClass().getName();
        String peeledPropertyName = PropertyHelper.peelProperty(propertyName, className);
        Method getter = PropertyHelper.getGetter(doc, peeledPropertyName);
        if (getter != null) {
            return getter.getReturnType();
        }
        return null;
    }

    private static String peelProperty(String propertyName, String clazzName) {
        String key = clazzName + "." + propertyName;
        if (propertyMaps.containsKey(key)) {
            return propertyMaps.get(key);
        }
        Matcher m = pattern.matcher(propertyName);
        while (m.find()) {
            String found = m.group(1);
            if (found == null || "".equals(found.trim())) continue;
            propertyMaps.put(key, found);
            return m.group(1);
        }
        return propertyName;
    }

    private static Method getSetter(IBaseObjectType doc, String propertyName, Object propertyValue) {
        return PropertyHelper.findMethod(doc, "set" + propertyName, new Object[]{propertyValue});
    }

    private static Method getGetter(IBaseObjectType doc, String propertyName) {
        return PropertyHelper.findMethod(doc, "get" + propertyName, null);
    }

    private static Method findMethod(Object object, String methodName, Object[] parameterValues) {
        return PropertyHelper.findMethod(object.getClass(), methodName, parameterValues);
    }

    public static Method findMethod(Class<?> objectClass, String methodName, Object[] parameterValues) {
        if (parameterValues != null && parameterValues.length > 0) {
            Class[] parameterTypes = new Class[parameterValues.length];
            for (int ac = 0; ac < parameterValues.length; ++ac) {
                if (parameterValues[ac] == null) continue;
                parameterTypes[ac] = parameterValues[ac].getClass();
            }
            return PropertyHelper.findMethod(objectClass, methodName, parameterTypes);
        }
        return PropertyHelper.findMethod(objectClass, methodName, null);
    }

    public static Method findMethod(Class<?> objectClass, String methodName, Class<?>[] parameterTypes) {
        String parameterKey = parameterTypes == null ? "" : "_" + String.valueOf(parameterTypes.length);
        String methodKey = objectClass.getName() + "." + methodName + parameterKey;
        if (methodCache.containsKey(methodKey)) {
            return methodCache.get(methodKey);
        }
        while (objectClass != null) {
            for (Method method : objectClass.getDeclaredMethods()) {
                if (!method.getName().equalsIgnoreCase(methodName)) continue;
                if (parameterTypes == null) {
                    if (method.getParameterTypes().length != 0) continue;
                    methodCache.put(methodKey, method);
                    return method;
                }
                if (parameterTypes.length != method.getParameterTypes().length) continue;
                boolean found = true;
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Class<?> paramType = parameterTypes[i];
                    Class<?> parameterClass = method.getParameterTypes()[i];
                    boolean isEnumType = false;
                    if (PropertyHelper.isGoProEnumType(parameterClass)) {
                        isEnumType = paramType == null || String.class.isAssignableFrom(paramType) || Number.class.isAssignableFrom(paramType);
                    }
                    boolean isRefType = false;
                    if (PropertyHelper.isGoProRefType(parameterClass)) {
                        isRefType = true;
                    }
                    found = found && (paramType == null || isEnumType || isRefType || parameterClass.isAssignableFrom(paramType) || parameterClass.isPrimitive() && Number.class.isAssignableFrom(paramType) || Boolean.TYPE.equals(parameterClass) && Boolean.class.equals(paramType));
                }
                if (!found) continue;
                methodCache.put(methodKey, method);
                return method;
            }
            objectClass = objectClass.getSuperclass();
        }
        methodCache.put(methodKey, null);
        return null;
    }

    private static boolean isGoProRefType(Class<?> clazz) {
        return BaseRefType.class.isAssignableFrom(clazz);
    }

    private static BaseRefType evaluateGoProRefType(BaseRefType existingRefType, Class<? extends BaseRefType> refClazz, String propertyName, Object propertyValue) throws InstantiationException, IllegalAccessException {
        if (propertyValue == null || refClazz.isAssignableFrom(propertyValue.getClass())) {
            return (BaseRefType)propertyValue;
        }
        if (existingRefType == null) {
            existingRefType = refClazz.newInstance();
        }
        String subProperty = propertyName.substring(propertyName.lastIndexOf(".") + 1);
        PropertyHelper.setDocumentPropertySafe(existingRefType, subProperty, propertyValue);
        return existingRefType;
    }

    private static boolean isGoProEnumType(Class<?> clazz) {
        if (clazz == null || clazz.getPackage() == null) {
            return false;
        }
        return clazz.getPackage().equals(ACLUserType.class.getPackage());
    }

    private static Object evaluateGoProEnumType(Class<?> enumClazz, Object enumValue) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (enumValue != null) {
            if (PropertyHelper.isGoProEnumType(enumValue.getClass())) {
                return enumValue;
            }
            if (enumValue instanceof String) {
                if (NumberUtils.isNumber((String)((String)enumValue))) {
                    enumValue = NumberUtils.toInt((String)((String)enumValue), (int)-1);
                } else {
                    return enumClazz.getMethod("valueOf", String.class).invoke(null, enumValue);
                }
            }
            if (Number.class.isAssignableFrom(enumValue.getClass())) {
                return CastorEnumsHelper.findEnumElement(enumClazz, ((Number)enumValue).intValue());
            }
        }
        return null;
    }
}

