/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data.helpers;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.gopro.gdf.data.helpers.PropertyHelper;
import net.gopro.util.ArrayUtils;

public class PojoAccessor {
    public static boolean hasProperty(Class<?> clazz, String propertyPath, boolean analyzeArrayElements) {
        Class<?> currentClass = clazz;
        String[] propPath = ArrayUtils.splitArray(propertyPath, ".");
        for (int ac = 0; ac < propPath.length; ++ac) {
            Method accessor = PropertyHelper.findMethod(currentClass, "get" + propPath[ac], null);
            if (accessor == null) {
                return false;
            }
            currentClass = accessor.getReturnType();
            if (!analyzeArrayElements || currentClass.getComponentType() == null) continue;
            currentClass = currentClass.getComponentType();
        }
        return true;
    }

    public static List<Class<?>> getPropertyAccessorTypes(Class<?> clazz, String propertyPath, boolean analyzeArrayElements) {
        Class<?> currentClass = clazz;
        ArrayList accessorTypes = new ArrayList();
        String[] propPath = ArrayUtils.splitArray(propertyPath, ".");
        for (int ac = 0; ac < propPath.length; ++ac) {
            Method accessor = PropertyHelper.findMethod(currentClass, "get" + propPath[ac], null);
            if (accessor == null) {
                return null;
            }
            currentClass = accessor.getReturnType();
            accessorTypes.add(currentClass);
            if (!analyzeArrayElements || currentClass.getComponentType() == null) continue;
            currentClass = currentClass.getComponentType();
        }
        return accessorTypes;
    }

    public static Object getPropertyValue(Object object, String propertyPath) {
        return PojoAccessor.getPropertyValue(object, propertyPath, null);
    }

    public static Object getLeadingPropertyValue(Object object, String propertyPath) {
        int divIndex = propertyPath.indexOf(46);
        String leadingProp = propertyPath.substring(0, divIndex);
        return PojoAccessor.getPropertyValue(object, leadingProp, null);
    }

    public static Object getPropertyValue(Object object, String propertyPath, AtomicReference<Class<?>> outValueType) {
        Class<?> currentClass = object.getClass();
        Object currentValue = object;
        String[] propPath = ArrayUtils.splitArray(propertyPath, ".");
        boolean nullValueDetected = false;
        for (int ac = 0; ac < propPath.length; ++ac) {
            Method accessor = PropertyHelper.findMethod(currentClass, "get" + propPath[ac], null);
            if (accessor == null) {
                throw new RuntimeException("Property resolving problem on getting '" + object.getClass().getName() + "." + propertyPath);
            }
            currentClass = accessor.getReturnType();
            try {
                if (!nullValueDetected) {
                    currentValue = accessor.invoke(currentValue, (Object[])null);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Data resolving problem on getting '" + object.getClass().getName() + "." + propertyPath, e);
            }
            nullValueDetected = currentValue == null;
        }
        if (outValueType != null) {
            outValueType.set(currentClass);
        }
        return currentValue;
    }

    public static void setPropertyValue(Object object, String propertyPath, Object value, boolean autoCreateSubObjects) {
        PojoAccessor.setPropertyValue(object, propertyPath, value, autoCreateSubObjects, false);
    }

    public static void setPropertyValue(Object object, String propertyPath, Object value, boolean autoCreateSubObjects, boolean acceptSingleValuesOnArrays) {
        Class<?> currentClass = object.getClass();
        Object currentValue = object;
        Object previousValue = null;
        String[] propPath = ArrayUtils.splitArray(propertyPath, ".");
        for (int ac = 0; ac < propPath.length; ++ac) {
            boolean lastNode = ac == propPath.length - 1;
            Method accessor = null;
            Method setAccessor = null;
            if (!lastNode) {
                accessor = PropertyHelper.findMethod(currentClass, "get" + propPath[ac], null);
                setAccessor = PropertyHelper.findMethod(currentClass, "set" + propPath[ac], new Class[]{accessor.getReturnType()});
            } else {
                accessor = PropertyHelper.findMethod(currentClass, "get" + propPath[ac], null);
                accessor = PropertyHelper.findMethod(currentClass, "set" + propPath[ac], new Class[]{accessor.getReturnType()});
            }
            if (accessor == null) {
                throw new RuntimeException("Property resolving problem on getting '" + object.getClass().getName() + "." + propertyPath);
            }
            currentClass = accessor.getReturnType();
            previousValue = currentValue;
            try {
                if (!lastNode) {
                    currentValue = accessor.invoke(currentValue, (Object[])null);
                } else {
                    Class<?> valueType = accessor.getParameterTypes()[0];
                    if (value != null || !valueType.isPrimitive()) {
                        accessor.invoke(currentValue, value);
                    } else if (Integer.TYPE.equals(valueType) || Long.TYPE.equals(valueType)) {
                        accessor.invoke(currentValue, new Integer(0));
                    } else if (Float.TYPE.equals(valueType)) {
                        accessor.invoke(currentValue, new Float(0.0f));
                    } else if (Double.TYPE.equals(valueType)) {
                        accessor.invoke(currentValue, new Double(0.0));
                    } else if (Boolean.TYPE.equals(valueType)) {
                        accessor.invoke(currentValue, Boolean.FALSE);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Data processing problem on getting/setting '" + object.getClass().getName() + "." + propertyPath, e);
            }
            if (!lastNode && currentValue == null && ac < propPath.length - 1) {
                if (autoCreateSubObjects) {
                    try {
                        if (currentClass.getComponentType() != null) {
                            if (acceptSingleValuesOnArrays) {
                                currentValue = Array.newInstance(currentClass.getComponentType(), 1);
                                Array.set(currentValue, 0, currentClass.getComponentType().newInstance());
                                setAccessor.invoke(previousValue, currentValue);
                            }
                            throw new RuntimeException("Accept single value on array has to be enabled");
                        }
                        currentValue = currentClass.newInstance();
                        setAccessor.invoke(previousValue, currentValue);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot autocreate subobject property ('" + propPath[ac] + "' of type '" + currentClass.getName() + ") subobject within property path '" + propertyPath + "' when using empty construtor - " + e.getMessage(), e);
                    }
                } else {
                    throw new RuntimeException("Subobject property ('" + propPath[ac] + "' of type '" + currentClass.getName() + ") is 'null' within property path '" + propertyPath + "'");
                }
            }
            if (currentClass.getComponentType() == null || !acceptSingleValuesOnArrays || ac >= propPath.length - 1) continue;
            if (Array.getLength(currentValue) != 1) {
                try {
                    Object currentTempValue = Array.newInstance(currentClass.getComponentType(), 1);
                    if (Array.getLength(currentValue) > 0) {
                        Array.set(currentTempValue, 0, Array.get(currentValue, 0));
                    } else {
                        Array.set(currentTempValue, 0, currentClass.getComponentType().newInstance());
                    }
                    currentValue = currentTempValue;
                    setAccessor.invoke(previousValue, currentValue);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot resize array subobject property ('" + propPath[ac] + "' of type '" + currentClass.getName() + ") subobject within property path '" + propertyPath + "' when using empty construtor - " + e.getMessage(), e);
                }
            }
            currentClass = currentClass.getComponentType();
            currentValue = Array.get(currentValue, 0);
        }
    }

    public static boolean isSimpleType(Class<?> type) {
        return type.isPrimitive() || Number.class.isAssignableFrom(type) || Boolean.class.equals(type) || String.class.equals(type) || Date.class.isAssignableFrom(type);
    }
}

