/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data.helpers;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import net.gopro.gdf.data.DocumentBaseType;
import net.gopro.gdf.data.MetaDataType;
import net.gopro.gdf.data.types.MetaValueType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class MetaDataHelper {
    private static final String PATTERN_FULL = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

    public static MetaDataType getMetaDataField(DocumentBaseType document, String metaDataName) {
        if (document.getMetaDataEntries() != null && metaDataName != null) {
            for (MetaDataType metaData : document.getMetaDataEntries()) {
                if (metaData.getName() == null || !metaData.getName().equalsIgnoreCase(metaDataName)) continue;
                return metaData;
            }
        }
        return null;
    }

    @Deprecated
    public static Object getMetaDataValue(DocumentBaseType document, String metaDataName) {
        return MetaDataHelper.getMetaDataValueAsString(document, metaDataName);
    }

    public static String getMetaDataValueAsString(DocumentBaseType document, String metaDataName) {
        MetaDataType metaData = MetaDataHelper.getMetaDataField(document, metaDataName);
        if (metaData != null) {
            return metaData.getValue();
        }
        return null;
    }

    public static Object getMetaDataValueAsObject(DocumentBaseType document, String metaDataName) {
        MetaDataType metaData = MetaDataHelper.getMetaDataField(document, metaDataName);
        if (metaData != null) {
            try {
                MetaValueType metaDataType = metaData.getValueType();
                String metaDataValue = metaData.getValue();
                if (MetaValueType.GUID.equals(metaDataType) || MetaValueType.STRING.equals(metaDataType) || MetaValueType.GDFTYPE.equals(metaDataType)) {
                    return metaData.getValue();
                }
                if (StringUtils.isBlank((String)metaDataValue)) {
                    return null;
                }
                if (MetaValueType.DATE.equals(metaDataType)) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(PATTERN_FULL);
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                    return simpleDateFormat.parse(metaDataValue);
                }
                if (MetaValueType.INT.equals(metaDataType)) {
                    return NumberUtils.toInt((String)metaDataValue);
                }
                if (MetaValueType.LONG.equals(metaDataType)) {
                    return NumberUtils.toLong((String)metaDataValue);
                }
                if (MetaValueType.FLOAT.equals(metaDataType)) {
                    return Float.valueOf(NumberUtils.toFloat((String)metaDataValue));
                }
                if (MetaValueType.BOOLEAN.equals(metaDataType)) {
                    return (boolean)Boolean.valueOf(metaData.getValue());
                }
                System.err.println(String.format("Cannot convert type %s of meta data %s", metaData.getName(), metaDataType == null ? "null" : metaDataType.toString()));
            }
            catch (Exception x) {
                return metaData.getValue();
            }
        }
        return null;
    }

    public static MetaDataType setMetaDataField(DocumentBaseType document, String metaDataName, MetaValueType metaDataType, Object metaDataValue) {
        MetaDataType metaData = MetaDataHelper.getMetaDataField(document, metaDataName);
        if (metaData == null) {
            metaData = new MetaDataType();
            metaData.setName(metaDataName);
            document.addMetaDataEntry(metaData);
            metaData.setValueType(metaDataType);
        }
        String serializedMetaDataValue = null;
        if (MetaValueType.DATE.equals(metaDataType)) {
            if (metaDataValue instanceof Date) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(PATTERN_FULL);
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                serializedMetaDataValue = simpleDateFormat.format((Date)metaDataValue);
            }
        } else if (MetaValueType.GUID.equals(metaDataType)) {
            serializedMetaDataValue = (String)metaDataValue;
        } else if (MetaValueType.GDFTYPE.equals(metaDataType)) {
            serializedMetaDataValue = (String)metaDataValue;
        } else if (MetaValueType.STRING.equals(metaDataType)) {
            serializedMetaDataValue = (String)metaDataValue;
        } else if (MetaValueType.INT.equals(metaDataType)) {
            serializedMetaDataValue = String.valueOf(metaDataValue);
        } else if (MetaValueType.LONG.equals(metaDataType)) {
            serializedMetaDataValue = String.valueOf(metaDataValue);
        } else if (MetaValueType.FLOAT.equals(metaDataType)) {
            serializedMetaDataValue = String.valueOf(metaDataValue);
        } else if (MetaValueType.BOOLEAN.equals(metaDataType)) {
            serializedMetaDataValue = String.valueOf(metaDataValue);
        } else {
            System.err.println(String.format("Cannot convert type %s of meta data %s", metaData.getName(), metaDataType == null ? "null" : metaDataType.toString()));
        }
        metaData.setValue(serializedMetaDataValue);
        return metaData;
    }
}

