/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.gopro.gdf.data.DocumentBaseType;
import net.gopro.gdf.data.helpers.DocumentTypesMap;

public class DocumentTypesHelper {
    private static boolean classRegistryLoaded;
    private static HashMap<Integer, HashSet<Integer>> subTypes;
    private static HashMap<Integer, List<Integer>> superTypes;
    private static int[] configDocumentTypes;

    public static boolean isConfigDocumentType(int documentType) {
        if (configDocumentTypes == null) {
            configDocumentTypes = DocumentTypesHelper.provideRelatedTypes(1011);
            Arrays.sort(configDocumentTypes);
        }
        return Arrays.binarySearch(configDocumentTypes, documentType) >= 0;
    }

    public static int[] provideSubAndSuperTypes(int documentType) {
        int[] subTypes = DocumentTypesHelper.provideRelatedTypes(documentType);
        int[] superTypes = DocumentTypesHelper.provideSuperTypes(documentType);
        int[] allTypes = Arrays.copyOf(subTypes, subTypes.length + superTypes.length);
        for (int ac = 0; ac < superTypes.length; ++ac) {
            allTypes[subTypes.length + ac] = superTypes[ac];
        }
        return allTypes;
    }

    public static int[] provideSuperTypes(int documentType) {
        List<Integer> superTypesList;
        if (documentType < 0 || documentType == 1000) {
            return new int[0];
        }
        if (!classRegistryLoaded) {
            DocumentTypesHelper.assureClassRegistryLoaded();
        }
        if ((superTypesList = superTypes.get(documentType)) == null) {
            DocumentTypesMap documentTypesMap = DocumentTypesMap.getInstance();
            Class documentClass = DocumentTypesMap.getInstance().getDocumentClass(documentType);
            superTypesList = new ArrayList<Integer>();
            if (!DocumentBaseType.class.equals((Object)documentClass) && DocumentBaseType.class.isAssignableFrom(documentClass)) {
                do {
                    documentClass = documentClass.getSuperclass();
                    superTypesList.add(documentTypesMap.getDocumentType(documentClass));
                } while (!documentClass.equals(DocumentBaseType.class));
                superTypes.put(documentType, superTypesList);
            }
        }
        int[] superTypesFinal = new int[superTypesList.size()];
        for (int ac = 0; ac < superTypesList.size(); ++ac) {
            superTypesFinal[ac] = superTypesList.get(ac);
        }
        return superTypesFinal;
    }

    public static int[] provideRelatedTypes(Class<?> superDocumentClass) {
        int superDocumentType = DocumentTypesMap.getInstance().getDocumentType(superDocumentClass);
        return DocumentTypesHelper.provideRelatedTypes(superDocumentType);
    }

    public static int[] provideRelatedTypes(int superDocumentType) {
        HashSet<Integer> subTypesList;
        if (!classRegistryLoaded) {
            DocumentTypesHelper.assureClassRegistryLoaded();
        }
        if ((subTypesList = subTypes.get(superDocumentType)) != null && subTypesList.size() > 0) {
            Integer[] subTypesArray = subTypesList.toArray(new Integer[subTypesList.size()]);
            int[] subTypesFinal = new int[subTypesArray.length + 1];
            subTypesFinal[0] = superDocumentType;
            for (int ac = 0; ac < subTypesArray.length; ++ac) {
                subTypesFinal[ac + 1] = subTypesArray[ac];
            }
            return subTypesFinal;
        }
        return new int[]{superDocumentType};
    }

    public static void dumpSubTypes(int superDocumentType) {
        int[] types = DocumentTypesHelper.provideRelatedTypes(superDocumentType);
        System.out.println("Sub types for document type '" + DocumentTypesMap.getInstance().getDocumentClass(superDocumentType).getName() + "'");
        System.out.println("-------------------------------------------------");
        for (int type : types) {
            System.out.println(DocumentTypesMap.getInstance().getDocumentClass(type).getName());
        }
        System.out.println("-------------------------------------------------\n");
    }

    protected static synchronized void assureClassRegistryLoaded() {
        subTypes = new HashMap();
        classRegistryLoaded = true;
        Enumeration classNames = DocumentTypesMap.getInstance().enumerateDocumentClasses();
        while (classNames.hasMoreElements()) {
            String className = (String)classNames.nextElement();
            subTypes.put(DocumentTypesMap.getInstance().getDocumentType(className), new HashSet());
        }
        for (Integer docType : subTypes.keySet()) {
            DocumentTypesHelper.resolveSubClasses(docType, null);
        }
    }

    protected static void resolveSubClasses(int childDocumentType, List<Integer> accumulatedSubTypes) {
        int superDocumentType;
        Class superClass;
        Class childClass = DocumentTypesMap.getInstance().getDocumentClass(childDocumentType);
        if (childClass != null && (superClass = childClass.getSuperclass()) != null && !Object.class.equals(superClass) && (superDocumentType = DocumentTypesMap.getInstance().getDocumentType(superClass)) != -1) {
            boolean proceed;
            HashSet<Integer> subTypesList = subTypes.get(superDocumentType);
            boolean bl = proceed = accumulatedSubTypes == null || !subTypesList.containsAll(accumulatedSubTypes);
            if (proceed) {
                if (accumulatedSubTypes == null) {
                    accumulatedSubTypes = new ArrayList<Integer>();
                }
                accumulatedSubTypes.add(childDocumentType);
                subTypesList.addAll(accumulatedSubTypes);
                DocumentTypesHelper.resolveSubClasses(superDocumentType, accumulatedSubTypes);
            }
        }
        HashSet<Integer> subTypesList = subTypes.get(childDocumentType);
        if (childDocumentType == 1025 || childDocumentType == 1039 || childDocumentType == 1032 || childDocumentType == 1037) {
            subTypesList.add(1026);
        }
    }

    static {
        subTypes = new HashMap();
        superTypes = new HashMap();
    }
}

