/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data.helpers;

import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import net.gopro.gdf.constants.DataLoadingOptions;
import net.gopro.gdf.data.BinaryFilterExpressionType;
import net.gopro.gdf.data.ConjunctionListType;
import net.gopro.gdf.data.DisjunctionListType;
import net.gopro.gdf.data.DocumentCollectionType;
import net.gopro.gdf.data.DocumentFilterType;
import net.gopro.gdf.data.FilterExpressionType;
import net.gopro.gdf.data.helpers.DocumentTypesMap;
import net.gopro.gdf.data.types.DeleteStatusType;
import net.gopro.gdf.data.types.FilterOperatorType;
import net.gopro.gdf.data.types.HiddenStatusType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class DocumentFilterHelper {
    public static DocumentFilterType getModifiedAfterLatestFilter(DocumentCollectionType coll) {
        DocumentFilterType filter = DocumentFilterHelper.getEmptyFilter();
        if (coll != null && coll.getDocumentsCount() > 0) {
            Date latestDate = null;
            Date currentDate = null;
            for (int i = 0; i < coll.getDocumentsCount(); ++i) {
                currentDate = coll.getDocument(i).getModifiedDate();
                if (currentDate == null) continue;
                latestDate = latestDate != null && currentDate.before(latestDate) ? latestDate : currentDate;
            }
            if (latestDate != null) {
                BinaryFilterExpressionType latestDocumentsFilter = new BinaryFilterExpressionType();
                latestDocumentsFilter.setPropertyName("_modifiedDate");
                latestDocumentsFilter.setOperator(FilterOperatorType.GREATER);
                latestDocumentsFilter.setValue(latestDate);
                filter.setCustomFilter(latestDocumentsFilter);
            }
        }
        return filter;
    }

    public static DocumentFilterType getDocumentTypeFilter(int documentType) {
        DocumentFilterType filter = DocumentFilterHelper.getEmptyFilter();
        filter.setDocumentFormType(documentType);
        return filter;
    }

    public static DocumentFilterType getEmptyFilter() {
        return DocumentFilterHelper.initializeEmptyFilter(new DocumentFilterType());
    }

    public static DocumentFilterType getDocumentIdFilter(String id) {
        DocumentFilterType filter = DocumentFilterHelper.getEmptyFilter();
        filter.setDocumentFormType(1001);
        filter.addFilterDocumentID(id);
        filter.setStartRow(0);
        filter.setRowsCount(1);
        filter.setDeleteStatus(DeleteStatusType.ALL);
        filter.setHiddenStatus(HiddenStatusType.ALL);
        return filter;
    }

    public static DocumentFilterType getDocumentIdsFilter(Collection<String> ids) {
        DocumentFilterType filter = DocumentFilterHelper.getEmptyFilter();
        filter.setDocumentFormType(1001);
        filter.getFilterDocumentIDsAsReference().addAll(ids);
        filter.setStartRow(0);
        filter.setRowsCount(ids.size());
        filter.setDeleteStatus(DeleteStatusType.ALL);
        filter.setHiddenStatus(HiddenStatusType.ALL);
        return filter;
    }

    public static DocumentFilterType getDocumentResponsesFilter(String parentId) {
        DocumentFilterType filter = DocumentFilterHelper.getEmptyFilter();
        filter.setDocumentFormType(1003);
        filter.addFilterParentID(parentId);
        filter.setStartRow(0);
        filter.setRowsCount(Integer.MAX_VALUE);
        filter.setDeleteStatus(DeleteStatusType.NOTDELETED);
        filter.setHiddenStatus(HiddenStatusType.NOTHIDDEN);
        return filter;
    }

    public static DocumentFilterType getFullTextSearchFilter(String ftSearch) {
        DocumentFilterType filter = DocumentFilterHelper.getEmptyFilter();
        filter.setDocumentFormType(1002);
        filter.setFullTextSearch(ftSearch);
        filter.setDataLoadingOptions(filter.getDataLoadingOptions() | DataLoadingOptions.ENABLE_FTSEARCH.getValue());
        filter.setStartRow(0);
        filter.setRowsCount(Integer.MAX_VALUE);
        filter.setDeleteStatus(DeleteStatusType.NOTDELETED);
        filter.setHiddenStatus(HiddenStatusType.NOTHIDDEN);
        return filter;
    }

    public static DocumentFilterType initializeEmptyFilter(DocumentFilterType filter) {
        filter.setID(UUID.randomUUID().toString());
        filter.setSubject("");
        filter.setStartRow(0);
        filter.setRowsCount(Integer.MAX_VALUE);
        filter.setSortDescending(false);
        filter.setDeleteStatus(DeleteStatusType.NOTDELETED);
        filter.setHiddenStatus(HiddenStatusType.NOTHIDDEN);
        return filter;
    }

    public static DisjunctionListType createOrList(FilterExpressionType ... filterExpressions) {
        DisjunctionListType orList = new DisjunctionListType();
        if (filterExpressions != null) {
            for (FilterExpressionType filterExpression : filterExpressions) {
                if (filterExpression == null) continue;
                orList.addElement(filterExpression);
            }
        }
        return orList;
    }

    public static ConjunctionListType createAndList(FilterExpressionType ... filterExpressions) {
        ConjunctionListType andList = new ConjunctionListType();
        if (filterExpressions != null) {
            for (FilterExpressionType filterExpression : filterExpressions) {
                if (filterExpression == null) continue;
                andList.addElement(filterExpression);
            }
        }
        return andList;
    }

    public static BinaryFilterExpressionType createBinaryExpression(String propertyName, FilterOperatorType operator, Object propertyValue) {
        BinaryFilterExpressionType expression = new BinaryFilterExpressionType();
        expression.setPropertyName(propertyName);
        expression.setOperator(operator);
        if (FilterOperatorType.IN.equals(operator) || FilterOperatorType.BETWEEN.equals(operator) || FilterOperatorType.CONTAINSONE.equals(operator) || FilterOperatorType.CONTAINSALL.equals(operator)) {
            if (propertyValue != null && propertyValue.getClass().getComponentType() != null) {
                expression.setInValues((Object[])propertyValue);
            } else {
                expression.setInValues(new Object[]{propertyValue});
            }
        } else {
            expression.setValue(propertyValue);
        }
        return expression;
    }

    public static int decodeDocumentType(String typeHint) {
        if (!StringUtils.isBlank((String)typeHint)) {
            if (NumberUtils.isNumber((String)typeHint)) {
                return NumberUtils.toInt((String)typeHint);
            }
            String className = typeHint;
            if (!className.startsWith("net.gopro.gdf.data.")) {
                className = "net.gopro.gdf.data." + className;
            }
            if (!className.endsWith("Type") && !className.endsWith("type")) {
                className = className + "Type";
            }
            return DocumentTypesMap.getInstance().getDocumentType(className.toLowerCase());
        }
        return 0;
    }
}

