/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data.helpers;

import net.gopro.gdf.data.ACLDocumentRefType;
import net.gopro.gdf.data.ACLDocumentType;
import net.gopro.gdf.data.OrganizationUnitRefType;
import net.gopro.gdf.data.OrganizationUnitType;
import net.gopro.gdf.data.UserGroupRefType;
import net.gopro.gdf.data.UserGroupType;
import net.gopro.gdf.data.UserPositionRefType;
import net.gopro.gdf.data.UserPositionType;
import net.gopro.gdf.data.UserRefType;
import net.gopro.gdf.data.UserRoleRefType;
import net.gopro.gdf.data.UserRoleType;
import net.gopro.gdf.data.UserType;
import net.gopro.gdf.data.types.ACLUserType;

public class ACLEntryHelper {
    private static final Object[] aclClassMappings = new Object[]{UserRoleType.class, UserRoleRefType.class, ACLUserType.ROLE, UserPositionType.class, UserPositionRefType.class, ACLUserType.POSITION, UserType.class, UserRefType.class, ACLUserType.USER, OrganizationUnitType.class, OrganizationUnitRefType.class, ACLUserType.ORGANIZATION, UserGroupType.class, UserGroupRefType.class, ACLUserType.GROUP};

    public static ACLUserType getAclUserType(Class<?> aclDocumentClass) {
        for (int ac = 0; ac < aclClassMappings.length; ac += 3) {
            if (!aclClassMappings[ac].equals(aclDocumentClass)) continue;
            return (ACLUserType)aclClassMappings[ac + 2];
        }
        throw new RuntimeException("Unsupported ACL document type: " + aclDocumentClass.getName());
    }

    public static Class<? extends ACLDocumentType> getAclDocumentClass(ACLUserType aclEntryType) {
        for (int ac = 0; ac < aclClassMappings.length; ac += 3) {
            if (!aclClassMappings[ac + 2].equals(aclEntryType)) continue;
            return (Class)aclClassMappings[ac];
        }
        throw new RuntimeException("Unsupported ACL entry type: " + aclEntryType);
    }

    public static ACLUserType getAclUserTypeByRefClass(Class<?> aclDocumentRefClass) {
        for (int ac = 0; ac < aclClassMappings.length; ac += 3) {
            if (!aclClassMappings[ac + 1].equals(aclDocumentRefClass)) continue;
            return (ACLUserType)aclClassMappings[ac + 2];
        }
        throw new RuntimeException("Unsupported ACL document type: " + aclDocumentRefClass.getName());
    }

    public static Class<? extends ACLDocumentRefType> getAclDocumentRefClass(ACLUserType aclEntryType) {
        for (int ac = 0; ac < aclClassMappings.length; ac += 3) {
            if (!aclClassMappings[ac + 2].equals(aclEntryType)) continue;
            return (Class)aclClassMappings[ac + 1];
        }
        throw new RuntimeException("Unsupported ACL entry type: " + aclEntryType);
    }
}

