/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.ACLDocumentRefType;
import net.gopro.gdf.data.ObjectBaseType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class WorkItemType
extends ObjectBaseType
implements Serializable {
    private String _ID;
    private ACLDocumentRefType _participant;
    private String _action;
    private List _availableActionList = new ArrayList();
    private String _comment;
    private static final long serialVersionUID = 15000L;

    public void addAvailableAction(String vAvailableAction) throws IndexOutOfBoundsException {
        this._availableActionList.add(vAvailableAction);
    }

    public void addAvailableAction(int index, String vAvailableAction) throws IndexOutOfBoundsException {
        this._availableActionList.add(index, vAvailableAction);
    }

    public Enumeration enumerateAvailableActions() {
        return Collections.enumeration(this._availableActionList);
    }

    public String getAction() {
        return this._action;
    }

    public String getAvailableAction(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._availableActionList.size()) {
            throw new IndexOutOfBoundsException("getAvailableAction: Index value '" + index + "' not in range [0.." + (this._availableActionList.size() - 1) + "]");
        }
        return (String)this._availableActionList.get(index);
    }

    public String[] getAvailableActions() {
        String[] array = new String[]{};
        return this._availableActionList.toArray(array);
    }

    public List getAvailableActionsAsReference() {
        return this._availableActionList;
    }

    public int getAvailableActionsCount() {
        return this._availableActionList.size();
    }

    public String getComment() {
        return this._comment;
    }

    public String getID() {
        return this._ID;
    }

    public ACLDocumentRefType getParticipant() {
        return this._participant;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateAvailableActions() {
        return this._availableActionList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAllAvailableActions() {
        this._availableActionList.clear();
    }

    public boolean removeAvailableAction(String vAvailableAction) {
        boolean removed = this._availableActionList.remove(vAvailableAction);
        return removed;
    }

    public String removeAvailableActionAt(int index) {
        Object obj = this._availableActionList.remove(index);
        return (String)obj;
    }

    public void setAction(String action) {
        this._action = action;
    }

    public void setAvailableAction(int index, String vAvailableAction) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._availableActionList.size()) {
            throw new IndexOutOfBoundsException("setAvailableAction: Index value '" + index + "' not in range [0.." + (this._availableActionList.size() - 1) + "]");
        }
        this._availableActionList.set(index, vAvailableAction);
    }

    public void setAvailableActions(String[] vAvailableActionArray) {
        this._availableActionList.clear();
        for (int i = 0; i < vAvailableActionArray.length; ++i) {
            this._availableActionList.add(vAvailableActionArray[i]);
        }
    }

    public void setAvailableActions(List vAvailableActionList) {
        this._availableActionList.clear();
        this._availableActionList.addAll(vAvailableActionList);
    }

    public void setAvailableActionsAsReference(List availableActionList) {
        this._availableActionList = availableActionList;
    }

    public void setComment(String comment) {
        this._comment = comment;
    }

    public void setID(String ID) {
        this._ID = ID;
    }

    public void setParticipant(ACLDocumentRefType participant) {
        this._participant = participant;
    }

    public static WorkItemType unmarshalWorkItemType(Reader reader) throws MarshalException, ValidationException {
        return (WorkItemType)Unmarshaller.unmarshal(WorkItemType.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

