/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.ACLDocumentRefType;
import net.gopro.gdf.data.ACLDocumentType;
import net.gopro.gdf.data.ACLType;
import net.gopro.gdf.data.FileAttachmentType;
import net.gopro.gdf.data.ListValueRefType;
import net.gopro.gdf.data.NameType;
import net.gopro.gdf.data.PhoneNumberType;
import net.gopro.gdf.data.ReferenceableObjectType;
import net.gopro.gdf.data.UserPositionRefType;
import net.gopro.gdf.data.UserRefType;
import net.gopro.gdf.data.UserRoleRefType;
import net.gopro.gdf.data.types.EMailClientType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class UserType
extends ACLDocumentType
implements Serializable {
    private NameType _name;
    private String _fullName;
    private String _loginName;
    private String _password;
    private String _jobTitle;
    private List _userRoleList = new ArrayList();
    private ListValueRefType _language;
    private String _EMail;
    private String _EMailServer;
    private String _EMailDatabase;
    private String _EMailUsername;
    private String _EMailPassword;
    private String _EMailReplyTo;
    private String _EMailSignature;
    private String _calendarServer;
    private String _calendarUsername;
    private String _calendarPassword;
    private String _timeZone;
    private String _title;
    private FileAttachmentType _photo;
    private List _defaultACLEntryList = new ArrayList();
    private List _currentPositionList = new ArrayList();
    private UserPositionRefType _mainPosition;
    private List _substituteForList = new ArrayList();
    private boolean _isAway;
    private boolean _has_isAway;
    private UserRefType _substituteUser;
    private List _securityClearanceIDList = new ArrayList();
    private ACLDocumentRefType _organization;
    private String _organizationName;
    private String _location;
    private String _department;
    private boolean _disabled;
    private boolean _has_disabled;
    private List _phoneNumberList = new ArrayList();
    private EMailClientType _EMailClient;
    private static final long serialVersionUID = 15000L;

    public void addCurrentPosition(UserPositionRefType vCurrentPosition) throws IndexOutOfBoundsException {
        this._currentPositionList.add(vCurrentPosition);
    }

    public void addCurrentPosition(int index, UserPositionRefType vCurrentPosition) throws IndexOutOfBoundsException {
        this._currentPositionList.add(index, vCurrentPosition);
    }

    public void addDefaultACLEntry(ACLType vDefaultACLEntry) throws IndexOutOfBoundsException {
        this._defaultACLEntryList.add(vDefaultACLEntry);
    }

    public void addDefaultACLEntry(int index, ACLType vDefaultACLEntry) throws IndexOutOfBoundsException {
        this._defaultACLEntryList.add(index, vDefaultACLEntry);
    }

    public void addPhoneNumber(PhoneNumberType vPhoneNumber) throws IndexOutOfBoundsException {
        this._phoneNumberList.add(vPhoneNumber);
    }

    public void addPhoneNumber(int index, PhoneNumberType vPhoneNumber) throws IndexOutOfBoundsException {
        this._phoneNumberList.add(index, vPhoneNumber);
    }

    public void addSecurityClearanceID(String vSecurityClearanceID) throws IndexOutOfBoundsException {
        this._securityClearanceIDList.add(vSecurityClearanceID);
    }

    public void addSecurityClearanceID(int index, String vSecurityClearanceID) throws IndexOutOfBoundsException {
        this._securityClearanceIDList.add(index, vSecurityClearanceID);
    }

    public void addSubstituteFor(UserRefType vSubstituteFor) throws IndexOutOfBoundsException {
        this._substituteForList.add(vSubstituteFor);
    }

    public void addSubstituteFor(int index, UserRefType vSubstituteFor) throws IndexOutOfBoundsException {
        this._substituteForList.add(index, vSubstituteFor);
    }

    public void addUserRole(UserRoleRefType vUserRole) throws IndexOutOfBoundsException {
        this._userRoleList.add(vUserRole);
    }

    public void addUserRole(int index, UserRoleRefType vUserRole) throws IndexOutOfBoundsException {
        this._userRoleList.add(index, vUserRole);
    }

    public void deleteDisabled() {
        this._has_disabled = false;
    }

    public void deleteIsAway() {
        this._has_isAway = false;
    }

    public Enumeration enumerateCurrentPositions() {
        return Collections.enumeration(this._currentPositionList);
    }

    public Enumeration enumerateDefaultACLEntries() {
        return Collections.enumeration(this._defaultACLEntryList);
    }

    public Enumeration enumeratePhoneNumbers() {
        return Collections.enumeration(this._phoneNumberList);
    }

    public Enumeration enumerateSecurityClearanceIDs() {
        return Collections.enumeration(this._securityClearanceIDList);
    }

    public Enumeration enumerateSubstituteFors() {
        return Collections.enumeration(this._substituteForList);
    }

    public Enumeration enumerateUserRoles() {
        return Collections.enumeration(this._userRoleList);
    }

    public String getCalendarPassword() {
        return this._calendarPassword;
    }

    public String getCalendarServer() {
        return this._calendarServer;
    }

    public String getCalendarUsername() {
        return this._calendarUsername;
    }

    public UserPositionRefType getCurrentPosition(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._currentPositionList.size()) {
            throw new IndexOutOfBoundsException("getCurrentPosition: Index value '" + index + "' not in range [0.." + (this._currentPositionList.size() - 1) + "]");
        }
        return (UserPositionRefType)this._currentPositionList.get(index);
    }

    public UserPositionRefType[] getCurrentPositions() {
        UserPositionRefType[] array = new UserPositionRefType[]{};
        return this._currentPositionList.toArray(array);
    }

    public List getCurrentPositionsAsReference() {
        return this._currentPositionList;
    }

    public int getCurrentPositionsCount() {
        return this._currentPositionList.size();
    }

    public ACLType[] getDefaultACLEntries() {
        ACLType[] array = new ACLType[]{};
        return this._defaultACLEntryList.toArray(array);
    }

    public List getDefaultACLEntriesAsReference() {
        return this._defaultACLEntryList;
    }

    public int getDefaultACLEntriesCount() {
        return this._defaultACLEntryList.size();
    }

    public ACLType getDefaultACLEntry(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._defaultACLEntryList.size()) {
            throw new IndexOutOfBoundsException("getDefaultACLEntry: Index value '" + index + "' not in range [0.." + (this._defaultACLEntryList.size() - 1) + "]");
        }
        return (ACLType)this._defaultACLEntryList.get(index);
    }

    public String getDepartment() {
        return this._department;
    }

    public boolean getDisabled() {
        return this._disabled;
    }

    public String getEMail() {
        return this._EMail;
    }

    public EMailClientType getEMailClient() {
        return this._EMailClient;
    }

    public String getEMailDatabase() {
        return this._EMailDatabase;
    }

    public String getEMailPassword() {
        return this._EMailPassword;
    }

    public String getEMailReplyTo() {
        return this._EMailReplyTo;
    }

    public String getEMailServer() {
        return this._EMailServer;
    }

    public String getEMailSignature() {
        return this._EMailSignature;
    }

    public String getEMailUsername() {
        return this._EMailUsername;
    }

    public String getFullName() {
        return this._fullName;
    }

    public boolean getIsAway() {
        return this._isAway;
    }

    public String getJobTitle() {
        return this._jobTitle;
    }

    public ListValueRefType getLanguage() {
        return this._language;
    }

    public String getLocation() {
        return this._location;
    }

    public String getLoginName() {
        return this._loginName;
    }

    public UserPositionRefType getMainPosition() {
        return this._mainPosition;
    }

    public NameType getName() {
        return this._name;
    }

    public ACLDocumentRefType getOrganization() {
        return this._organization;
    }

    public String getOrganizationName() {
        return this._organizationName;
    }

    public String getPassword() {
        return this._password;
    }

    public PhoneNumberType getPhoneNumber(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._phoneNumberList.size()) {
            throw new IndexOutOfBoundsException("getPhoneNumber: Index value '" + index + "' not in range [0.." + (this._phoneNumberList.size() - 1) + "]");
        }
        return (PhoneNumberType)this._phoneNumberList.get(index);
    }

    public PhoneNumberType[] getPhoneNumbers() {
        PhoneNumberType[] array = new PhoneNumberType[]{};
        return this._phoneNumberList.toArray(array);
    }

    public List getPhoneNumbersAsReference() {
        return this._phoneNumberList;
    }

    public int getPhoneNumbersCount() {
        return this._phoneNumberList.size();
    }

    public FileAttachmentType getPhoto() {
        return this._photo;
    }

    public String getSecurityClearanceID(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._securityClearanceIDList.size()) {
            throw new IndexOutOfBoundsException("getSecurityClearanceID: Index value '" + index + "' not in range [0.." + (this._securityClearanceIDList.size() - 1) + "]");
        }
        return (String)this._securityClearanceIDList.get(index);
    }

    public String[] getSecurityClearanceIDs() {
        String[] array = new String[]{};
        return this._securityClearanceIDList.toArray(array);
    }

    public List getSecurityClearanceIDsAsReference() {
        return this._securityClearanceIDList;
    }

    public int getSecurityClearanceIDsCount() {
        return this._securityClearanceIDList.size();
    }

    public UserRefType getSubstituteFor(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._substituteForList.size()) {
            throw new IndexOutOfBoundsException("getSubstituteFor: Index value '" + index + "' not in range [0.." + (this._substituteForList.size() - 1) + "]");
        }
        return (UserRefType)this._substituteForList.get(index);
    }

    public UserRefType[] getSubstituteFors() {
        UserRefType[] array = new UserRefType[]{};
        return this._substituteForList.toArray(array);
    }

    public List getSubstituteForsAsReference() {
        return this._substituteForList;
    }

    public int getSubstituteForsCount() {
        return this._substituteForList.size();
    }

    public UserRefType getSubstituteUser() {
        return this._substituteUser;
    }

    public String getTimeZone() {
        return this._timeZone;
    }

    public String getTitle() {
        return this._title;
    }

    public UserRoleRefType getUserRole(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._userRoleList.size()) {
            throw new IndexOutOfBoundsException("getUserRole: Index value '" + index + "' not in range [0.." + (this._userRoleList.size() - 1) + "]");
        }
        return (UserRoleRefType)this._userRoleList.get(index);
    }

    public UserRoleRefType[] getUserRoles() {
        UserRoleRefType[] array = new UserRoleRefType[]{};
        return this._userRoleList.toArray(array);
    }

    public List getUserRolesAsReference() {
        return this._userRoleList;
    }

    public int getUserRolesCount() {
        return this._userRoleList.size();
    }

    public boolean hasDisabled() {
        return this._has_disabled;
    }

    public boolean hasIsAway() {
        return this._has_isAway;
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public boolean isIsAway() {
        return this._isAway;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateCurrentPositions() {
        return this._currentPositionList.iterator();
    }

    public Iterator iterateDefaultACLEntries() {
        return this._defaultACLEntryList.iterator();
    }

    public Iterator iteratePhoneNumbers() {
        return this._phoneNumberList.iterator();
    }

    public Iterator iterateSecurityClearanceIDs() {
        return this._securityClearanceIDList.iterator();
    }

    public Iterator iterateSubstituteFors() {
        return this._substituteForList.iterator();
    }

    public Iterator iterateUserRoles() {
        return this._userRoleList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAllCurrentPositions() {
        this._currentPositionList.clear();
    }

    public void removeAllDefaultACLEntries() {
        this._defaultACLEntryList.clear();
    }

    public void removeAllPhoneNumbers() {
        this._phoneNumberList.clear();
    }

    public void removeAllSecurityClearanceIDs() {
        this._securityClearanceIDList.clear();
    }

    public void removeAllSubstituteFors() {
        this._substituteForList.clear();
    }

    public void removeAllUserRoles() {
        this._userRoleList.clear();
    }

    public boolean removeCurrentPosition(UserPositionRefType vCurrentPosition) {
        boolean removed = this._currentPositionList.remove(vCurrentPosition);
        return removed;
    }

    public UserPositionRefType removeCurrentPositionAt(int index) {
        Object obj = this._currentPositionList.remove(index);
        return (UserPositionRefType)obj;
    }

    public boolean removeDefaultACLEntry(ACLType vDefaultACLEntry) {
        boolean removed = this._defaultACLEntryList.remove(vDefaultACLEntry);
        return removed;
    }

    public ACLType removeDefaultACLEntryAt(int index) {
        Object obj = this._defaultACLEntryList.remove(index);
        return (ACLType)obj;
    }

    public boolean removePhoneNumber(PhoneNumberType vPhoneNumber) {
        boolean removed = this._phoneNumberList.remove(vPhoneNumber);
        return removed;
    }

    public PhoneNumberType removePhoneNumberAt(int index) {
        Object obj = this._phoneNumberList.remove(index);
        return (PhoneNumberType)obj;
    }

    public boolean removeSecurityClearanceID(String vSecurityClearanceID) {
        boolean removed = this._securityClearanceIDList.remove(vSecurityClearanceID);
        return removed;
    }

    public String removeSecurityClearanceIDAt(int index) {
        Object obj = this._securityClearanceIDList.remove(index);
        return (String)obj;
    }

    public boolean removeSubstituteFor(UserRefType vSubstituteFor) {
        boolean removed = this._substituteForList.remove(vSubstituteFor);
        return removed;
    }

    public UserRefType removeSubstituteForAt(int index) {
        Object obj = this._substituteForList.remove(index);
        return (UserRefType)obj;
    }

    public boolean removeUserRole(UserRoleRefType vUserRole) {
        boolean removed = this._userRoleList.remove(vUserRole);
        return removed;
    }

    public UserRoleRefType removeUserRoleAt(int index) {
        Object obj = this._userRoleList.remove(index);
        return (UserRoleRefType)obj;
    }

    public void setCalendarPassword(String calendarPassword) {
        this._calendarPassword = calendarPassword;
    }

    public void setCalendarServer(String calendarServer) {
        this._calendarServer = calendarServer;
    }

    public void setCalendarUsername(String calendarUsername) {
        this._calendarUsername = calendarUsername;
    }

    public void setCurrentPosition(int index, UserPositionRefType vCurrentPosition) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._currentPositionList.size()) {
            throw new IndexOutOfBoundsException("setCurrentPosition: Index value '" + index + "' not in range [0.." + (this._currentPositionList.size() - 1) + "]");
        }
        this._currentPositionList.set(index, vCurrentPosition);
    }

    public void setCurrentPositions(UserPositionRefType[] vCurrentPositionArray) {
        this._currentPositionList.clear();
        for (int i = 0; i < vCurrentPositionArray.length; ++i) {
            this._currentPositionList.add(vCurrentPositionArray[i]);
        }
    }

    public void setCurrentPositions(List vCurrentPositionList) {
        this._currentPositionList.clear();
        this._currentPositionList.addAll(vCurrentPositionList);
    }

    public void setCurrentPositionsAsReference(List currentPositionList) {
        this._currentPositionList = currentPositionList;
    }

    public void setDefaultACLEntries(ACLType[] vDefaultACLEntryArray) {
        this._defaultACLEntryList.clear();
        for (int i = 0; i < vDefaultACLEntryArray.length; ++i) {
            this._defaultACLEntryList.add(vDefaultACLEntryArray[i]);
        }
    }

    public void setDefaultACLEntries(List vDefaultACLEntryList) {
        this._defaultACLEntryList.clear();
        this._defaultACLEntryList.addAll(vDefaultACLEntryList);
    }

    public void setDefaultACLEntriesAsReference(List defaultACLEntryList) {
        this._defaultACLEntryList = defaultACLEntryList;
    }

    public void setDefaultACLEntry(int index, ACLType vDefaultACLEntry) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._defaultACLEntryList.size()) {
            throw new IndexOutOfBoundsException("setDefaultACLEntry: Index value '" + index + "' not in range [0.." + (this._defaultACLEntryList.size() - 1) + "]");
        }
        this._defaultACLEntryList.set(index, vDefaultACLEntry);
    }

    public void setDepartment(String department) {
        this._department = department;
    }

    public void setDisabled(boolean disabled) {
        this._disabled = disabled;
        this._has_disabled = true;
    }

    public void setEMail(String EMail2) {
        this._EMail = EMail2;
    }

    public void setEMailClient(EMailClientType EMailClient) {
        this._EMailClient = EMailClient;
    }

    public void setEMailDatabase(String EMailDatabase) {
        this._EMailDatabase = EMailDatabase;
    }

    public void setEMailPassword(String EMailPassword) {
        this._EMailPassword = EMailPassword;
    }

    public void setEMailReplyTo(String EMailReplyTo) {
        this._EMailReplyTo = EMailReplyTo;
    }

    public void setEMailServer(String EMailServer) {
        this._EMailServer = EMailServer;
    }

    public void setEMailSignature(String EMailSignature) {
        this._EMailSignature = EMailSignature;
    }

    public void setEMailUsername(String EMailUsername) {
        this._EMailUsername = EMailUsername;
    }

    public void setFullName(String fullName) {
        this._fullName = fullName;
    }

    public void setIsAway(boolean isAway) {
        this._isAway = isAway;
        this._has_isAway = true;
    }

    public void setJobTitle(String jobTitle) {
        this._jobTitle = jobTitle;
    }

    public void setLanguage(ListValueRefType language) {
        this._language = language;
    }

    public void setLocation(String location) {
        this._location = location;
    }

    public void setLoginName(String loginName) {
        this._loginName = loginName;
    }

    public void setMainPosition(UserPositionRefType mainPosition) {
        this._mainPosition = mainPosition;
        if (this._mainPosition != null) {
            this.mainPositionId = this._mainPosition.getID();
        }
    }

    public void setName(NameType name) {
        this._name = name;
    }

    public void setOrganization(ACLDocumentRefType organization) {
        this._organization = organization;
    }

    public void setOrganizationName(String organizationName) {
        this._organizationName = organizationName;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setPhoneNumber(int index, PhoneNumberType vPhoneNumber) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._phoneNumberList.size()) {
            throw new IndexOutOfBoundsException("setPhoneNumber: Index value '" + index + "' not in range [0.." + (this._phoneNumberList.size() - 1) + "]");
        }
        this._phoneNumberList.set(index, vPhoneNumber);
    }

    public void setPhoneNumbers(PhoneNumberType[] vPhoneNumberArray) {
        this._phoneNumberList.clear();
        for (int i = 0; i < vPhoneNumberArray.length; ++i) {
            this._phoneNumberList.add(vPhoneNumberArray[i]);
        }
    }

    public void setPhoneNumbers(List vPhoneNumberList) {
        this._phoneNumberList.clear();
        this._phoneNumberList.addAll(vPhoneNumberList);
    }

    public void setPhoneNumbersAsReference(List phoneNumberList) {
        this._phoneNumberList = phoneNumberList;
    }

    public void setPhoto(FileAttachmentType photo) {
        this._photo = photo;
    }

    public void setSecurityClearanceID(int index, String vSecurityClearanceID) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._securityClearanceIDList.size()) {
            throw new IndexOutOfBoundsException("setSecurityClearanceID: Index value '" + index + "' not in range [0.." + (this._securityClearanceIDList.size() - 1) + "]");
        }
        this._securityClearanceIDList.set(index, vSecurityClearanceID);
    }

    public void setSecurityClearanceIDs(String[] vSecurityClearanceIDArray) {
        this._securityClearanceIDList.clear();
        for (int i = 0; i < vSecurityClearanceIDArray.length; ++i) {
            this._securityClearanceIDList.add(vSecurityClearanceIDArray[i]);
        }
    }

    public void setSecurityClearanceIDs(List vSecurityClearanceIDList) {
        this._securityClearanceIDList.clear();
        this._securityClearanceIDList.addAll(vSecurityClearanceIDList);
    }

    public void setSecurityClearanceIDsAsReference(List securityClearanceIDList) {
        this._securityClearanceIDList = securityClearanceIDList;
    }

    public void setSubstituteFor(int index, UserRefType vSubstituteFor) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._substituteForList.size()) {
            throw new IndexOutOfBoundsException("setSubstituteFor: Index value '" + index + "' not in range [0.." + (this._substituteForList.size() - 1) + "]");
        }
        this._substituteForList.set(index, vSubstituteFor);
    }

    public void setSubstituteFors(UserRefType[] vSubstituteForArray) {
        this._substituteForList.clear();
        for (int i = 0; i < vSubstituteForArray.length; ++i) {
            this._substituteForList.add(vSubstituteForArray[i]);
        }
    }

    public void setSubstituteFors(List vSubstituteForList) {
        this._substituteForList.clear();
        this._substituteForList.addAll(vSubstituteForList);
    }

    public void setSubstituteForsAsReference(List substituteForList) {
        this._substituteForList = substituteForList;
    }

    public void setSubstituteUser(UserRefType substituteUser) {
        this._substituteUser = substituteUser;
    }

    public void setTimeZone(String timeZone) {
        this._timeZone = timeZone;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public void setUserRole(int index, UserRoleRefType vUserRole) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._userRoleList.size()) {
            throw new IndexOutOfBoundsException("setUserRole: Index value '" + index + "' not in range [0.." + (this._userRoleList.size() - 1) + "]");
        }
        this._userRoleList.set(index, vUserRole);
    }

    public void setUserRoles(UserRoleRefType[] vUserRoleArray) {
        this._userRoleList.clear();
        for (int i = 0; i < vUserRoleArray.length; ++i) {
            this._userRoleList.add(vUserRoleArray[i]);
        }
    }

    public void setUserRoles(List vUserRoleList) {
        this._userRoleList.clear();
        this._userRoleList.addAll(vUserRoleList);
    }

    public void setUserRolesAsReference(List userRoleList) {
        this._userRoleList = userRoleList;
    }

    public static ReferenceableObjectType unmarshalUserType(Reader reader) throws MarshalException, ValidationException {
        return (ReferenceableObjectType)Unmarshaller.unmarshal(UserType.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

