/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.ACLDocumentType;
import net.gopro.gdf.data.ReferenceableObjectType;
import net.gopro.gdf.data.UserPrivilegeType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class UserRoleType
extends ACLDocumentType
implements Serializable {
    private List _privilegieList = new ArrayList();
    private String _key;
    private static final long serialVersionUID = 15000L;

    public void addPrivilegie(UserPrivilegeType vPrivilegie) throws IndexOutOfBoundsException {
        this._privilegieList.add(vPrivilegie);
    }

    public void addPrivilegie(int index, UserPrivilegeType vPrivilegie) throws IndexOutOfBoundsException {
        this._privilegieList.add(index, vPrivilegie);
    }

    public Enumeration enumeratePrivilegies() {
        return Collections.enumeration(this._privilegieList);
    }

    public String getKey() {
        return this._key;
    }

    public UserPrivilegeType getPrivilegie(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._privilegieList.size()) {
            throw new IndexOutOfBoundsException("getPrivilegie: Index value '" + index + "' not in range [0.." + (this._privilegieList.size() - 1) + "]");
        }
        return (UserPrivilegeType)this._privilegieList.get(index);
    }

    public UserPrivilegeType[] getPrivilegies() {
        UserPrivilegeType[] array = new UserPrivilegeType[]{};
        return this._privilegieList.toArray(array);
    }

    public List getPrivilegiesAsReference() {
        return this._privilegieList;
    }

    public int getPrivilegiesCount() {
        return this._privilegieList.size();
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iteratePrivilegies() {
        return this._privilegieList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAllPrivilegies() {
        this._privilegieList.clear();
    }

    public boolean removePrivilegie(UserPrivilegeType vPrivilegie) {
        boolean removed = this._privilegieList.remove(vPrivilegie);
        return removed;
    }

    public UserPrivilegeType removePrivilegieAt(int index) {
        Object obj = this._privilegieList.remove(index);
        return (UserPrivilegeType)obj;
    }

    public void setKey(String key) {
        this._key = key;
    }

    public void setPrivilegie(int index, UserPrivilegeType vPrivilegie) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._privilegieList.size()) {
            throw new IndexOutOfBoundsException("setPrivilegie: Index value '" + index + "' not in range [0.." + (this._privilegieList.size() - 1) + "]");
        }
        this._privilegieList.set(index, vPrivilegie);
    }

    public void setPrivilegies(UserPrivilegeType[] vPrivilegieArray) {
        this._privilegieList.clear();
        for (int i = 0; i < vPrivilegieArray.length; ++i) {
            this._privilegieList.add(vPrivilegieArray[i]);
        }
    }

    public void setPrivilegies(List vPrivilegieList) {
        this._privilegieList.clear();
        this._privilegieList.addAll(vPrivilegieList);
    }

    public void setPrivilegiesAsReference(List privilegieList) {
        this._privilegieList = privilegieList;
    }

    public static ReferenceableObjectType unmarshalUserRoleType(Reader reader) throws MarshalException, ValidationException {
        return (ReferenceableObjectType)Unmarshaller.unmarshal(UserRoleType.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

