/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.ConfigDocumentType;
import net.gopro.gdf.data.ReferenceableObjectType;
import net.gopro.gdf.data.RoutingParticipantType;
import net.gopro.gdf.data.RoutingStepTemplateType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class RoutingTemplateType
extends ConfigDocumentType
implements Serializable {
    private String _description;
    private boolean _checkDocumentVersion;
    private boolean _has_checkDocumentVersion;
    private List _routingStepList = new ArrayList();
    private List _reviewManagerList = new ArrayList();
    private boolean _notifications;
    private boolean _has_notifications;
    private List _documentTypeFilterList = new ArrayList();
    private static final long serialVersionUID = 15000L;

    public void addDocumentTypeFilter(int vDocumentTypeFilter) throws IndexOutOfBoundsException {
        this._documentTypeFilterList.add(new Integer(vDocumentTypeFilter));
    }

    public void addDocumentTypeFilter(int index, int vDocumentTypeFilter) throws IndexOutOfBoundsException {
        this._documentTypeFilterList.add(index, new Integer(vDocumentTypeFilter));
    }

    public void addReviewManager(RoutingParticipantType vReviewManager) throws IndexOutOfBoundsException {
        this._reviewManagerList.add(vReviewManager);
    }

    public void addReviewManager(int index, RoutingParticipantType vReviewManager) throws IndexOutOfBoundsException {
        this._reviewManagerList.add(index, vReviewManager);
    }

    public void addRoutingStep(RoutingStepTemplateType vRoutingStep) throws IndexOutOfBoundsException {
        this._routingStepList.add(vRoutingStep);
    }

    public void addRoutingStep(int index, RoutingStepTemplateType vRoutingStep) throws IndexOutOfBoundsException {
        this._routingStepList.add(index, vRoutingStep);
    }

    public void deleteCheckDocumentVersion() {
        this._has_checkDocumentVersion = false;
    }

    public void deleteNotifications() {
        this._has_notifications = false;
    }

    public Enumeration enumerateDocumentTypeFilters() {
        return Collections.enumeration(this._documentTypeFilterList);
    }

    public Enumeration enumerateReviewManagers() {
        return Collections.enumeration(this._reviewManagerList);
    }

    public Enumeration enumerateRoutingSteps() {
        return Collections.enumeration(this._routingStepList);
    }

    public boolean getCheckDocumentVersion() {
        return this._checkDocumentVersion;
    }

    public String getDescription() {
        return this._description;
    }

    public int getDocumentTypeFilter(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._documentTypeFilterList.size()) {
            throw new IndexOutOfBoundsException("getDocumentTypeFilter: Index value '" + index + "' not in range [0.." + (this._documentTypeFilterList.size() - 1) + "]");
        }
        return (Integer)this._documentTypeFilterList.get(index);
    }

    public int[] getDocumentTypeFilters() {
        int size = this._documentTypeFilterList.size();
        int[] array = new int[size];
        Iterator iter = this._documentTypeFilterList.iterator();
        for (int index = 0; index < size; ++index) {
            array[index] = (Integer)iter.next();
        }
        return array;
    }

    public List getDocumentTypeFiltersAsReference() {
        return this._documentTypeFilterList;
    }

    public int getDocumentTypeFiltersCount() {
        return this._documentTypeFilterList.size();
    }

    public boolean getNotifications() {
        return this._notifications;
    }

    public RoutingParticipantType getReviewManager(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._reviewManagerList.size()) {
            throw new IndexOutOfBoundsException("getReviewManager: Index value '" + index + "' not in range [0.." + (this._reviewManagerList.size() - 1) + "]");
        }
        return (RoutingParticipantType)this._reviewManagerList.get(index);
    }

    public RoutingParticipantType[] getReviewManagers() {
        RoutingParticipantType[] array = new RoutingParticipantType[]{};
        return this._reviewManagerList.toArray(array);
    }

    public List getReviewManagersAsReference() {
        return this._reviewManagerList;
    }

    public int getReviewManagersCount() {
        return this._reviewManagerList.size();
    }

    public RoutingStepTemplateType getRoutingStep(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._routingStepList.size()) {
            throw new IndexOutOfBoundsException("getRoutingStep: Index value '" + index + "' not in range [0.." + (this._routingStepList.size() - 1) + "]");
        }
        return (RoutingStepTemplateType)this._routingStepList.get(index);
    }

    public RoutingStepTemplateType[] getRoutingSteps() {
        RoutingStepTemplateType[] array = new RoutingStepTemplateType[]{};
        return this._routingStepList.toArray(array);
    }

    public List getRoutingStepsAsReference() {
        return this._routingStepList;
    }

    public int getRoutingStepsCount() {
        return this._routingStepList.size();
    }

    public boolean hasCheckDocumentVersion() {
        return this._has_checkDocumentVersion;
    }

    public boolean hasNotifications() {
        return this._has_notifications;
    }

    public boolean isCheckDocumentVersion() {
        return this._checkDocumentVersion;
    }

    public boolean isNotifications() {
        return this._notifications;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateDocumentTypeFilters() {
        return this._documentTypeFilterList.iterator();
    }

    public Iterator iterateReviewManagers() {
        return this._reviewManagerList.iterator();
    }

    public Iterator iterateRoutingSteps() {
        return this._routingStepList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAllDocumentTypeFilters() {
        this._documentTypeFilterList.clear();
    }

    public void removeAllReviewManagers() {
        this._reviewManagerList.clear();
    }

    public void removeAllRoutingSteps() {
        this._routingStepList.clear();
    }

    public boolean removeDocumentTypeFilter(int vDocumentTypeFilter) {
        boolean removed = this._documentTypeFilterList.remove(new Integer(vDocumentTypeFilter));
        return removed;
    }

    public int removeDocumentTypeFilterAt(int index) {
        Object obj = this._documentTypeFilterList.remove(index);
        return (Integer)obj;
    }

    public boolean removeReviewManager(RoutingParticipantType vReviewManager) {
        boolean removed = this._reviewManagerList.remove(vReviewManager);
        return removed;
    }

    public RoutingParticipantType removeReviewManagerAt(int index) {
        Object obj = this._reviewManagerList.remove(index);
        return (RoutingParticipantType)obj;
    }

    public boolean removeRoutingStep(RoutingStepTemplateType vRoutingStep) {
        boolean removed = this._routingStepList.remove(vRoutingStep);
        return removed;
    }

    public RoutingStepTemplateType removeRoutingStepAt(int index) {
        Object obj = this._routingStepList.remove(index);
        return (RoutingStepTemplateType)obj;
    }

    public void setCheckDocumentVersion(boolean checkDocumentVersion) {
        this._checkDocumentVersion = checkDocumentVersion;
        this._has_checkDocumentVersion = true;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setDocumentTypeFilter(int index, int vDocumentTypeFilter) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._documentTypeFilterList.size()) {
            throw new IndexOutOfBoundsException("setDocumentTypeFilter: Index value '" + index + "' not in range [0.." + (this._documentTypeFilterList.size() - 1) + "]");
        }
        this._documentTypeFilterList.set(index, new Integer(vDocumentTypeFilter));
    }

    public void setDocumentTypeFilters(int[] vDocumentTypeFilterArray) {
        this._documentTypeFilterList.clear();
        for (int i = 0; i < vDocumentTypeFilterArray.length; ++i) {
            this._documentTypeFilterList.add(new Integer(vDocumentTypeFilterArray[i]));
        }
    }

    public void setDocumentTypeFilters(List vDocumentTypeFilterList) {
        this._documentTypeFilterList.clear();
        this._documentTypeFilterList.addAll(vDocumentTypeFilterList);
    }

    public void setDocumentTypeFiltersAsReference(List documentTypeFilterList) {
        this._documentTypeFilterList = documentTypeFilterList;
    }

    public void setNotifications(boolean notifications) {
        this._notifications = notifications;
        this._has_notifications = true;
    }

    public void setReviewManager(int index, RoutingParticipantType vReviewManager) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._reviewManagerList.size()) {
            throw new IndexOutOfBoundsException("setReviewManager: Index value '" + index + "' not in range [0.." + (this._reviewManagerList.size() - 1) + "]");
        }
        this._reviewManagerList.set(index, vReviewManager);
    }

    public void setReviewManagers(RoutingParticipantType[] vReviewManagerArray) {
        this._reviewManagerList.clear();
        for (int i = 0; i < vReviewManagerArray.length; ++i) {
            this._reviewManagerList.add(vReviewManagerArray[i]);
        }
    }

    public void setReviewManagers(List vReviewManagerList) {
        this._reviewManagerList.clear();
        this._reviewManagerList.addAll(vReviewManagerList);
    }

    public void setReviewManagersAsReference(List reviewManagerList) {
        this._reviewManagerList = reviewManagerList;
    }

    public void setRoutingStep(int index, RoutingStepTemplateType vRoutingStep) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._routingStepList.size()) {
            throw new IndexOutOfBoundsException("setRoutingStep: Index value '" + index + "' not in range [0.." + (this._routingStepList.size() - 1) + "]");
        }
        this._routingStepList.set(index, vRoutingStep);
    }

    public void setRoutingSteps(RoutingStepTemplateType[] vRoutingStepArray) {
        this._routingStepList.clear();
        for (int i = 0; i < vRoutingStepArray.length; ++i) {
            this._routingStepList.add(vRoutingStepArray[i]);
        }
    }

    public void setRoutingSteps(List vRoutingStepList) {
        this._routingStepList.clear();
        this._routingStepList.addAll(vRoutingStepList);
    }

    public void setRoutingStepsAsReference(List routingStepList) {
        this._routingStepList = routingStepList;
    }

    public static ReferenceableObjectType unmarshalRoutingTemplateType(Reader reader) throws MarshalException, ValidationException {
        return (ReferenceableObjectType)Unmarshaller.unmarshal(RoutingTemplateType.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

