/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.ACLDocumentRefType;
import net.gopro.gdf.data.ReferenceableObjectType;
import net.gopro.gdf.data.ResponseDocumentType;
import net.gopro.gdf.data.RoutingHistoryType;
import net.gopro.gdf.data.RoutingParticipantType;
import net.gopro.gdf.data.RoutingStepType;
import net.gopro.gdf.data.RoutingTemplateRefType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class RoutingSlipType
extends ResponseDocumentType
implements Serializable {
    private String _description;
    private RoutingTemplateRefType _routingTemplate;
    private String _currentStep;
    private List _routingHistoryList = new ArrayList();
    private List _routingStepList = new ArrayList();
    private List _reviewManagerList = new ArrayList();
    private List _currentParticipantList = new ArrayList();
    private String _currentDocumentID;
    private static final long serialVersionUID = 15000L;

    public void addCurrentParticipant(ACLDocumentRefType vCurrentParticipant) throws IndexOutOfBoundsException {
        this._currentParticipantList.add(vCurrentParticipant);
    }

    public void addCurrentParticipant(int index, ACLDocumentRefType vCurrentParticipant) throws IndexOutOfBoundsException {
        this._currentParticipantList.add(index, vCurrentParticipant);
    }

    public void addReviewManager(RoutingParticipantType vReviewManager) throws IndexOutOfBoundsException {
        this._reviewManagerList.add(vReviewManager);
    }

    public void addReviewManager(int index, RoutingParticipantType vReviewManager) throws IndexOutOfBoundsException {
        this._reviewManagerList.add(index, vReviewManager);
    }

    public void addRoutingHistory(RoutingHistoryType vRoutingHistory) throws IndexOutOfBoundsException {
        this._routingHistoryList.add(vRoutingHistory);
    }

    public void addRoutingHistory(int index, RoutingHistoryType vRoutingHistory) throws IndexOutOfBoundsException {
        this._routingHistoryList.add(index, vRoutingHistory);
    }

    public void addRoutingStep(RoutingStepType vRoutingStep) throws IndexOutOfBoundsException {
        this._routingStepList.add(vRoutingStep);
    }

    public void addRoutingStep(int index, RoutingStepType vRoutingStep) throws IndexOutOfBoundsException {
        this._routingStepList.add(index, vRoutingStep);
    }

    public Enumeration enumerateCurrentParticipants() {
        return Collections.enumeration(this._currentParticipantList);
    }

    public Enumeration enumerateReviewManagers() {
        return Collections.enumeration(this._reviewManagerList);
    }

    public Enumeration enumerateRoutingHistorys() {
        return Collections.enumeration(this._routingHistoryList);
    }

    public Enumeration enumerateRoutingSteps() {
        return Collections.enumeration(this._routingStepList);
    }

    public String getCurrentDocumentID() {
        return this._currentDocumentID;
    }

    public ACLDocumentRefType getCurrentParticipant(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._currentParticipantList.size()) {
            throw new IndexOutOfBoundsException("getCurrentParticipant: Index value '" + index + "' not in range [0.." + (this._currentParticipantList.size() - 1) + "]");
        }
        return (ACLDocumentRefType)this._currentParticipantList.get(index);
    }

    public ACLDocumentRefType[] getCurrentParticipants() {
        ACLDocumentRefType[] array = new ACLDocumentRefType[]{};
        return this._currentParticipantList.toArray(array);
    }

    public List getCurrentParticipantsAsReference() {
        return this._currentParticipantList;
    }

    public int getCurrentParticipantsCount() {
        return this._currentParticipantList.size();
    }

    public String getCurrentStep() {
        return this._currentStep;
    }

    public String getDescription() {
        return this._description;
    }

    public RoutingParticipantType getReviewManager(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._reviewManagerList.size()) {
            throw new IndexOutOfBoundsException("getReviewManager: Index value '" + index + "' not in range [0.." + (this._reviewManagerList.size() - 1) + "]");
        }
        return (RoutingParticipantType)this._reviewManagerList.get(index);
    }

    public RoutingParticipantType[] getReviewManagers() {
        RoutingParticipantType[] array = new RoutingParticipantType[]{};
        return this._reviewManagerList.toArray(array);
    }

    public List getReviewManagersAsReference() {
        return this._reviewManagerList;
    }

    public int getReviewManagersCount() {
        return this._reviewManagerList.size();
    }

    public RoutingHistoryType getRoutingHistory(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._routingHistoryList.size()) {
            throw new IndexOutOfBoundsException("getRoutingHistory: Index value '" + index + "' not in range [0.." + (this._routingHistoryList.size() - 1) + "]");
        }
        return (RoutingHistoryType)this._routingHistoryList.get(index);
    }

    public RoutingHistoryType[] getRoutingHistorys() {
        RoutingHistoryType[] array = new RoutingHistoryType[]{};
        return this._routingHistoryList.toArray(array);
    }

    public List getRoutingHistorysAsReference() {
        return this._routingHistoryList;
    }

    public int getRoutingHistorysCount() {
        return this._routingHistoryList.size();
    }

    public RoutingStepType getRoutingStep(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._routingStepList.size()) {
            throw new IndexOutOfBoundsException("getRoutingStep: Index value '" + index + "' not in range [0.." + (this._routingStepList.size() - 1) + "]");
        }
        return (RoutingStepType)this._routingStepList.get(index);
    }

    public RoutingStepType[] getRoutingSteps() {
        RoutingStepType[] array = new RoutingStepType[]{};
        return this._routingStepList.toArray(array);
    }

    public List getRoutingStepsAsReference() {
        return this._routingStepList;
    }

    public int getRoutingStepsCount() {
        return this._routingStepList.size();
    }

    public RoutingTemplateRefType getRoutingTemplate() {
        return this._routingTemplate;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateCurrentParticipants() {
        return this._currentParticipantList.iterator();
    }

    public Iterator iterateReviewManagers() {
        return this._reviewManagerList.iterator();
    }

    public Iterator iterateRoutingHistorys() {
        return this._routingHistoryList.iterator();
    }

    public Iterator iterateRoutingSteps() {
        return this._routingStepList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAllCurrentParticipants() {
        this._currentParticipantList.clear();
    }

    public void removeAllReviewManagers() {
        this._reviewManagerList.clear();
    }

    public void removeAllRoutingHistorys() {
        this._routingHistoryList.clear();
    }

    public void removeAllRoutingSteps() {
        this._routingStepList.clear();
    }

    public boolean removeCurrentParticipant(ACLDocumentRefType vCurrentParticipant) {
        boolean removed = this._currentParticipantList.remove(vCurrentParticipant);
        return removed;
    }

    public ACLDocumentRefType removeCurrentParticipantAt(int index) {
        Object obj = this._currentParticipantList.remove(index);
        return (ACLDocumentRefType)obj;
    }

    public boolean removeReviewManager(RoutingParticipantType vReviewManager) {
        boolean removed = this._reviewManagerList.remove(vReviewManager);
        return removed;
    }

    public RoutingParticipantType removeReviewManagerAt(int index) {
        Object obj = this._reviewManagerList.remove(index);
        return (RoutingParticipantType)obj;
    }

    public boolean removeRoutingHistory(RoutingHistoryType vRoutingHistory) {
        boolean removed = this._routingHistoryList.remove(vRoutingHistory);
        return removed;
    }

    public RoutingHistoryType removeRoutingHistoryAt(int index) {
        Object obj = this._routingHistoryList.remove(index);
        return (RoutingHistoryType)obj;
    }

    public boolean removeRoutingStep(RoutingStepType vRoutingStep) {
        boolean removed = this._routingStepList.remove(vRoutingStep);
        return removed;
    }

    public RoutingStepType removeRoutingStepAt(int index) {
        Object obj = this._routingStepList.remove(index);
        return (RoutingStepType)obj;
    }

    public void setCurrentDocumentID(String currentDocumentID) {
        this._currentDocumentID = currentDocumentID;
    }

    public void setCurrentParticipant(int index, ACLDocumentRefType vCurrentParticipant) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._currentParticipantList.size()) {
            throw new IndexOutOfBoundsException("setCurrentParticipant: Index value '" + index + "' not in range [0.." + (this._currentParticipantList.size() - 1) + "]");
        }
        this._currentParticipantList.set(index, vCurrentParticipant);
    }

    public void setCurrentParticipants(ACLDocumentRefType[] vCurrentParticipantArray) {
        this._currentParticipantList.clear();
        for (int i = 0; i < vCurrentParticipantArray.length; ++i) {
            this._currentParticipantList.add(vCurrentParticipantArray[i]);
        }
    }

    public void setCurrentParticipants(List vCurrentParticipantList) {
        this._currentParticipantList.clear();
        this._currentParticipantList.addAll(vCurrentParticipantList);
    }

    public void setCurrentParticipantsAsReference(List currentParticipantList) {
        this._currentParticipantList = currentParticipantList;
    }

    public void setCurrentStep(String currentStep) {
        this._currentStep = currentStep;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setReviewManager(int index, RoutingParticipantType vReviewManager) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._reviewManagerList.size()) {
            throw new IndexOutOfBoundsException("setReviewManager: Index value '" + index + "' not in range [0.." + (this._reviewManagerList.size() - 1) + "]");
        }
        this._reviewManagerList.set(index, vReviewManager);
    }

    public void setReviewManagers(RoutingParticipantType[] vReviewManagerArray) {
        this._reviewManagerList.clear();
        for (int i = 0; i < vReviewManagerArray.length; ++i) {
            this._reviewManagerList.add(vReviewManagerArray[i]);
        }
    }

    public void setReviewManagers(List vReviewManagerList) {
        this._reviewManagerList.clear();
        this._reviewManagerList.addAll(vReviewManagerList);
    }

    public void setReviewManagersAsReference(List reviewManagerList) {
        this._reviewManagerList = reviewManagerList;
    }

    public void setRoutingHistory(int index, RoutingHistoryType vRoutingHistory) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._routingHistoryList.size()) {
            throw new IndexOutOfBoundsException("setRoutingHistory: Index value '" + index + "' not in range [0.." + (this._routingHistoryList.size() - 1) + "]");
        }
        this._routingHistoryList.set(index, vRoutingHistory);
    }

    public void setRoutingHistorys(RoutingHistoryType[] vRoutingHistoryArray) {
        this._routingHistoryList.clear();
        for (int i = 0; i < vRoutingHistoryArray.length; ++i) {
            this._routingHistoryList.add(vRoutingHistoryArray[i]);
        }
    }

    public void setRoutingHistorys(List vRoutingHistoryList) {
        this._routingHistoryList.clear();
        this._routingHistoryList.addAll(vRoutingHistoryList);
    }

    public void setRoutingHistorysAsReference(List routingHistoryList) {
        this._routingHistoryList = routingHistoryList;
    }

    public void setRoutingStep(int index, RoutingStepType vRoutingStep) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._routingStepList.size()) {
            throw new IndexOutOfBoundsException("setRoutingStep: Index value '" + index + "' not in range [0.." + (this._routingStepList.size() - 1) + "]");
        }
        this._routingStepList.set(index, vRoutingStep);
    }

    public void setRoutingSteps(RoutingStepType[] vRoutingStepArray) {
        this._routingStepList.clear();
        for (int i = 0; i < vRoutingStepArray.length; ++i) {
            this._routingStepList.add(vRoutingStepArray[i]);
        }
    }

    public void setRoutingSteps(List vRoutingStepList) {
        this._routingStepList.clear();
        this._routingStepList.addAll(vRoutingStepList);
    }

    public void setRoutingStepsAsReference(List routingStepList) {
        this._routingStepList = routingStepList;
    }

    public void setRoutingTemplate(RoutingTemplateRefType routingTemplate) {
        this._routingTemplate = routingTemplate;
    }

    public static ReferenceableObjectType unmarshalRoutingSlipType(Reader reader) throws MarshalException, ValidationException {
        return (ReferenceableObjectType)Unmarshaller.unmarshal(RoutingSlipType.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

