/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.ReferenceableObjectType;
import net.gopro.gdf.data.RoutingParticipantType;
import net.gopro.gdf.data.types.ActionType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class RoutingActionType
extends ReferenceableObjectType
implements Serializable {
    private RoutingParticipantType _participant;
    private ActionType _actionType;
    private List _responsList = new ArrayList();
    private String _parentID;
    private static final long serialVersionUID = 15000L;

    public void addRespons(String vRespons) throws IndexOutOfBoundsException {
        this._responsList.add(vRespons);
    }

    public void addRespons(int index, String vRespons) throws IndexOutOfBoundsException {
        this._responsList.add(index, vRespons);
    }

    public Enumeration enumerateResponses() {
        return Collections.enumeration(this._responsList);
    }

    public ActionType getActionType() {
        return this._actionType;
    }

    public String getParentID() {
        return this._parentID;
    }

    public RoutingParticipantType getParticipant() {
        return this._participant;
    }

    public String getRespons(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._responsList.size()) {
            throw new IndexOutOfBoundsException("getRespons: Index value '" + index + "' not in range [0.." + (this._responsList.size() - 1) + "]");
        }
        return (String)this._responsList.get(index);
    }

    public String[] getResponses() {
        String[] array = new String[]{};
        return this._responsList.toArray(array);
    }

    public List getResponsesAsReference() {
        return this._responsList;
    }

    public int getResponsesCount() {
        return this._responsList.size();
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateResponses() {
        return this._responsList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAllResponses() {
        this._responsList.clear();
    }

    public boolean removeRespons(String vRespons) {
        boolean removed = this._responsList.remove(vRespons);
        return removed;
    }

    public String removeResponsAt(int index) {
        Object obj = this._responsList.remove(index);
        return (String)obj;
    }

    public void setActionType(ActionType actionType) {
        this._actionType = actionType;
    }

    public void setParentID(String parentID) {
        this._parentID = parentID;
    }

    public void setParticipant(RoutingParticipantType participant) {
        this._participant = participant;
    }

    public void setRespons(int index, String vRespons) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._responsList.size()) {
            throw new IndexOutOfBoundsException("setRespons: Index value '" + index + "' not in range [0.." + (this._responsList.size() - 1) + "]");
        }
        this._responsList.set(index, vRespons);
    }

    public void setResponses(String[] vResponsArray) {
        this._responsList.clear();
        for (int i = 0; i < vResponsArray.length; ++i) {
            this._responsList.add(vResponsArray[i]);
        }
    }

    public void setResponses(List vResponsList) {
        this._responsList.clear();
        this._responsList.addAll(vResponsList);
    }

    public void setResponsesAsReference(List responsList) {
        this._responsList = responsList;
    }

    public static ReferenceableObjectType unmarshalRoutingActionType(Reader reader) throws MarshalException, ValidationException {
        return (ReferenceableObjectType)Unmarshaller.unmarshal(RoutingActionType.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

