/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.FileAttachmentType;
import net.gopro.gdf.data.ReferenceableObjectType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class ReadOnlyDocumentType
extends ReferenceableObjectType
implements Serializable {
    private boolean _isAttachment;
    private boolean _has_isAttachment;
    private String _sourceDocumentID;
    private List _attachmentList = new ArrayList();
    private Date _creationDate;
    private static final long serialVersionUID = 15000L;

    public void addAttachment(FileAttachmentType vAttachment) throws IndexOutOfBoundsException {
        this._attachmentList.add(vAttachment);
    }

    public void addAttachment(int index, FileAttachmentType vAttachment) throws IndexOutOfBoundsException {
        this._attachmentList.add(index, vAttachment);
    }

    public void deleteIsAttachment() {
        this._has_isAttachment = false;
    }

    public Enumeration enumerateAttachments() {
        return Collections.enumeration(this._attachmentList);
    }

    public FileAttachmentType getAttachment(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._attachmentList.size()) {
            throw new IndexOutOfBoundsException("getAttachment: Index value '" + index + "' not in range [0.." + (this._attachmentList.size() - 1) + "]");
        }
        return (FileAttachmentType)this._attachmentList.get(index);
    }

    public FileAttachmentType[] getAttachments() {
        FileAttachmentType[] array = new FileAttachmentType[]{};
        return this._attachmentList.toArray(array);
    }

    public List getAttachmentsAsReference() {
        return this._attachmentList;
    }

    public int getAttachmentsCount() {
        return this._attachmentList.size();
    }

    public Date getCreationDate() {
        return this._creationDate;
    }

    public boolean getIsAttachment() {
        return this._isAttachment;
    }

    public String getSourceDocumentID() {
        return this._sourceDocumentID;
    }

    public boolean hasIsAttachment() {
        return this._has_isAttachment;
    }

    public boolean isIsAttachment() {
        return this._isAttachment;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateAttachments() {
        return this._attachmentList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAllAttachments() {
        this._attachmentList.clear();
    }

    public boolean removeAttachment(FileAttachmentType vAttachment) {
        boolean removed = this._attachmentList.remove(vAttachment);
        return removed;
    }

    public FileAttachmentType removeAttachmentAt(int index) {
        Object obj = this._attachmentList.remove(index);
        return (FileAttachmentType)obj;
    }

    public void setAttachment(int index, FileAttachmentType vAttachment) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._attachmentList.size()) {
            throw new IndexOutOfBoundsException("setAttachment: Index value '" + index + "' not in range [0.." + (this._attachmentList.size() - 1) + "]");
        }
        this._attachmentList.set(index, vAttachment);
    }

    public void setAttachments(FileAttachmentType[] vAttachmentArray) {
        this._attachmentList.clear();
        for (int i = 0; i < vAttachmentArray.length; ++i) {
            this._attachmentList.add(vAttachmentArray[i]);
        }
    }

    public void setAttachments(List vAttachmentList) {
        this._attachmentList.clear();
        this._attachmentList.addAll(vAttachmentList);
    }

    public void setAttachmentsAsReference(List attachmentList) {
        this._attachmentList = attachmentList;
    }

    public void setCreationDate(Date creationDate) {
        this._creationDate = creationDate;
    }

    public void setIsAttachment(boolean isAttachment) {
        this._isAttachment = isAttachment;
        this._has_isAttachment = true;
    }

    public void setSourceDocumentID(String sourceDocumentID) {
        this._sourceDocumentID = sourceDocumentID;
    }

    public static ReferenceableObjectType unmarshalReadOnlyDocumentType(Reader reader) throws MarshalException, ValidationException {
        return (ReferenceableObjectType)Unmarshaller.unmarshal(ReadOnlyDocumentType.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

