/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.FilterExpressionType;
import net.gopro.gdf.data.ObjectBaseType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class PropertyFilterType
extends ObjectBaseType
implements Serializable {
    private List _filterList = new ArrayList();
    private static final long serialVersionUID = 15000L;

    public void addFilter(FilterExpressionType vFilter) throws IndexOutOfBoundsException {
        this._filterList.add(vFilter);
    }

    public void addFilter(int index, FilterExpressionType vFilter) throws IndexOutOfBoundsException {
        this._filterList.add(index, vFilter);
    }

    public Enumeration enumerateFilters() {
        return Collections.enumeration(this._filterList);
    }

    public FilterExpressionType getFilter(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._filterList.size()) {
            throw new IndexOutOfBoundsException("getFilter: Index value '" + index + "' not in range [0.." + (this._filterList.size() - 1) + "]");
        }
        return (FilterExpressionType)this._filterList.get(index);
    }

    public FilterExpressionType[] getFilters() {
        FilterExpressionType[] array = new FilterExpressionType[]{};
        return this._filterList.toArray(array);
    }

    public List getFiltersAsReference() {
        return this._filterList;
    }

    public int getFiltersCount() {
        return this._filterList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateFilters() {
        return this._filterList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAllFilters() {
        this._filterList.clear();
    }

    public boolean removeFilter(FilterExpressionType vFilter) {
        boolean removed = this._filterList.remove(vFilter);
        return removed;
    }

    public FilterExpressionType removeFilterAt(int index) {
        Object obj = this._filterList.remove(index);
        return (FilterExpressionType)obj;
    }

    public void setFilter(int index, FilterExpressionType vFilter) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._filterList.size()) {
            throw new IndexOutOfBoundsException("setFilter: Index value '" + index + "' not in range [0.." + (this._filterList.size() - 1) + "]");
        }
        this._filterList.set(index, vFilter);
    }

    public void setFilters(FilterExpressionType[] vFilterArray) {
        this._filterList.clear();
        for (int i = 0; i < vFilterArray.length; ++i) {
            this._filterList.add(vFilterArray[i]);
        }
    }

    public void setFilters(List vFilterList) {
        this._filterList.clear();
        this._filterList.addAll(vFilterList);
    }

    public void setFiltersAsReference(List filterList) {
        this._filterList = filterList;
    }

    public static PropertyFilterType unmarshalPropertyFilterType(Reader reader) throws MarshalException, ValidationException {
        return (PropertyFilterType)Unmarshaller.unmarshal(PropertyFilterType.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

