/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.ACLDocumentRefType;
import net.gopro.gdf.data.CaseTemplateRefType;
import net.gopro.gdf.data.ConfigDocumentType;
import net.gopro.gdf.data.ListRefType;
import net.gopro.gdf.data.ListValueRefType;
import net.gopro.gdf.data.PhaseTemplateRefType;
import net.gopro.gdf.data.ReferenceableObjectType;
import net.gopro.gdf.data.TaskTemplateType;
import net.gopro.gdf.data.UserRefType;
import net.gopro.gdf.data.types.DefaultWorkerType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class PhaseTemplateType
extends ConfigDocumentType
implements Serializable {
    private DefaultWorkerType _defaultWorkerType;
    private ACLDocumentRefType _defaultWorker;
    private ListRefType _statusListRef;
    private int _defaultLifeTime;
    private boolean _has_defaultLifeTime;
    private CaseTemplateRefType _caseTemplate;
    private List _defaultOtherEmployeeList = new ArrayList();
    private String _customForm;
    private String _description;
    private PhaseTemplateRefType _precedingPhase;
    private ListValueRefType _activationStatus;
    private List _taskTemplateList = new ArrayList();
    private String _workflowDefinition;
    private boolean _manualCreate = false;
    private boolean _has_manualCreate;
    private static final long serialVersionUID = 15000L;

    public void addDefaultOtherEmployee(UserRefType vDefaultOtherEmployee) throws IndexOutOfBoundsException {
        this._defaultOtherEmployeeList.add(vDefaultOtherEmployee);
    }

    public void addDefaultOtherEmployee(int index, UserRefType vDefaultOtherEmployee) throws IndexOutOfBoundsException {
        this._defaultOtherEmployeeList.add(index, vDefaultOtherEmployee);
    }

    public void addTaskTemplate(TaskTemplateType vTaskTemplate) throws IndexOutOfBoundsException {
        this._taskTemplateList.add(vTaskTemplate);
    }

    public void addTaskTemplate(int index, TaskTemplateType vTaskTemplate) throws IndexOutOfBoundsException {
        this._taskTemplateList.add(index, vTaskTemplate);
    }

    public void deleteDefaultLifeTime() {
        this._has_defaultLifeTime = false;
    }

    public void deleteManualCreate() {
        this._has_manualCreate = false;
    }

    public Enumeration enumerateDefaultOtherEmployees() {
        return Collections.enumeration(this._defaultOtherEmployeeList);
    }

    public Enumeration enumerateTaskTemplates() {
        return Collections.enumeration(this._taskTemplateList);
    }

    public ListValueRefType getActivationStatus() {
        return this._activationStatus;
    }

    public CaseTemplateRefType getCaseTemplate() {
        return this._caseTemplate;
    }

    public String getCustomForm() {
        return this._customForm;
    }

    public int getDefaultLifeTime() {
        return this._defaultLifeTime;
    }

    public UserRefType getDefaultOtherEmployee(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._defaultOtherEmployeeList.size()) {
            throw new IndexOutOfBoundsException("getDefaultOtherEmployee: Index value '" + index + "' not in range [0.." + (this._defaultOtherEmployeeList.size() - 1) + "]");
        }
        return (UserRefType)this._defaultOtherEmployeeList.get(index);
    }

    public UserRefType[] getDefaultOtherEmployees() {
        UserRefType[] array = new UserRefType[]{};
        return this._defaultOtherEmployeeList.toArray(array);
    }

    public List getDefaultOtherEmployeesAsReference() {
        return this._defaultOtherEmployeeList;
    }

    public int getDefaultOtherEmployeesCount() {
        return this._defaultOtherEmployeeList.size();
    }

    public ACLDocumentRefType getDefaultWorker() {
        return this._defaultWorker;
    }

    public DefaultWorkerType getDefaultWorkerType() {
        return this._defaultWorkerType;
    }

    public String getDescription() {
        return this._description;
    }

    public boolean getManualCreate() {
        return this._manualCreate;
    }

    public PhaseTemplateRefType getPrecedingPhase() {
        return this._precedingPhase;
    }

    public ListRefType getStatusListRef() {
        return this._statusListRef;
    }

    public TaskTemplateType getTaskTemplate(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._taskTemplateList.size()) {
            throw new IndexOutOfBoundsException("getTaskTemplate: Index value '" + index + "' not in range [0.." + (this._taskTemplateList.size() - 1) + "]");
        }
        return (TaskTemplateType)this._taskTemplateList.get(index);
    }

    public TaskTemplateType[] getTaskTemplates() {
        TaskTemplateType[] array = new TaskTemplateType[]{};
        return this._taskTemplateList.toArray(array);
    }

    public List getTaskTemplatesAsReference() {
        return this._taskTemplateList;
    }

    public int getTaskTemplatesCount() {
        return this._taskTemplateList.size();
    }

    public String getWorkflowDefinition() {
        return this._workflowDefinition;
    }

    public boolean hasDefaultLifeTime() {
        return this._has_defaultLifeTime;
    }

    public boolean hasManualCreate() {
        return this._has_manualCreate;
    }

    public boolean isManualCreate() {
        return this._manualCreate;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateDefaultOtherEmployees() {
        return this._defaultOtherEmployeeList.iterator();
    }

    public Iterator iterateTaskTemplates() {
        return this._taskTemplateList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAllDefaultOtherEmployees() {
        this._defaultOtherEmployeeList.clear();
    }

    public void removeAllTaskTemplates() {
        this._taskTemplateList.clear();
    }

    public boolean removeDefaultOtherEmployee(UserRefType vDefaultOtherEmployee) {
        boolean removed = this._defaultOtherEmployeeList.remove(vDefaultOtherEmployee);
        return removed;
    }

    public UserRefType removeDefaultOtherEmployeeAt(int index) {
        Object obj = this._defaultOtherEmployeeList.remove(index);
        return (UserRefType)obj;
    }

    public boolean removeTaskTemplate(TaskTemplateType vTaskTemplate) {
        boolean removed = this._taskTemplateList.remove(vTaskTemplate);
        return removed;
    }

    public TaskTemplateType removeTaskTemplateAt(int index) {
        Object obj = this._taskTemplateList.remove(index);
        return (TaskTemplateType)obj;
    }

    public void setActivationStatus(ListValueRefType activationStatus) {
        this._activationStatus = activationStatus;
    }

    public void setCaseTemplate(CaseTemplateRefType caseTemplate) {
        this._caseTemplate = caseTemplate;
    }

    public void setCustomForm(String customForm) {
        this._customForm = customForm;
    }

    public void setDefaultLifeTime(int defaultLifeTime) {
        this._defaultLifeTime = defaultLifeTime;
        this._has_defaultLifeTime = true;
    }

    public void setDefaultOtherEmployee(int index, UserRefType vDefaultOtherEmployee) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._defaultOtherEmployeeList.size()) {
            throw new IndexOutOfBoundsException("setDefaultOtherEmployee: Index value '" + index + "' not in range [0.." + (this._defaultOtherEmployeeList.size() - 1) + "]");
        }
        this._defaultOtherEmployeeList.set(index, vDefaultOtherEmployee);
    }

    public void setDefaultOtherEmployees(UserRefType[] vDefaultOtherEmployeeArray) {
        this._defaultOtherEmployeeList.clear();
        for (int i = 0; i < vDefaultOtherEmployeeArray.length; ++i) {
            this._defaultOtherEmployeeList.add(vDefaultOtherEmployeeArray[i]);
        }
    }

    public void setDefaultOtherEmployees(List vDefaultOtherEmployeeList) {
        this._defaultOtherEmployeeList.clear();
        this._defaultOtherEmployeeList.addAll(vDefaultOtherEmployeeList);
    }

    public void setDefaultOtherEmployeesAsReference(List defaultOtherEmployeeList) {
        this._defaultOtherEmployeeList = defaultOtherEmployeeList;
    }

    public void setDefaultWorker(ACLDocumentRefType defaultWorker) {
        this._defaultWorker = defaultWorker;
    }

    public void setDefaultWorkerType(DefaultWorkerType defaultWorkerType) {
        this._defaultWorkerType = defaultWorkerType;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setManualCreate(boolean manualCreate) {
        this._manualCreate = manualCreate;
        this._has_manualCreate = true;
    }

    public void setPrecedingPhase(PhaseTemplateRefType precedingPhase) {
        this._precedingPhase = precedingPhase;
    }

    public void setStatusListRef(ListRefType statusListRef) {
        this._statusListRef = statusListRef;
    }

    public void setTaskTemplate(int index, TaskTemplateType vTaskTemplate) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._taskTemplateList.size()) {
            throw new IndexOutOfBoundsException("setTaskTemplate: Index value '" + index + "' not in range [0.." + (this._taskTemplateList.size() - 1) + "]");
        }
        this._taskTemplateList.set(index, vTaskTemplate);
    }

    public void setTaskTemplates(TaskTemplateType[] vTaskTemplateArray) {
        this._taskTemplateList.clear();
        for (int i = 0; i < vTaskTemplateArray.length; ++i) {
            this._taskTemplateList.add(vTaskTemplateArray[i]);
        }
    }

    public void setTaskTemplates(List vTaskTemplateList) {
        this._taskTemplateList.clear();
        this._taskTemplateList.addAll(vTaskTemplateList);
    }

    public void setTaskTemplatesAsReference(List taskTemplateList) {
        this._taskTemplateList = taskTemplateList;
    }

    public void setWorkflowDefinition(String workflowDefinition) {
        this._workflowDefinition = workflowDefinition;
    }

    public static ReferenceableObjectType unmarshalPhaseTemplateType(Reader reader) throws MarshalException, ValidationException {
        return (ReferenceableObjectType)Unmarshaller.unmarshal(PhaseTemplateType.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

