/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdf.data.IBusinessObjectType;
import net.gopro.gdf.data.InlineMetaDataType;
import net.gopro.gdf.data.ReferenceableObjectType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class PhaseHistoryType
extends ReferenceableObjectType
implements Serializable,
IBusinessObjectType {
    private String _approver;
    private String _response;
    private Date _date;
    private String _comment;
    private String _stepName;
    private List _dataFieldList = new ArrayList();
    private String _mapName;
    private static final long serialVersionUID = 15000L;

    public void addDataField(InlineMetaDataType vDataField) throws IndexOutOfBoundsException {
        this._dataFieldList.add(vDataField);
    }

    public void addDataField(int index, InlineMetaDataType vDataField) throws IndexOutOfBoundsException {
        this._dataFieldList.add(index, vDataField);
    }

    public Enumeration enumerateDataFields() {
        return Collections.enumeration(this._dataFieldList);
    }

    public String getApprover() {
        return this._approver;
    }

    public String getComment() {
        return this._comment;
    }

    public InlineMetaDataType getDataField(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._dataFieldList.size()) {
            throw new IndexOutOfBoundsException("getDataField: Index value '" + index + "' not in range [0.." + (this._dataFieldList.size() - 1) + "]");
        }
        return (InlineMetaDataType)this._dataFieldList.get(index);
    }

    public InlineMetaDataType[] getDataFields() {
        InlineMetaDataType[] array = new InlineMetaDataType[]{};
        return this._dataFieldList.toArray(array);
    }

    public List getDataFieldsAsReference() {
        return this._dataFieldList;
    }

    public int getDataFieldsCount() {
        return this._dataFieldList.size();
    }

    public Date getDate() {
        return this._date;
    }

    public String getMapName() {
        return this._mapName;
    }

    public String getResponse() {
        return this._response;
    }

    public String getStepName() {
        return this._stepName;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateDataFields() {
        return this._dataFieldList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(handler);
            marshaller.setEncoding("UTF-8");
            marshaller.marshal((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeAllDataFields() {
        this._dataFieldList.clear();
    }

    public boolean removeDataField(InlineMetaDataType vDataField) {
        boolean removed = this._dataFieldList.remove(vDataField);
        return removed;
    }

    public InlineMetaDataType removeDataFieldAt(int index) {
        Object obj = this._dataFieldList.remove(index);
        return (InlineMetaDataType)obj;
    }

    public void setApprover(String approver) {
        this._approver = approver;
    }

    public void setComment(String comment) {
        this._comment = comment;
    }

    public void setDataField(int index, InlineMetaDataType vDataField) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._dataFieldList.size()) {
            throw new IndexOutOfBoundsException("setDataField: Index value '" + index + "' not in range [0.." + (this._dataFieldList.size() - 1) + "]");
        }
        this._dataFieldList.set(index, vDataField);
    }

    public void setDataFields(InlineMetaDataType[] vDataFieldArray) {
        this._dataFieldList.clear();
        for (int i = 0; i < vDataFieldArray.length; ++i) {
            this._dataFieldList.add(vDataFieldArray[i]);
        }
    }

    public void setDataFields(List vDataFieldList) {
        this._dataFieldList.clear();
        this._dataFieldList.addAll(vDataFieldList);
    }

    public void setDataFieldsAsReference(List dataFieldList) {
        this._dataFieldList = dataFieldList;
    }

    public void setDate(Date date) {
        this._date = date;
    }

    public void setMapName(String mapName) {
        this._mapName = mapName;
    }

    public void setResponse(String response) {
        this._response = response;
    }

    public void setStepName(String stepName) {
        this._stepName = stepName;
    }

    public static ReferenceableObjectType unmarshalPhaseHistoryType(Reader reader) throws MarshalException, ValidationException {
        return (ReferenceableObjectType)Unmarshaller.unmarshal(PhaseHistoryType.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

